/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.restriction.helper;

import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.RestrictionGroupType;
import com.gridnine.xtrip.common.restriction.RestrictionValue;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionQueryable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyCondition;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxyBuilder;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionsHelper {
    private static final Logger log = LoggerFactory.getLogger(RestrictionsHelper.class);

    public static Boolean getMatch(RestrictionResourceProxy proxy, Collection<RestrictionGroup> restrictionGroups, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        return RestrictionsHelper.getMatch(proxy, restrictionGroups, userId, handlers, RestrictionResourcesRegistry.get());
    }

    public static Boolean getMatch(RestrictionResourceProxy proxy, Collection<RestrictionGroup> restrictionGroups, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) throws Exception {
        Boolean match = null;
        for (RestrictionGroup restrictionGroup : restrictionGroups) {
            Boolean groupMatch = RestrictionsHelper.getMatch(proxy, restrictionGroup, userId, handlers, registry);
            if (groupMatch == null) continue;
            Boolean bl = match != null ? Boolean.valueOf(match != false && groupMatch != false) : (match = groupMatch);
            if (groupMatch.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return match;
    }

    private static Boolean getMatch(RestrictionResourceProxy proxy, RestrictionGroup restrictionGroup, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) throws Exception {
        log.debug(String.format("checking restriction group %s", restrictionGroup.getType()));
        if (restrictionGroup.getType() == RestrictionGroupType.SIMPLE) {
            RestrictionValue restrictionValue = (RestrictionValue)restrictionGroup.getValue();
            String propertyId = restrictionValue.getPropertyId();
            if (propertyId == null) {
                log.debug(String.format("property id of restriction vaue is null, returning null", new Object[0]));
                return null;
            }
            String conditionId = restrictionValue.getConditionId();
            if (conditionId == null) {
                log.debug(String.format("condition id of restriction value is null, returning null", new Object[0]));
                return null;
            }
            log.debug(String.format("checking property restriction of property %s", propertyId));
            RestrictionResourceProperty property = registry.getProperty(propertyId);
            if (property == null) {
                log.debug(String.format("property %s is not registered, returning null", propertyId));
                return null;
            }
            RestrictionResourcePropertyCondition condition = registry.getCondition(conditionId);
            if (condition == null) {
                log.debug(String.format("condition %s is not registered, returning null", conditionId));
                return null;
            }
            if (property instanceof RestrictionMatchable) {
                log.debug(String.format("property %s is matchable", property.getId()));
                log.debug(String.format("checking proxies", new Object[0]));
                for (RestrictionResourceProxy parentProxy = proxy; parentProxy != null; parentProxy = parentProxy.getParent()) {
                    log.debug(String.format("checking proxy of resource %s", parentProxy.getResourceId()));
                    if (property.getResourceId().equals(parentProxy.getResourceId())) {
                        log.debug(String.format("proxy of resource %s conforms property %s", parentProxy.getResourceId(), property.getId()));
                        boolean match = false;
                        if (restrictionValue.getValue() instanceof RestrictionValue.DynamicValue) {
                            log.debug(String.format("value of restriction value is dynamic value", new Object[0]));
                            RestrictionValue.DynamicValue dynamicValue = (RestrictionValue.DynamicValue)restrictionValue.getValue();
                            String dynamicValueHandlerId = dynamicValue.getHandlerId();
                            if (dynamicValueHandlerId == null) {
                                log.debug(String.format("dynamic value handler id is null, returning null", new Object[0]));
                                return null;
                            }
                            RestrictionResourcePropertyDynamicValueHandler dynamicValueHandler = Stream.concat(registry.getDynamicValueHandlers().stream(), handlers.stream()).filter(item -> item.getId().equals(dynamicValueHandlerId)).findFirst().orElse(null);
                            if (dynamicValueHandler == null) {
                                log.debug(String.format("dynamic value handler %s is not registered, returning null", dynamicValueHandlerId));
                                return null;
                            }
                            try {
                                match = dynamicValueHandler.match(property, parentProxy, condition, restrictionValue.getValue(), userId);
                            }
                            catch (Exception e) {
                                log.error(String.format("shit happens on dynamic matching of %s %s %s (%s)", propertyId, conditionId, restrictionValue.getValue(), userId));
                                throw e;
                            }
                        }
                        log.debug(String.format("value of restriction value is simple value", new Object[0]));
                        String valueHandlerId = registry.getPropertyConditionValueHandler(propertyId, conditionId);
                        if (valueHandlerId == null) {
                            log.debug(String.format("value handler id is null, returning null", new Object[0]));
                            return null;
                        }
                        RestrictionResourcePropertyValueHandler valueHandler = registry.getValueHandler(valueHandlerId);
                        if (valueHandler == null) {
                            log.debug(String.format("value handler %s is not registered, returning null", valueHandlerId));
                            return null;
                        }
                        try {
                            match = valueHandler.match(property, parentProxy, condition, restrictionValue.getValue(), userId);
                        }
                        catch (Exception e) {
                            log.error(String.format("shit happens on simple matching of %s %s %s (%s)", propertyId, conditionId, restrictionValue.getValue(), userId));
                            throw e;
                        }
                        if (match) {
                            log.debug(String.format("proxy for property %s is matched", property.getId()));
                            return Boolean.TRUE;
                        }
                        log.debug(String.format("proxy for property %s is not matched", property.getId()));
                        return Boolean.FALSE;
                    }
                    log.debug(String.format("proxy of resource %s not conforms property %s", parentProxy.getResourceId(), property.getId()));
                    log.debug(String.format("using parent proxy %s", parentProxy != null ? String.format("of resource %s", parentProxy.getResourceId()) : null));
                }
                log.error(String.format("proxy of resource %s conforming property %s not found", property.getResourceId(), property.getId()));
                throw new Exception(String.format("proxy of resource %s conforming property %s not found", property.getResourceId(), property.getId()));
            }
            log.debug(String.format("property %s is not matchable", property.getId()));
            return null;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.NOT) {
            Boolean match = null;
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                Boolean groupMatch = RestrictionsHelper.getMatch(proxy, group, userId, handlers, registry);
                if (groupMatch == null) continue;
                Boolean bl = match != null ? Boolean.valueOf(match != false || groupMatch != false) : (match = groupMatch);
                if (!groupMatch.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return match;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.AND) {
            Boolean match = null;
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                Boolean groupMatch = RestrictionsHelper.getMatch(proxy, group, userId, handlers, registry);
                if (groupMatch == null) continue;
                Boolean bl = match != null ? Boolean.valueOf(match != false && groupMatch != false) : (match = groupMatch);
                if (groupMatch.booleanValue()) continue;
                return Boolean.FALSE;
            }
            return match;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.OR) {
            Boolean match = null;
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                Boolean groupMatch = RestrictionsHelper.getMatch(proxy, group, userId, handlers, registry);
                if (groupMatch == null) continue;
                Boolean bl = match != null ? Boolean.valueOf(match != false || groupMatch != false) : (match = groupMatch);
                if (!groupMatch.booleanValue()) continue;
                return Boolean.TRUE;
            }
            return match;
        }
        return null;
    }

    public static Map<String, RestrictionResourceProxy> buildProxies(EntityContainer<?> entityContainer, String resourceId) throws Exception {
        return RestrictionsHelper.buildProxies(entityContainer.getEntity(), entityContainer.getUid(), resourceId, RestrictionResourcesRegistry.get());
    }

    public static Map<String, RestrictionResourceProxy> buildProxies(EntityContainer<?> entityContainer, String resourceId, RestrictionResourcesRegistry registry) throws Exception {
        return RestrictionsHelper.buildProxies(entityContainer.getEntity(), entityContainer.getUid(), resourceId, registry);
    }

    public static Map<String, RestrictionResourceProxy> buildProxies(Object object, String resourceId) throws Exception {
        return RestrictionsHelper.buildProxies(object, null, resourceId, RestrictionResourcesRegistry.get());
    }

    public static Map<String, RestrictionResourceProxy> buildProxies(Object object, String containerUid, String resourceId, RestrictionResourcesRegistry registry) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("building proxies for " + (object != null ? object.getClass().getName() : null) + " using resource " + resourceId);
        }
        RestrictionsHelper.requireNonNull(object, () -> "object is null");
        RestrictionsHelper.requireNonNull(resourceId, () -> "resource id is null");
        RestrictionsHelper.requireNonNull(registry, () -> "registry is null");
        resourceId = RestrictionsHelper.lookupResourceId(resourceId, registry);
        if (resourceId == null) {
            if (log.isDebugEnabled()) {
                log.debug("resources is not registered, returning empty map");
            }
            return Collections.emptyMap();
        }
        if (registry.getResource(resourceId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("resource %s is not found, returning empty map", resourceId));
            }
            return Collections.emptyMap();
        }
        HashMap<String, RestrictionResourceProxy> proxies = new HashMap<String, RestrictionResourceProxy>();
        RestrictionsHelper.buildProxies(object, containerUid, resourceId, null, proxies, registry);
        return proxies;
    }

    public static String lookupResourceId(String resourceId, RestrictionResourcesRegistry registry) throws Exception {
        RestrictionsHelper.requireNonNull(resourceId, () -> "resource id is null");
        if (registry.getResource(resourceId) != null) {
            return resourceId;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("resource %s is not registered, checking meta registry", resourceId));
        }
        String result = RestrictionsHelper.getExtendsId(resourceId);
        while (result != null) {
            log.debug(String.format("checking meta resource %s", result));
            if (registry.getResource(result) != null) {
                return result;
            }
            log.debug(String.format("meta resource %s is not registered", result));
            result = RestrictionsHelper.getExtendsId(result);
            log.debug(String.format("using super resource %s", result));
        }
        return result;
    }

    private static String getExtendsId(String resourceId) {
        return Optional.ofNullable(MetaRegistry.get().getEntities().get(resourceId)).map(BaseClassType::getExtendsId).orElse(null);
    }

    private static void buildProxies(Object object, String containerUid, String resourceId, RestrictionResourceProxy parentProxy, Map<String, RestrictionResourceProxy> proxies, RestrictionResourcesRegistry registry) throws Exception {
        RestrictionResource resource = registry.getResource(resourceId);
        RestrictionsHelper.requireNonNull(resource, () -> "resource " + resourceId + " is not found");
        String resourceProxyBuilderId = registry.getResourceProxyBuilder(resourceId);
        if (resourceProxyBuilderId == null) {
            if (log.isDebugEnabled()) {
                log.debug("resource proxy builder for resource " + resourceId + " is not found");
            }
            Collection resourceChildIds = registry.getResourceChildren(resourceId);
            for (String resourceChildId : resourceChildIds) {
                RestrictionsHelper.buildProxies(object, containerUid, resourceChildId, parentProxy, proxies, registry);
            }
        } else {
            RestrictionResourceProxyBuilder resourceProxyBuilder = registry.getProxyBuilder(resourceProxyBuilderId);
            RestrictionsHelper.requireNonNull(resourceProxyBuilder, () -> "resource proxy builder " + resourceProxyBuilderId + " is not found");
            for (RestrictionResourceProxy proxy : resourceProxyBuilder.build(object, containerUid, parentProxy, registry)) {
                proxies.put(proxy.getId(), proxy);
                Collection resourceChildIds = registry.getResourceChildren(resourceId);
                for (String resourceChildId : resourceChildIds) {
                    RestrictionsHelper.buildProxies(object, containerUid, resourceChildId, proxy, proxies, registry);
                }
            }
        }
    }

    public static List<SearchCriterion> getCriterions(Collection<RestrictionGroup> restrictionGroups, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        return RestrictionsHelper.getCriterions(restrictionGroups, userId, handlers, RestrictionResourcesRegistry.get());
    }

    public static List<SearchCriterion> getCriterions(Collection<RestrictionGroup> restrictionGroups, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) throws Exception {
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        for (RestrictionGroup restrictionGroup : restrictionGroups) {
            SearchCriterion criterion = RestrictionsHelper.getCriterion(restrictionGroup, userId, handlers, registry);
            if (criterion == null) continue;
            criterions.add(criterion);
        }
        return criterions;
    }

    private static SearchCriterion getCriterion(RestrictionGroup restrictionGroup, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers, RestrictionResourcesRegistry registry) throws Exception {
        log.debug(String.format("checking restriction group %s", restrictionGroup.getType()));
        if (restrictionGroup.getType() == RestrictionGroupType.SIMPLE) {
            RestrictionValue restrictionValue = (RestrictionValue)restrictionGroup.getValue();
            String propertyId = restrictionValue.getPropertyId();
            if (propertyId == null) {
                log.debug(String.format("property id of restriction value is null, returning null", new Object[0]));
                return null;
            }
            String conditionId = restrictionValue.getConditionId();
            if (conditionId == null) {
                log.debug(String.format("condition id of restriction value is null, returning null", new Object[0]));
                return null;
            }
            log.debug(String.format("checking restriction of property %s", propertyId));
            RestrictionResourceProperty property = registry.getProperty(propertyId);
            if (property == null) {
                log.debug(String.format("property %s is not registered, returning null", propertyId));
                return null;
            }
            RestrictionResourcePropertyCondition condition = registry.getCondition(conditionId);
            if (condition == null) {
                log.debug(String.format("condition %s is not registered, returning null", conditionId));
                return null;
            }
            if (property instanceof RestrictionQueryable) {
                log.debug(String.format("property %s is queryable", property.getId()));
                SearchCriterion criterion = null;
                if (restrictionValue.getValue() instanceof RestrictionValue.DynamicValue) {
                    log.debug(String.format("value of restriction value is dynamic value", new Object[0]));
                    RestrictionValue.DynamicValue dynamicValue = (RestrictionValue.DynamicValue)restrictionValue.getValue();
                    String dynamicValueHandlerId = dynamicValue.getHandlerId();
                    if (dynamicValueHandlerId == null) {
                        log.debug(String.format("dynamic value handler id is null, returning null", new Object[0]));
                        return null;
                    }
                    RestrictionResourcePropertyDynamicValueHandler dynamicValueHandler = Stream.concat(registry.getDynamicValueHandlers().stream(), handlers.stream()).filter(item -> item.getId().equals(dynamicValueHandlerId)).findFirst().orElse(null);
                    if (dynamicValueHandler == null) {
                        log.debug(String.format("dynamic value handler %s is not registered, returning null", dynamicValueHandlerId));
                        return null;
                    }
                    criterion = dynamicValueHandler.getQuery(property, condition, restrictionValue.getValue(), userId);
                } else {
                    log.debug(String.format("value of restriction value is simple value", new Object[0]));
                    String valueHandlerId = registry.getPropertyConditionValueHandler(propertyId, conditionId);
                    if (valueHandlerId == null) {
                        log.debug(String.format("value handler id is null, returning null", new Object[0]));
                        return null;
                    }
                    RestrictionResourcePropertyValueHandler valueHandler = registry.getValueHandler(valueHandlerId);
                    if (valueHandler == null) {
                        log.debug(String.format("value handler %s is not registered, returning null", valueHandlerId));
                        return null;
                    }
                    criterion = valueHandler.getQuery(property, condition, restrictionValue.getValue(), userId);
                }
                if (criterion != null) {
                    log.debug(String.format("criterion of property %s is not empty", property.getId()));
                    return criterion;
                }
                log.debug(String.format("criterion of property %s is empty, returning null", property.getId()));
                return null;
            }
            log.debug(String.format("property %s is not queryable, returning null", property.getId()));
            return null;
        }
        if (restrictionGroup.getType() == RestrictionGroupType.NOT) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                SearchCriterion criterion = RestrictionsHelper.getCriterion(group, userId, handlers, registry);
                if (criterion == null) continue;
                criterions.add(SearchCriterion.not((SearchCriterion)criterion));
            }
            log.debug(String.format("restriction group %s collects %s criterions", restrictionGroup.getType(), String.valueOf(criterions.size())));
            return SearchCriterion.and((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()]));
        }
        if (restrictionGroup.getType() == RestrictionGroupType.AND) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                SearchCriterion criterion = RestrictionsHelper.getCriterion(group, userId, handlers, registry);
                if (criterion == null) continue;
                criterions.add(criterion);
            }
            log.debug(String.format("restriction group %s collects %s criterions", restrictionGroup.getType(), String.valueOf(criterions.size())));
            return SearchCriterion.and((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()]));
        }
        if (restrictionGroup.getType() == RestrictionGroupType.OR) {
            ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
            for (RestrictionGroup group : (List)restrictionGroup.getValue()) {
                SearchCriterion criterion = RestrictionsHelper.getCriterion(group, userId, handlers, registry);
                if (criterion == null) continue;
                criterions.add(criterion);
            }
            log.debug(String.format("restriction group %s collects %s criterions", restrictionGroup.getType(), String.valueOf(criterions.size())));
            return SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()]));
        }
        log.debug(String.format("restriction group %s is not supported, returning null", restrictionGroup.getType()));
        return null;
    }

    private static void requireNonNull(Object object, Supplier<String> errorMessageSupplier) throws Exception {
        if (object != null) {
            return;
        }
        String errorMessage = errorMessageSupplier.get();
        if (log.isErrorEnabled()) {
            log.error(errorMessage);
        }
        throw new Exception(errorMessage);
    }
}

