/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.rpc.service;

import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rpc.service.AuthService;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.rpc.service.UserInfo;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private static final Logger authLog = LoggerFactory.getLogger((String)"auth");

    public static String extractUserLoginFromToken(Serializable tokenObj) {
        String[] arr = AuthUtil.decryptToken((Serializable)tokenObj);
        if (arr == null) {
            throw new RuntimeException("Cannot get login name");
        }
        return arr[0];
    }

    public static boolean validateAuthToken(Serializable tokenObj) throws ServiceException {
        return AuthServiceImpl.validateAuthToken(tokenObj, false);
    }

    public static boolean validateAuthToken(Serializable tokenObj, boolean skipAclUserCheck) throws ServiceException {
        return AuthServiceImpl.validateAuthToken(AuthServiceImpl.getUserInfo(tokenObj), skipAclUserCheck);
    }

    public static boolean validateAuthToken(UserInfo user) throws ServiceException {
        return AuthServiceImpl.validateAuthToken(user, false);
    }

    public static boolean validateAuthToken(UserInfo user, boolean skipAclUserCheck) throws ServiceException {
        try {
            LogicalStorage.get().authorize(user.getLogin(), user.getPassword().toCharArray(), skipAclUserCheck);
            log.debug("auth token validated, user=" + user.getLogin());
            return true;
        }
        catch (GeneralSecurityException gse) {
            log.warn("auth token invalid, user=" + user.getLogin());
            return false;
        }
        catch (Exception e) {
            log.error("token validation failed", (Throwable)e);
            throw new ServiceException("token validation failed");
        }
    }

    public static UserInfo getUserInfo(Serializable tokenObj) {
        String[] decryptToken = AuthUtil.decryptToken((Serializable)tokenObj);
        if (Objects.isNull(decryptToken)) {
            throw new IllegalArgumentException("bad token");
        }
        return new UserInfo(decryptToken[0], decryptToken[1]);
    }

    public Serializable login(ServiceInvocationContext ctx, String userName, char[] password) throws ServiceException {
        return this.login(ctx, userName, password, false);
    }

    public Serializable login(ServiceInvocationContext ctx, String userName, char[] password, boolean skipAclUserCheck) throws ServiceException {
        String authToken;
        try {
            if (ctx != null && ctx.getLocale() != null) {
                LocaleManager lm = LocaleManager.get();
                if (lm.isSupportedLocale(ctx.getLocale())) {
                    lm.setCurrentLocale(ctx.getLocale());
                } else {
                    log.warn(String.format("unsupported locale %s given in invocation context", ctx.getLocale()));
                }
            }
            LogicalStorage.get().authorize(userName, password, skipAclUserCheck);
        }
        catch (GeneralSecurityException gse) {
            authLog.debug("user " + userName + " can't logged in. invalid user credentials.");
            log.warn("invalid user credentials, user=" + userName);
            String message = gse.getMessage().contains("temporarily blocked") ? L10n.get((String)Messages.AuthServiceImpl_UserBlocked) : L10n.get((String)Messages.AuthServiceImpl_WrongUserOrPassword);
            throw new ServiceException(message);
        }
        catch (Exception e) {
            authLog.error("user " + userName + " can't logged in. login failed. " + String.valueOf(e.getMessage()));
            log.error("login failed", (Throwable)e);
            throw new ServiceException(L10n.get((String)Messages.AuthServiceImpl_AuthFault));
        }
        try {
            authToken = AuthUtil.buildAuthToken((String)userName, (char[])password);
        }
        catch (Exception e) {
            authLog.error("user " + userName + " can't logged in. failed building auth token.");
            log.error("failed building auth token", (Throwable)e);
            throw new ServiceException("failed building auth token");
        }
        authLog.info("user " + userName + " logged in successfully.");
        return authToken;
    }
}

