/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.rpc.service;

import com.gridnine.xtrip.common.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.ActionSource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.auth.AuthHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSecureServiceImpl {
    private static final boolean NON_STRICT_VERSIONS_CHECK = MiscUtil.isTrue((String)System.getProperty("rpc.nonStrictVersionsCheck"));
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    protected void checkContext(ServiceInvocationContext ctx, boolean ignoreVersionMismatch) throws ServiceException {
        LogicalStorage.get().setSessionToken(ctx.getSessionToken());
        if (ctx.getLocale() != null) {
            LocaleManager lm = LocaleManager.get();
            if (lm.isSupportedLocale(ctx.getLocale())) {
                lm.setCurrentLocale(ctx.getLocale());
            } else {
                this.log.warn(String.format("unsupported locale %s given in invocation context", ctx.getLocale()));
            }
        }
        if (ctx.getActionSource() == ActionSource.MIDOFFICE_CLIENT) {
            throw new ServiceException("the server does not support the old client");
        }
        if (!AuthHelper.validateAuthToken(ctx.getAuthToken())) {
            throw new ServiceException("authorization failed");
        }
        if (ctx.getUser() != null && !AuthHelper.extractUserLoginFromToken(ctx.getAuthToken()).equals(ctx.getUser())) {
            throw new ServiceException("authorization failed");
        }
        if (ignoreVersionMismatch) {
            return;
        }
        UpdateIndexFile serverIndexFile = UpdateIndexFile.get();
        if (NON_STRICT_VERSIONS_CHECK && (ctx.getCheckSumCommonPlugins() == null || serverIndexFile.getCheckSumCommonPlugins() == null)) {
            return;
        }
        if (MiscUtil.isTrue((String)System.getProperty("BaseSecureServiceImpl.checkTimeContext"))) {
            String serverTimezone;
            String serverTimezoneDataVersion;
            try {
                serverTimezoneDataVersion = MiscUtil.getTimezoneDataVersion();
            }
            catch (Exception ex) {
                throw new ServiceException("getTimezoneDataVersion failed", (Throwable)ex);
            }
            if (!MiscUtil.equals((Object)serverTimezoneDataVersion, (Object)ctx.getTimezoneDataVersion())) {
                // empty if block
            }
            if (!MiscUtil.equals((Object)(serverTimezone = System.getProperty("user.timezone")), (Object)ctx.getTimezone())) {
                throw Xeption.forEndUser((String)"client timezone {0} differs from the server one {1}", (Object[])new Object[]{ctx.getTimezone(), serverTimezone});
            }
        }
        if (!MiscUtil.equals((Object)ctx.getCheckSumCommonPlugins(), (Object)serverIndexFile.getCheckSumCommonPlugins())) {
            this.log.debug(String.format("client version %s differs from the server one %s", ctx.getCheckSumCommonPlugins(), serverIndexFile.getCheckSumCommonPlugins()));
            throw Xeption.forEndUser((String)L10n.get((String)Messages.BaseSecureServiceImpl_clientVersionDiffersFromTheServer), (Object[])new Object[0]);
        }
    }

    protected void checkContext(ServiceInvocationContext ctx) throws ServiceException {
        this.checkContext(ctx, false);
    }

    /*
     * Exception decompiling
     */
    protected <V> V doIt(ServiceInvocationContext ctx, Callable<V> body) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getUserMessage(Throwable t) {
        Xeption ue = this.findEndUserException(t);
        if (ue != null) {
            return ue.toString();
        }
        return t.getMessage();
    }

    protected Xeption findEndUserException(Throwable t) {
        if (t instanceof Xeption) {
            return (Xeption)t;
        }
        if (t.getCause() == null) {
            return null;
        }
        return this.findEndUserException(t.getCause());
    }

    protected ServiceException createPermissionDeniedException(String user, RestrictionResourceOperation operation, String resourceId, String resourceDescription) {
        return new ServiceException("\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a " + resourceDescription + " (" + resourceId + "), \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0443", (Throwable)Xeption.forAdmin((String)"\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a \u0440\u0435\u0441\u0443\u0440\u0441\u0443, \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c={0}, \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f={1} ({2}), \u0440\u0435\u0441\u0443\u0440\u0441={3} ({4})", (Object[])new Object[]{user, operation.getName(), operation.getId(), resourceDescription, resourceId}));
    }
}

