/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.scheduler;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.Service;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.jms.JMSFacade;
import com.gridnine.xtrip.server.scheduler.ScheduledTaskSettingUpdateData;
import com.gridnine.xtrip.server.scheduler.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTaskSettingsInterceptor
implements EntityInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 0.0;
    }

    @Override
    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        ScheduledTaskSettingUpdateData message;
        EntityContainer<? extends BaseEntity> oldCtr;
        if (!data.getEntity().getClass().equals(ScheduledTaskSettings.class)) {
            return;
        }
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        EntityContainer<? extends BaseEntity> oldSettingsCtr = oldCtr = LogicalStorage.get().getEntityStorage().getLocalOperationContext(data.toReference()).getOldCtr();
        EntityContainer<?> newSettingsCtr = data;
        this.definitionIncorrectSettings(newSettingsCtr);
        if (this.isLocalTask(oldSettingsCtr) || this.isLocalTask(newSettingsCtr)) {
            message = new ScheduledTaskSettingUpdateData();
            if (this.isLocalTask(oldSettingsCtr)) {
                message.setOldData(oldSettingsCtr);
            }
            if (this.isLocalTask(newSettingsCtr)) {
                message.setNewData(newSettingsCtr);
            }
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("scheduled-tasks-settings", message);
        }
        if (this.isGlobalTask(oldSettingsCtr) || this.isGlobalTask(newSettingsCtr)) {
            message = new ScheduledTaskSettingUpdateData();
            if (this.isGlobalTask(oldSettingsCtr)) {
                message.setOldData(oldSettingsCtr);
            }
            if (this.isGlobalTask(newSettingsCtr)) {
                message.setNewData(newSettingsCtr);
            }
            this.updateGlobalTaskSettings(message);
        }
    }

    private void definitionIncorrectSettings(EntityContainer<ScheduledTaskSettings> scheduledTaskSettingsCtr) {
        ScheduledTaskSettings scheduledTaskSettings = (ScheduledTaskSettings)scheduledTaskSettingsCtr.getEntity();
        if (scheduledTaskSettings.isLocal() && TextUtil.nonBlank((String)scheduledTaskSettings.getInstallationId())) {
            IncidentsLog.reportStackTrace((String)String.format("%s with name=%s and ctrUid=%s is local and has installationId=%s", MiscUtil.getSimpleClassName(scheduledTaskSettings.getClass()), scheduledTaskSettings.getName(), scheduledTaskSettingsCtr.getUid(), scheduledTaskSettings.getInstallationId()));
        }
    }

    private void updateGlobalTaskSettings(ScheduledTaskSettingUpdateData message) throws Exception {
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        this.log.debug("upating global task: " + message);
        SchedulerService schedulerService = null;
        for (Service item : ((ServerApplication)Environment.getPublished(ServerApplication.class)).getServiceList()) {
            if (!"scheduler-service".equals(item.getUid())) continue;
            schedulerService = (SchedulerService)item;
            break;
        }
        if (schedulerService == null) {
            return;
        }
        EntityContainer<ScheduledTaskSettings> oldData = message.getOldData();
        EntityContainer<ScheduledTaskSettings> newData = message.getNewData();
        if (oldData != null && newData == null) {
            schedulerService.unscheduleTask(oldData.getUid(), (ScheduledTaskSettings)oldData.getEntity());
        }
        if (newData != null) {
            schedulerService.scheduleTask(newData.getUid(), (ScheduledTaskSettings)newData.getEntity());
        }
        this.log.debug("global task successfully updated");
    }

    private boolean isGlobalTask(EntityContainer<ScheduledTaskSettings> settingsCtr) {
        return settingsCtr != null && !((ScheduledTaskSettings)settingsCtr.getEntity()).isLocal() && ((ScheduledTaskSettings)settingsCtr.getEntity()).isEnabled();
    }

    private boolean isLocalTask(EntityContainer<ScheduledTaskSettings> settingsCtr) {
        return settingsCtr != null && ((ScheduledTaskSettings)settingsCtr.getEntity()).isLocal() && ((ScheduledTaskSettings)settingsCtr.getEntity()).isEnabled();
    }

    @Override
    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
        if (!data.getEntity().getClass().equals(ScheduledTaskSettings.class)) {
            return;
        }
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        EntityContainer<?> settingsCtr = data;
        ScheduledTaskSettingUpdateData message = new ScheduledTaskSettingUpdateData();
        message.setOldData(settingsCtr);
        if (this.isLocalTask(settingsCtr)) {
            ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("scheduled-tasks-settings", message);
            return;
        }
        if (this.isGlobalTask(settingsCtr)) {
            this.updateGlobalTaskSettings(message);
        }
    }
}

