/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.scheduler;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.jms.JMSTopicListener;
import com.gridnine.xtrip.server.scheduler.ScheduledTaskSettingUpdateData;
import com.gridnine.xtrip.server.scheduler.SchedulerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTasksSettingsJMSListener
implements JMSTopicListener<ScheduledTaskSettingUpdateData> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String TOPIC_ID = "scheduled-tasks-settings";

    @Override
    public void onMessage(ScheduledTaskSettingUpdateData message) {
        this.log.debug("recieved message: " + message);
        try {
            EntityContainer<ScheduledTaskSettings> newData;
            SchedulerService schedulerService = (SchedulerService)((ServerApplication)Environment.getPublished(ServerApplication.class)).getService("scheduler-service");
            EntityContainer<ScheduledTaskSettings> oldData = message.getOldData();
            if (this.isLocalTask(oldData)) {
                schedulerService.unscheduleTask(oldData.getUid(), (ScheduledTaskSettings)oldData.getEntity());
            }
            if (this.isLocalTask(newData = message.getNewData())) {
                schedulerService.scheduleTask(newData.getUid(), (ScheduledTaskSettings)newData.getEntity());
            }
            this.log.debug("message successfully processed");
        }
        catch (Exception e) {
            this.log.error("unable to update task schedule", (Throwable)e);
        }
    }

    private boolean isLocalTask(EntityContainer<ScheduledTaskSettings> settingsCtr) {
        return settingsCtr != null && ((ScheduledTaskSettings)settingsCtr.getEntity()).isLocal() && ((ScheduledTaskSettings)settingsCtr.getEntity()).isEnabled();
    }
}

