/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.scheduler;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gracefulstop.GracefulStoppable;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettingsIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ScheduledTasksMonitor;
import com.gridnine.xtrip.server.Service;
import com.gridnine.xtrip.server.scheduler.MisfireLogger;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.java.plugin.util.ExtendedProperties;
import org.quartz.CalendarIntervalTrigger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.listeners.SchedulerListenerSupport;
import org.quartz.spi.JobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerService
implements Service,
GracefulStoppable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Scheduler localScheduler;
    protected Scheduler globalScheduler;
    public static final String UID = "scheduler-service";
    private boolean disabled;
    private final AtomicBoolean paused = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final AtomicBoolean shuttingDown = new AtomicBoolean();
    private static final String QUARTZ_INSTANCE_ID = "org.quartz.scheduler.instanceId";
    private volatile long blockedTimeout = 120000L;
    private volatile long checkTimeout = 25000L;
    private final Thread checker = new Thread("scheduler-service-maintain"){

        @Override
        public void run() {
            try {
                while (!SchedulerService.this.isStopped()) {
                    try {
                        try {
                            if (SchedulerService.this.checkPause()) {
                                if (!SchedulerService.this.isPaused()) {
                                    SchedulerService.this.pause();
                                }
                            } else if (SchedulerService.this.isPaused()) {
                                SchedulerService.this.resume();
                            }
                            SchedulerService.this.checkBlocked();
                        }
                        catch (Throwable t) {
                            SchedulerService.this.log.error("an unexpected error has occurred: " + t.getMessage(), t);
                        }
                        3.sleep(SchedulerService.this.checkTimeout);
                    }
                    catch (InterruptedException e) {
                        SchedulerService.this.log.warn("scheduler maintain thread interrupted");
                        break;
                    }
                    catch (Throwable t) {
                        SchedulerService.this.log.error("an unexpected error has occurred: " + t.getMessage(), t);
                    }
                }
            }
            catch (Throwable t) {
                SchedulerService.this.log.error("an unexpected error has occurred: " + t.getMessage(), t);
            }
        }
    };

    @Override
    public String getUid() {
        return UID;
    }

    protected boolean isPaused() {
        return this.paused.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public void configure(ExtendedProperties config) throws Exception {
        ExtendedProperties configuration = config.getSubset("scheduler.");
        this.checkTimeout = Long.parseLong(configuration.getProperty("check.timeout", Long.toString(this.checkTimeout)));
        this.blockedTimeout = Long.parseLong(configuration.getProperty("blocked.timeout", Long.toString(this.blockedTimeout)));
        if ("true".equals(configuration.getProperty("disabled"))) {
            this.log.info("scheduler service is disabled");
            this.disabled = true;
            return;
        }
        Map<String, String> dbDecodePassMap = SchedulerService.getDbDecodePassMap(config);
        this.localScheduler = new StdSchedulerFactory(SchedulerService.getSchedulerConfiguration(configuration, "local", dbDecodePassMap)).getScheduler();
        this.log.debug("configured local scheduler");
        this.globalScheduler = new StdSchedulerFactory(SchedulerService.getSchedulerConfiguration(configuration, "global", dbDecodePassMap)).getScheduler();
        this.localScheduler.getListenerManager().addSchedulerListener((SchedulerListener)new SchedulerListenerSupport(){

            public void schedulerError(String msg, SchedulerException cause) {
                SchedulerService.this.schedulerError(SchedulerService.this.localScheduler, msg, cause);
            }
        });
        this.globalScheduler.getListenerManager().addTriggerListener((TriggerListener)new MisfireLogger());
        this.globalScheduler.getListenerManager().addSchedulerListener((SchedulerListener)new SchedulerListenerSupport(){

            public void schedulerError(String msg, SchedulerException cause) {
                SchedulerService.this.schedulerError(SchedulerService.this.globalScheduler, msg, cause);
            }
        });
        this.log.debug("configured global scheduler");
        this.scheduleTasks();
    }

    private static Map<String, String> getDbDecodePassMap(ExtendedProperties config) throws Exception {
        String dbPassKey = "db.password";
        HashMap<String, String> result = new HashMap<String, String>();
        if (config.containsKey((Object)dbPassKey)) {
            String encodedPass = config.getProperty(dbPassKey);
            String decodedPass = DesUtil.decode((String)encodedPass);
            result.put(dbPassKey, decodedPass);
        }
        return result;
    }

    private static Properties getSchedulerConfiguration(ExtendedProperties configuration, String schedulerType, Map<String, String> dbDecodePassMap) throws Exception {
        String instanceId;
        Properties properties = new Properties();
        properties.load(SchedulerService.class.getResourceAsStream("quartz.properties"));
        properties.putAll((Map<?, ?>)configuration.getSubset(String.format("%s.", schedulerType)));
        if (!dbDecodePassMap.isEmpty()) {
            properties.putAll(dbDecodePassMap);
        }
        if ("AUTO".equalsIgnoreCase(instanceId = properties.getProperty(QUARTZ_INSTANCE_ID)) && TextUtil.nonBlank((String)(instanceId = Environment.getApplicationId()))) {
            properties.put(QUARTZ_INSTANCE_ID, instanceId);
        }
        return properties;
    }

    protected void schedulerError(Scheduler scheduler, String msg, SchedulerException cause) {
        this.log.error(msg, (Throwable)cause);
        if (cause instanceof JobPersistenceException) {
            try {
                this.log.info("reschedule tasks");
                scheduler.clear();
                this.scheduleTasks();
            }
            catch (Exception e) {
                this.log.error("Error while reschedule tasks", (Throwable)e);
            }
        }
    }

    public void scheduleTasks() throws Exception {
        if (this.checkStopped()) {
            return;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ScheduledTaskSettingsIndex.Property.enabled.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)ScheduledTaskSettingsIndex.Property.installationId.name()), SearchCriterion.eq((String)ScheduledTaskSettingsIndex.Property.installationId.name(), (Object)Environment.getApplicationId()), SearchCriterion.eq((String)ScheduledTaskSettingsIndex.Property.local.name(), null), SearchCriterion.eq((String)ScheduledTaskSettingsIndex.Property.local.name(), (Object)Boolean.FALSE)}));
        EntityStorage entityCache = EntityStorage.get();
        boolean attempt = true;
        block3: while (true) {
            for (ScheduledTaskSettingsIndex idx : EntityStorage.get().search(ScheduledTaskSettingsIndex.class, query).getData()) {
                EntityContainer ctr = entityCache.resolve(idx.getSource());
                if (null == ctr) {
                    this.log.error("failed to resolve scheduling task from settings " + idx.getSource());
                    continue;
                }
                try {
                    this.scheduleTask(ctr.getUid(), (ScheduledTaskSettings)ctr.getEntity());
                    this.log.debug("scheduled task from settings " + ctr.getEntity());
                }
                catch (JobPersistenceException e) {
                    this.log.error("failed scheduling task from settings " + ctr.getEntity(), (Throwable)e);
                    if (!attempt) continue;
                    this.log.info("reschedule tasks");
                    this.localScheduler.clear();
                    this.globalScheduler.clear();
                    attempt = false;
                    continue block3;
                }
                catch (Throwable e) {
                    this.log.error("failed scheduling task from settings " + ctr.getEntity(), e);
                }
            }
            break;
        }
    }

    public void clear() throws Exception {
        if (this.checkStopped()) {
            return;
        }
        this.localScheduler.clear();
        this.globalScheduler.clear();
    }

    protected boolean checkStopped() {
        boolean state = this.isStopped();
        if (state) {
            this.log.warn("service stopped");
        }
        return state;
    }

    public void scheduleTask(String uid, ScheduledTaskSettings settings) throws Exception {
        Scheduler antagonist;
        if (this.checkStopped()) {
            return;
        }
        if (!settings.isEnabled()) {
            return;
        }
        if (settings.isLocal() && !TextUtil.isBlank((String)settings.getInstallationId()) && !Environment.getApplicationId().equals(settings.getInstallationId())) {
            this.localScheduler.unscheduleJob(new TriggerKey(uid));
            return;
        }
        JobBuilder jobBuilder = JobBuilder.newJob();
        jobBuilder.ofType(Class.forName(settings.getJobClass()));
        jobBuilder.withIdentity(uid);
        jobBuilder.withDescription(settings.getName());
        for (NamedValue nv : settings.getDataMap()) {
            jobBuilder.usingJobData(nv.getName(), nv.getValue());
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withIdentity(uid);
        triggerBuilder.withDescription(settings.getName());
        if (settings.getDelay() != null) {
            triggerBuilder.startAt(new Date(System.currentTimeMillis() + settings.getDelay()));
        } else {
            triggerBuilder.startNow();
        }
        if (settings.getCron() != null) {
            triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)settings.getCron()).withMisfireHandlingInstructionIgnoreMisfires());
        } else if (settings.getPeriod() != null) {
            triggerBuilder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(settings.getPeriod().longValue()).repeatForever().withMisfireHandlingInstructionIgnoreMisfires());
        }
        Scheduler scheduler = settings.isLocal() ? this.localScheduler : this.globalScheduler;
        Scheduler scheduler2 = antagonist = !settings.isLocal() ? this.localScheduler : this.globalScheduler;
        if (antagonist != scheduler) {
            antagonist.unscheduleJob(new TriggerKey(uid));
            ScheduledTasksMonitor.unscheduled(uid, settings);
        }
        JobDetail jobDetail = jobBuilder.build();
        Trigger trigger = triggerBuilder.build();
        boolean scheduleIt = true;
        JobDetail oldJobDetail = scheduler.getJobDetail(jobDetail.getKey());
        if (oldJobDetail != null) {
            if (!this.equalsJobDetails(oldJobDetail, jobDetail)) {
                scheduler.deleteJob(oldJobDetail.getKey());
            } else {
                List oldTriggers = scheduler.getTriggersOfJob(jobDetail.getKey());
                boolean diff = oldTriggers.size() == 0;
                for (Trigger oldTrigger : oldTriggers) {
                    if (this.equalsTriggers(oldTrigger, trigger)) continue;
                    diff = true;
                    break;
                }
                if (diff) {
                    scheduler.deleteJob(oldJobDetail.getKey());
                } else {
                    scheduleIt = false;
                }
            }
        }
        if (scheduleIt) {
            scheduler.scheduleJob(jobDetail, trigger);
            ScheduledTasksMonitor.scheduled(uid, settings);
        }
        this.log.debug(String.format("task %s scheduled %s", settings.toString(), settings.isLocal() ? "locally" : "globally"));
    }

    public void unscheduleTask(String uid, ScheduledTaskSettings settings) throws Exception {
        if (this.checkStopped()) {
            return;
        }
        if (settings.isLocal() && !TextUtil.isBlank((String)settings.getInstallationId()) && !Environment.getApplicationId().equals(settings.getInstallationId())) {
            return;
        }
        (settings.isLocal() ? this.localScheduler : this.globalScheduler).unscheduleJob(new TriggerKey(uid));
        ScheduledTasksMonitor.unscheduled(uid, settings);
        this.log.debug(String.format("task %s unscheduled", settings.toString()));
    }

    protected void pause() throws Exception {
        if (this.disabled || this.isStopped()) {
            return;
        }
        this.globalScheduler.standby();
        this.log.info("global scheduler paused");
        this.paused.set(true);
    }

    protected void resume() throws Exception {
        if (this.disabled || this.isStopped()) {
            return;
        }
        this.globalScheduler.start();
        this.log.info("global scheduler resumed");
        this.paused.set(false);
    }

    @Override
    public void start() throws Exception {
        if (this.disabled) {
            return;
        }
        this.localScheduler.start();
        this.log.info("started local scheduler");
        if (!this.checkPause()) {
            this.globalScheduler.start();
            this.log.info("started global scheduler");
        } else {
            this.pause();
        }
        this.checker.setDaemon(true);
        this.checker.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.disabled) {
            return;
        }
        this.stopped.set(true);
        boolean inProgress = this.shuttingDown.getAndSet(true);
        if (this.localScheduler != null) {
            if (!inProgress) {
                this.log.info("local scheduler shut down in progress...");
            }
            this.localScheduler.shutdown(true);
            this.log.info("local scheduler shut down");
            this.localScheduler = null;
        }
        if (this.globalScheduler != null) {
            if (!inProgress) {
                this.log.info("global scheduler shut down in progress...");
            }
            this.globalScheduler.shutdown(true);
            this.log.info("global scheduler shut down");
            this.globalScheduler = null;
        }
    }

    public void initiateShutdown() throws Exception {
        if (this.disabled) {
            return;
        }
        this.stopped.set(true);
        this.shuttingDown.set(true);
        if (this.localScheduler != null) {
            this.log.info("local scheduler shut down in progress...");
            this.localScheduler.standby();
        }
        if (this.globalScheduler != null) {
            this.log.info("global scheduler shut down in progress...");
            this.globalScheduler.standby();
        }
    }

    public boolean canStop() {
        return true;
    }

    private boolean equalsJobDetails(JobDetail one, JobDetail two) {
        if (one == null) {
            return two == null;
        }
        if (!MiscUtil.equals((Object)one.getKey(), (Object)two.getKey())) {
            return false;
        }
        if (!MiscUtil.equals((Object)one.getDescription(), (Object)two.getDescription())) {
            return false;
        }
        if (!MiscUtil.equals((Object)one.getJobClass(), (Object)two.getJobClass())) {
            return false;
        }
        return MiscUtil.equals((Object)one.getJobDataMap(), (Object)two.getJobDataMap());
    }

    private boolean equalsTriggers(Trigger one, Trigger two) {
        if (one == null) {
            return two == null;
        }
        if (!MiscUtil.equals(one.getClass(), two.getClass())) {
            return false;
        }
        if (!MiscUtil.equals((Object)one.getKey(), (Object)two.getKey())) {
            return false;
        }
        if (!MiscUtil.equals((Object)one.getDescription(), (Object)two.getDescription())) {
            return false;
        }
        if (one.getPriority() != two.getPriority()) {
            return false;
        }
        if (!MiscUtil.equals((Object)one.getCalendarName(), (Object)two.getCalendarName())) {
            return false;
        }
        if (!MiscUtil.equals((Object)one.getEndTime(), (Object)two.getEndTime())) {
            return false;
        }
        if (one.getMisfireInstruction() != two.getMisfireInstruction()) {
            return false;
        }
        if (one instanceof CalendarIntervalTrigger) {
            if (!MiscUtil.equals((Object)((CalendarIntervalTrigger)one).getRepeatIntervalUnit(), (Object)((CalendarIntervalTrigger)two).getRepeatIntervalUnit())) {
                return false;
            }
            if (((CalendarIntervalTrigger)one).getRepeatInterval() != ((CalendarIntervalTrigger)two).getRepeatInterval()) {
                return false;
            }
            if (((CalendarIntervalTrigger)one).getTimesTriggered() != ((CalendarIntervalTrigger)two).getTimesTriggered()) {
                return false;
            }
            if (!MiscUtil.equals((Object)((CalendarIntervalTrigger)one).getTimeZone(), (Object)((CalendarIntervalTrigger)two).getTimeZone())) {
                return false;
            }
            if (((CalendarIntervalTrigger)one).isPreserveHourOfDayAcrossDaylightSavings() != ((CalendarIntervalTrigger)two).isPreserveHourOfDayAcrossDaylightSavings()) {
                return false;
            }
            if (((CalendarIntervalTrigger)one).isSkipDayIfHourDoesNotExist() != ((CalendarIntervalTrigger)two).isSkipDayIfHourDoesNotExist()) {
                return false;
            }
        } else if (one instanceof CronTrigger) {
            if (!MiscUtil.equals((Object)((CronTrigger)one).getCronExpression(), (Object)((CronTrigger)two).getCronExpression())) {
                return false;
            }
            if (!MiscUtil.equals((Object)((CronTrigger)one).getTimeZone(), (Object)((CronTrigger)two).getTimeZone())) {
                return false;
            }
        } else if (one instanceof DailyTimeIntervalTrigger) {
            if (!MiscUtil.equals((Object)((DailyTimeIntervalTrigger)one).getRepeatIntervalUnit(), (Object)((DailyTimeIntervalTrigger)two).getRepeatIntervalUnit())) {
                return false;
            }
            if (((DailyTimeIntervalTrigger)one).getRepeatCount() != ((DailyTimeIntervalTrigger)two).getRepeatCount()) {
                return false;
            }
            if (((DailyTimeIntervalTrigger)one).getRepeatInterval() != ((DailyTimeIntervalTrigger)two).getRepeatInterval()) {
                return false;
            }
            if (!MiscUtil.equals((Object)((DailyTimeIntervalTrigger)one).getStartTimeOfDay(), (Object)((DailyTimeIntervalTrigger)two).getStartTimeOfDay())) {
                return false;
            }
            if (!MiscUtil.equals((Object)((DailyTimeIntervalTrigger)one).getEndTimeOfDay(), (Object)((DailyTimeIntervalTrigger)two).getEndTimeOfDay())) {
                return false;
            }
            if (!MiscUtil.equals((Object)((DailyTimeIntervalTrigger)one).getDaysOfWeek(), (Object)((DailyTimeIntervalTrigger)two).getDaysOfWeek())) {
                return false;
            }
        } else if (one instanceof SimpleTrigger) {
            if (((SimpleTrigger)one).getRepeatCount() != ((SimpleTrigger)two).getRepeatCount()) {
                return false;
            }
            if (((SimpleTrigger)one).getRepeatInterval() != ((SimpleTrigger)two).getRepeatInterval()) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void checkBlocked() throws SchedulerException, InterruptedException {
        LockUtil.lock((String)"scheduler-service-maintain", (long)2L, (TimeUnit)TimeUnit.SECONDS, () -> {
            for (TriggerKey key : this.globalScheduler.getTriggerKeys(null)) {
                Trigger trigger;
                Date nextFireTime;
                Trigger.TriggerState state = this.globalScheduler.getTriggerState(key);
                if (state != Trigger.TriggerState.BLOCKED || null == (nextFireTime = (trigger = this.globalScheduler.getTrigger(key)).getNextFireTime()) || MiscUtil.toLocalDateTime((Date)nextFireTime).plus(this.blockedTimeout, ChronoUnit.MILLIS).isAfter(LocalDateTime.now())) continue;
                try {
                    Field schedField = StdScheduler.class.getDeclaredField("sched");
                    schedField.setAccessible(true);
                    QuartzScheduler sched = (QuartzScheduler)schedField.get(this.globalScheduler);
                    Field resourceField = QuartzScheduler.class.getDeclaredField("resources");
                    resourceField.setAccessible(true);
                    QuartzSchedulerResources resources = (QuartzSchedulerResources)resourceField.get(sched);
                    JobStore jobStore = resources.getJobStore();
                    if (!JobStoreSupport.class.isInstance(jobStore)) continue;
                    JobStoreSupport jobStoreSupport = (JobStoreSupport)jobStore;
                    Method getDelegateMethod = JobStoreSupport.class.getDeclaredMethod("getDelegate", new Class[0]);
                    getDelegateMethod.setAccessible(true);
                    DriverDelegate driverDelegate = (DriverDelegate)getDelegateMethod.invoke((Object)jobStoreSupport, new Object[0]);
                    Method executeInLockMethod = Arrays.stream(JobStoreSupport.class.getDeclaredMethods()).filter(m -> "executeInLock".equals(m.getName())).findAny().orElseThrow(() -> new NoSuchMethodException(JobStoreSupport.class.getName() + ".executeInLock"));
                    Field lockTriggerAccessField = JobStoreSupport.class.getDeclaredField("LOCK_TRIGGER_ACCESS");
                    lockTriggerAccessField.setAccessible(true);
                    String lockTriggerAccess = (String)lockTriggerAccessField.get(null);
                    executeInLockMethod.setAccessible(true);
                    int count = (Integer)executeInLockMethod.invoke((Object)jobStore, lockTriggerAccess, conn -> {
                        try {
                            List ftj = driverDelegate.selectFiredTriggerRecords(conn, key.getName(), key.getGroup());
                            return ftj.size();
                        }
                        catch (SQLException e) {
                            throw new JobPersistenceException("select fired triggers failed for key '" + key + "': " + e.getMessage(), (Throwable)e);
                        }
                    });
                    if (count != 0) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new SchedulerException("an unexpected error has occurred: " + e.getMessage(), (Throwable)e);
                }
                this.log.warn("fix blocked trigger! Trigger details: name=" + key.getName() + ", description=" + trigger.getDescription() + ", nextFireTime=" + nextFireTime);
                this.globalScheduler.resumeTrigger(key);
            }
        }, () -> {});
    }

    private boolean checkPause() {
        return new File(Environment.getRootFolder(), ".ban_balance").exists();
    }

    static abstract class JobStoreSupportAccess
    extends JobStoreSupport {
        JobStoreSupportAccess() {
        }

        static interface TransactionCallbackAccess<E>
        extends JobStoreSupport.TransactionCallback<E> {
        }
    }
}

