/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.security.acl.helper;

import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.restriction.converter.RestrictionsConverter;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcePropertyDynamicValueHandler;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.resource.AclEntityResource;
import com.gridnine.xtrip.common.security.acl.resource.AclResource;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceOperationPermission;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourceOperations;
import com.gridnine.xtrip.common.security.acl.rule.AclAction;
import com.gridnine.xtrip.common.security.acl.rule.AclFieldRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.server.security.acl.helper.AclEntryProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclHelper {
    private static final Logger log = LoggerFactory.getLogger(AclHelper.class);
    public static boolean FULL_ACCESS_TO_FX_ACL_EDITOR = false;
    public static final String ENTRY_COMPOUND_ID_SEPARATOR = "|";
    public static final String ENTRY_COMPOUND_PROPERTY_NAME = "compoundId";

    public static String createEntryCompoundId(String principalId, String resourceId) {
        return principalId + ENTRY_COMPOUND_ID_SEPARATOR + resourceId;
    }

    public static void createAcl() {
        if (AclHelper.getGroup(com.gridnine.xtrip.common.security.acl.helper.AclHelper.all.getId()) == null) {
            AclHelper.saveGroup(com.gridnine.xtrip.common.security.acl.helper.AclHelper.all);
        }
        if (AclHelper.getGroup(com.gridnine.xtrip.common.security.acl.helper.AclHelper.administators.getId()) == null) {
            AclHelper.saveGroup(com.gridnine.xtrip.common.security.acl.helper.AclHelper.administators);
        }
        if (AclHelper.getUser(com.gridnine.xtrip.common.security.acl.helper.AclHelper.system.getId()) == null) {
            AclHelper.saveUser(com.gridnine.xtrip.common.security.acl.helper.AclHelper.system);
        }
        if (AclHelper.getUser(com.gridnine.xtrip.common.security.acl.helper.AclHelper.admin.getId()) == null) {
            AclHelper.saveUser(com.gridnine.xtrip.common.security.acl.helper.AclHelper.admin);
        }
    }

    public static Collection<AclGroup> getGroups() {
        return AssetsStorage.get().search(AclGroup.class, new SearchQuery()).getData();
    }

    public static Collection<AclGroup> getRootGroups() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclGroup.Property.parentId.name(), null));
        return AssetsStorage.get().search(AclGroup.class, query).getData();
    }

    public static AclGroup getGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        return (AclGroup)AssetsStorage.get().find(AclGroup.class, AclGroup.Property.id.name(), (Object)groupId);
    }

    public static AclGroup getGroupParent(String groupId) {
        if (groupId == null) {
            return null;
        }
        AclGroup group = AclHelper.getGroup(groupId);
        if (group != null) {
            return AclHelper.getGroup(group.getParentId());
        }
        return null;
    }

    public static Collection<AclGroup> getGroupChildren(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclGroup.Property.parentId.name(), (Object)groupId));
        return AssetsStorage.get().search(AclGroup.class, query).getData();
    }

    public static Collection<AclUser> getGroupUsers(String groupId) {
        if (groupId == null) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)AclUser.Property.groupIds.name(), (Object)groupId));
        return AssetsStorage.get().search(AclUser.class, query).getData();
    }

    public static void saveGroup(AclGroup group) {
        if (group == null) {
            return;
        }
        AssetsStorage.get().save((BaseAsset)group);
    }

    public static void deleteGroup(AclGroup group) {
        if (group == null) {
            return;
        }
        if (com.gridnine.xtrip.common.security.acl.helper.AclHelper.isSpecialGroup((AclGroup)group)) {
            throw new IllegalArgumentException(String.format("group %s can not be deleted", group.getId()));
        }
        for (AclUser user : AclHelper.getGroupUsers(group.getId())) {
            user.getGroupIds().remove(group.getId());
            AclHelper.saveUser(user);
        }
        for (AclGroup child : AclHelper.getGroupChildren(group.getId())) {
            child.setParentId(null);
            AclHelper.saveGroup(child);
        }
        for (AclEntry entry : AclHelper.getEntries(group.getId())) {
            AclHelper.deleteEntry(entry);
        }
        AssetsStorage.get().delete((BaseAsset)group);
    }

    public static Collection<AclUser> getUsers() {
        return AssetsStorage.get().search(AclUser.class, new SearchQuery()).getData();
    }

    public static Collection<AclUser> getRootUsers() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.isEmpty((String)AclUser.Property.groupIds.name()));
        return AssetsStorage.get().search(AclUser.class, query).getData();
    }

    public static AclUser getUser(String userId) {
        if (userId == null) {
            return null;
        }
        return (AclUser)AssetsStorage.get().find(AclUser.class, AclUser.Property.id.name(), (Object)userId);
    }

    public static void checkAclUser(String userId) {
        if (AclHelper.getUser(userId) == null) {
            throw Xeption.forAdmin((String)"AclUser is absent.", (Object[])new Object[0]);
        }
    }

    public static Collection<AclGroup> getUserGroups(String userId) {
        if (userId == null) {
            return Collections.emptyList();
        }
        AclUser user = AclHelper.getUser(userId);
        if (user != null) {
            ArrayList<AclGroup> groups = new ArrayList<AclGroup>();
            for (String groupId : user.getGroupIds()) {
                AclGroup group = AclHelper.getGroup(groupId);
                if (group == null) continue;
                groups.add(group);
            }
            return groups;
        }
        return Collections.emptyList();
    }

    public static void saveUser(AclUser user) {
        if (user == null) {
            return;
        }
        AssetsStorage.get().save((BaseAsset)user);
    }

    public static void deleteUser(AclUser user) {
        if (user == null) {
            return;
        }
        if (com.gridnine.xtrip.common.security.acl.helper.AclHelper.isSpecialUser((AclUser)user)) {
            throw new IllegalArgumentException(String.format("user %s can not be deleted", user.getId()));
        }
        for (AclEntry entry : AclHelper.getEntries(user.getId())) {
            AclHelper.deleteEntry(entry);
        }
        AssetsStorage.get().delete((BaseAsset)user);
    }

    public static Collection<AclEntry> getEntries() {
        return AssetsStorage.get().search(AclEntry.class, new SearchQuery()).getData();
    }

    public static Collection<AclEntry> getEntries(String principalId) {
        if (principalId == null) {
            return null;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)AclEntry.Property.principalId.name(), (Object)principalId));
        return AssetsStorage.get().search(AclEntry.class, query).getData();
    }

    public static AclEntry getEntry(String resourceId, String principalId) {
        if (resourceId == null || principalId == null) {
            return null;
        }
        return (AclEntry)AssetsStorage.get().find(AclEntry.class, ENTRY_COMPOUND_PROPERTY_NAME, (Object)AclHelper.createEntryCompoundId(principalId, resourceId));
    }

    public static void saveEntry(AclEntry entry) {
        if (entry == null) {
            return;
        }
        AssetsStorage.get().save((BaseAsset)entry);
    }

    public static void deleteEntry(AclEntry entry) {
        if (entry == null) {
            return;
        }
        AssetsStorage.get().delete((BaseAsset)entry);
    }

    public static boolean isGranted(EntityContainer<? extends BaseEntity> entityContainer, String entityId, String resourceId, String userId, String operationId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        RestrictionResourceProxy proxy = null;
        if (entityContainer != null && entityId != null) {
            proxy = RestrictionsHelper.buildProxies(entityContainer, resourceId).get(entityId);
        }
        return AclHelper.isGranted(proxy, resourceId, userId, operationId, handlers);
    }

    public static boolean isGranted(RestrictionResourceProxy proxy, String resourceId, String userId, String operationId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        AclResourceOperationPermission permission = AclHelper.getPermission(proxy, resourceId, userId, operationId, handlers);
        return permission != AclResourceOperationPermission.DENY;
    }

    public static AclResourceOperationPermission getPermission(RestrictionResourceProxy proxy, String resourceId, String userId, String operationId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking %s permission of principal %s on resource %s using proxy %s", operationId, userId, resourceId, proxy != null ? String.format("of resource %s", proxy.getResourceId()) : null));
        }
        if (resourceId == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("resource id is null, permission is null", new Object[0]));
            }
            return null;
        }
        if (userId == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("user id is null, permission is null", new Object[0]));
            }
            return null;
        }
        if (operationId == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("operation id is null, permission is null", new Object[0]));
            }
            return null;
        }
        if (RestrictionResourcesRegistry.get().getResource(resourceId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("resource %s is not registered, checking meta registry", resourceId));
            }
            resourceId = Optional.ofNullable(MetaRegistry.get().getEntities().get(resourceId)).map(item -> item.getExtendsId()).orElse(null);
            while (resourceId != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("checking meta resource %s", resourceId));
                }
                if (RestrictionResourcesRegistry.get().getResource(resourceId) != null) break;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("meta resource %s is not registered", resourceId));
                }
                resourceId = Optional.ofNullable(MetaRegistry.get().getEntities().get(resourceId)).map(item -> item.getExtendsId()).orElse(null);
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("using super resource %s", resourceId));
            }
            if (resourceId == null) {
                if (log.isDebugEnabled()) {
                    log.debug("resources is not registered, permission is null");
                }
                return null;
            }
        }
        if (AclHelper.getUser(userId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("user %s is not registered, permission is null", userId));
            }
            return null;
        }
        if (RestrictionResourcesRegistry.get().getOperation(operationId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("operation %s is not registered, permission is null", operationId));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking resources", new Object[0]));
        }
        ArrayList<String> deniedGroups = new ArrayList<String>();
        String parentResourceId = resourceId;
        while (parentResourceId != null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("checking resource %s", parentResourceId));
            }
            if (RestrictionResourcesRegistry.get().getResource(parentResourceId) == null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("resource %s is not registered, permission is null", parentResourceId));
                }
                return null;
            }
            AclResourceOperationPermission permission = AclHelper.getPermission2(proxy, parentResourceId, userId, operationId, deniedGroups, handlers);
            if (permission != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("permission %s for resource %s found", permission.name(), parentResourceId));
                }
                return permission;
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("permission for resource %s not found", parentResourceId));
            }
            parentResourceId = RestrictionResourcesRegistry.get().getResourceParent(parentResourceId);
            if (!log.isDebugEnabled()) continue;
            log.debug(String.format("using parent resource %s", parentResourceId));
        }
        return null;
    }

    private static AclResourceOperationPermission getPermission2(RestrictionResourceProxy proxy, String resourceId, String userId, String operationId, List<String> deniedGroups, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        List<AclEntry> entries;
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking principals", new Object[0]));
            log.debug(String.format("checking user", new Object[0]));
            log.debug(String.format("checking user %s", userId));
        }
        boolean undefinedPermission = false;
        if (log.isDebugEnabled()) {
            log.debug(String.format("searching entries for resource %s and user %s", resourceId, userId));
        }
        if ((entries = AclEntryProvider.get().getUserEntries(resourceId, userId)).size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("entries for resource %s and user %s found", resourceId, userId));
            }
            for (AclEntry entry : entries) {
                AclResourceOperationPermission permission = AclHelper.getPermission(proxy, entry.getRules(), resourceId, userId, operationId, handlers);
                if (permission != null) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("permission %s for user %s found", permission.name(), userId));
                    }
                    if (permission != AclResourceOperationPermission.GRANT) continue;
                    return permission;
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("permission for user %s not found", userId));
                }
                undefinedPermission = true;
            }
            if (!undefinedPermission) {
                return AclResourceOperationPermission.DENY;
            }
        } else if (log.isDebugEnabled()) {
            log.debug(String.format("entries for resource %s and user %s not found", resourceId, userId));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking groups", new Object[0]));
        }
        ArrayList<String> checkedGroups = new ArrayList<String>();
        block1: for (AclGroup group : AclHelper.getUserGroups(userId)) {
            while (group != null) {
                String groupId = group.getId();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("checking group %s", groupId));
                }
                if (deniedGroups.contains(groupId)) {
                    if (!log.isDebugEnabled()) continue block1;
                    log.debug(String.format("group %s was already denied, skipping group", groupId));
                    continue block1;
                }
                if (checkedGroups.contains(groupId)) {
                    if (!log.isDebugEnabled()) continue block1;
                    log.debug(String.format("group %s was already checked, skipping group", groupId));
                    continue block1;
                }
                checkedGroups.add(groupId);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("searching entries for resource %s and group %s", resourceId, groupId));
                }
                if ((entries = AclEntryProvider.get().getGroupEntries(resourceId, userId, groupId)).size() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("entries for resource %s and group %s found", resourceId, groupId));
                    }
                    for (AclEntry entry : entries) {
                        AclResourceOperationPermission permission = AclHelper.getPermission(proxy, entry.getRules(), resourceId, userId, operationId, handlers);
                        if (permission != null) {
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("permission %s for group %s found", permission.name(), groupId));
                            }
                            if (permission == AclResourceOperationPermission.GRANT) {
                                return permission;
                            }
                            deniedGroups.add(groupId);
                            continue block1;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug(String.format("permission for group %s not found", groupId));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug(String.format("entries for resource %s and group %s not found", resourceId, groupId));
                }
                group = AclHelper.getGroupParent(groupId);
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("using parent group %s", group != null ? group.getId() : null));
            }
            undefinedPermission = true;
        }
        if (!undefinedPermission) {
            return AclResourceOperationPermission.DENY;
        }
        return null;
    }

    private static AclResourceOperationPermission getPermission(RestrictionResourceProxy proxy, List<AclRule> rules, String resourceId, String userId, String operationId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking rules", new Object[0]));
        }
        block0: for (AclRule rule : rules) {
            for (AclAction action : rule.getActions()) {
                AclResource resource;
                if (!action.getOperationId().equals(operationId) && !action.getOperationId().equals(StandardAclResourceOperations.ALL.getId())) continue;
                AclResourceOperationPermission permission = action.getPermission();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("permission %s for operation %s found", permission.name(), operationId));
                }
                if (proxy != null) {
                    Boolean match;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("checking property restriction groups", new Object[0]));
                    }
                    if ((match = RestrictionsHelper.getMatch(proxy, FULL_ACCESS_TO_FX_ACL_EDITOR ? rule.getRestrictionGroups() : RestrictionsConverter.toRestrictionGroups((Collection)rule.getPropertyRestrictionGroups()), userId, handlers)) != null) {
                        if (!match.booleanValue()) {
                            if (!log.isDebugEnabled()) continue block0;
                            log.debug(String.format("property restriction groups are not matched", new Object[0]));
                            continue block0;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("property restriction groups are matched", new Object[0]));
                        }
                    }
                } else if (rule.getPropertyRestrictionGroups().size() > 0 && (resource = AclResourcesEnvironment.get().getResource(resourceId)) != null && resource instanceof AclEntityResource) {
                    return null;
                }
                return permission;
            }
        }
        return null;
    }

    public static SearchQuery modifyQuery(SearchQuery query, String resourceId, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        SearchQueryData searchQueryData;
        if (log.isDebugEnabled()) {
            log.debug("modify query of user " + userId + " original query " + query);
        }
        if ((searchQueryData = AclHelper.getSearchQueryData(resourceId, userId, handlers)) != null) {
            if (searchQueryData.getCriterion() != null) {
                query.getCriteria().getCriterions().add(searchQueryData.getCriterion());
            }
            for (String field : searchQueryData.getFields()) {
                String property = field.substring(field.lastIndexOf(".") + 1);
                query.getPreferredProperties().remove(property);
                Iterator iterator = query.getFilters().iterator();
                while (iterator.hasNext()) {
                    FilterQuery filter = (FilterQuery)iterator.next();
                    if (!filter.getProperty().equals(property)) continue;
                    iterator.remove();
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("modify query of user " + userId + " modified query " + query);
        }
        return query;
    }

    public static SearchQueryData getSearchQueryData(String resourceId, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(String.format("retrieving criterions for principal %s on resource %s", userId, resourceId));
        }
        if (resourceId == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("resource id is null, returning null", new Object[0]));
            }
            return null;
        }
        if (userId == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("user id is null, returning null", new Object[0]));
            }
            return null;
        }
        if (RestrictionResourcesRegistry.get().getResource(resourceId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("resource %s is not registered, returning null", resourceId));
            }
            return null;
        }
        if (AclHelper.getUser(userId) == null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("user %s is not registered, returning null", userId));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking resource %s", resourceId));
        }
        return AclHelper.getSearchQueryData2(resourceId, userId, handlers);
    }

    private static SearchQueryData getSearchQueryData2(String resourceId, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        List<AclEntry> entries;
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking principals", new Object[0]));
            log.debug(String.format("checking user", new Object[0]));
            log.debug(String.format("checking user %s", userId));
        }
        ArrayList<SearchQueryData> searchQueryDatas = new ArrayList<SearchQueryData>();
        if (log.isDebugEnabled()) {
            log.debug(String.format("searching entries for resource %s and user %s", resourceId, userId));
        }
        if ((entries = AclEntryProvider.get().getUserEntries(resourceId, userId)).size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("entries for resource %s and user %s found", resourceId, userId));
            }
            for (AclEntry entry : entries) {
                SearchQueryData searchQueryData = AclHelper.getSearchQueryData(entry.getRules(), userId, handlers);
                searchQueryDatas.add(searchQueryData);
            }
            return AclHelper.mergeSearchQueryData(searchQueryDatas);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("entries for resource %s and user %s not found", resourceId, userId));
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking groups", new Object[0]));
        }
        boolean found = false;
        ArrayList<String> checkedGroups = new ArrayList<String>();
        block1: for (AclGroup group : AclHelper.getUserGroups(userId)) {
            while (group != null) {
                String groupId = group.getId();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("checking group %s", groupId));
                }
                if (checkedGroups.contains(groupId)) {
                    if (!log.isDebugEnabled()) continue block1;
                    log.debug(String.format("group %s was already checked, skipping group", groupId));
                    continue block1;
                }
                checkedGroups.add(groupId);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("searching entries for resource %s and group %s", resourceId, groupId));
                }
                if ((entries = AclEntryProvider.get().getGroupEntries(resourceId, userId, groupId)).size() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("entries for resource %s and group %s found", resourceId, groupId));
                    }
                    for (AclEntry entry : entries) {
                        SearchQueryData searchQueryData = AclHelper.getSearchQueryData(entry.getRules(), userId, handlers);
                        searchQueryDatas.add(searchQueryData);
                    }
                    found = true;
                    continue block1;
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("entries for resource %s and group %s not found", resourceId, groupId));
                }
                group = AclHelper.getGroupParent(groupId);
                if (!log.isDebugEnabled()) continue;
                log.debug(String.format("using parent group %s", group != null ? group.getId() : null));
            }
        }
        if (found) {
            return AclHelper.mergeSearchQueryData(searchQueryDatas);
        }
        return null;
    }

    private static SearchQueryData getSearchQueryData(List<AclRule> rules, String userId, Collection<RestrictionResourcePropertyDynamicValueHandler> handlers) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(String.format("checking rules", new Object[0]));
        }
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        ArrayList<String> fields = new ArrayList<String>();
        for (AclRule rule : rules) {
            criterions.addAll(RestrictionsHelper.getCriterions(FULL_ACCESS_TO_FX_ACL_EDITOR ? rule.getRestrictionGroups() : RestrictionsConverter.toRestrictionGroups((Collection)rule.getPropertyRestrictionGroups()), userId, handlers));
            for (AclFieldRestriction fieldRestriction : rule.getFieldRestrictions()) {
                if (fields.contains(fieldRestriction.getFieldId())) continue;
                fields.add(fieldRestriction.getFieldId());
            }
        }
        SearchQueryData queryData = new SearchQueryData();
        queryData.setCriterion(SearchCriterion.and((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        queryData.getFields().addAll(fields);
        return queryData;
    }

    private static SearchQueryData mergeSearchQueryData(List<SearchQueryData> searchQueryDatas) {
        ArrayList<SearchCriterion> criterions = new ArrayList<SearchCriterion>();
        ArrayList<List<String>> fields = new ArrayList<List<String>>();
        for (SearchQueryData searchQueryData : searchQueryDatas) {
            criterions.add(searchQueryData.getCriterion());
            fields.add(searchQueryData.getFields());
        }
        SearchQueryData searchQueryData = new SearchQueryData();
        if (criterions.size() > 0) {
            if (criterions.size() == 1) {
                searchQueryData.setCriterion((SearchCriterion)criterions.get(0));
            } else {
                searchQueryData.setCriterion(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
            }
        }
        searchQueryData.getFields().clear();
        if (fields.size() > 0) {
            searchQueryData.getFields().addAll((Collection)fields.get(0));
            for (int i = 1; i < fields.size(); ++i) {
                searchQueryData.getFields().retainAll((Collection)fields.get(i));
            }
        }
        return searchQueryData;
    }

    public static class SearchQueryData {
        private SearchCriterion criterion;
        private final List<String> fields = new ArrayList<String>();

        public void setCriterion(SearchCriterion criterion) {
            this.criterion = criterion;
        }

        public SearchCriterion getCriterion() {
            return this.criterion;
        }

        public List<String> getFields() {
            return this.fields;
        }
    }
}

