/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.setup;

import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.setup.SetupHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.java.plugin.registry.Extension;

public class SetupManager {
    private static final Comparator<SetupHandler> CMP = new Comparator<SetupHandler>(){

        @Override
        public int compare(SetupHandler o1, SetupHandler o2) {
            return -Double.compare(o1.getWeight(), o2.getWeight());
        }
    };
    private final transient Logger log = Logger.getLogger(this.getClass());
    private final List<SetupHandler> handlers = new ArrayList<SetupHandler>();

    public SetupManager() {
        this.registerStandardHandlers();
    }

    protected void registerStandardHandlers() {
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"SetupHandler")) {
            try {
                this.registerHandler((SetupHandler)JpfUtil.getClass((Extension)ext).newInstance());
            }
            catch (Exception e) {
                this.log.error((Object)("failed registerign setup handler from " + ext), (Throwable)e);
            }
        }
    }

    public void registerHandler(SetupHandler handler) {
        this.handlers.add(handler);
        this.log.debug((Object)("registered " + handler));
    }

    public void doSetup(Properties configuration) throws Exception {
        this.log.info((Object)"setup BEGIN");
        long timing = System.currentTimeMillis();
        ArrayList<SetupHandler> list = new ArrayList<SetupHandler>(this.handlers);
        Collections.sort(list, CMP);
        for (SetupHandler handler : list) {
            this.log.debug((Object)("running setup with " + handler));
            handler.doSetup(configuration);
        }
        MiscUtil.logTiming((long)timing, (String)"setup done");
        this.log.info((Object)"setup END");
    }

    public void doCleanup(Properties configuration) throws Exception {
        this.log.info((Object)"cleanup BEGIN");
        long timing = System.currentTimeMillis();
        ArrayList<SetupHandler> list = new ArrayList<SetupHandler>(this.handlers);
        Collections.sort(list, CMP);
        for (SetupHandler handler : list) {
            this.log.debug((Object)("running cleanup with " + handler));
            handler.doCleanup(configuration);
        }
        MiscUtil.logTiming((long)timing, (String)"cleanup done");
        this.log.info((Object)"cleanup END");
    }
}

