/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.setup.primary;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.setup.SetupHandler;
import java.util.Properties;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimarySetupProcedure
implements SetupHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public double getWeight() {
        return Double.MIN_VALUE;
    }

    @Override
    public void doCleanup(Properties configuration) throws Exception {
    }

    @Override
    public void doSetup(Properties configuration) throws Exception {
        this.setupAdminAccount();
        this.setupSystemAccount(configuration);
    }

    private void setupAdminAccount() throws Exception {
        System.out.print("Administrator account setup ... ");
        UserAccount admin = new UserAccount();
        admin.setLoginName("admin");
        String password = RandomStringUtils.random((int)8, (String)"0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@#$%^&*_=+-");
        admin.setPassword(password.toCharArray());
        admin.setActive(true);
        admin.setFullName("System Administrator");
        AssetsStorage.get().save((BaseAsset)admin);
        System.out.println("Administrator account password: " + password);
        System.out.println("done.");
    }

    private void setupSystemAccount(Properties configuration) throws Exception {
        System.out.print("System account setup ... ");
        String loginName = configuration.getProperty("storage.system.account");
        char[] password = DesUtil.decode((String)configuration.getProperty("storage.system.password")).toCharArray();
        UserAccount admin = new UserAccount();
        admin.setLoginName(loginName);
        admin.setPassword(password);
        admin.setActive(true);
        admin.setFullName("System Account");
        AssetsStorage.get().save((BaseAsset)admin);
        this.log.info(String.format("created \"%s\" user account", loginName));
        System.out.println("done.");
        LogicalStorage.get().authorizeAsSystem();
    }
}

