/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.sn;

import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberGenerator;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumbers;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperClient;
import com.gridnine.xtrip.server.lockmanager.ZooKeeperFactory;
import com.gridnine.xtrip.server.lockmanager.ZooUtil;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.KeeperException;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedSequenceNumberGenerator
implements SequenceNumberGenerator {
    protected static final Logger log = LoggerFactory.getLogger(DistributedSequenceNumberGenerator.class);
    private static final boolean TRACE = true;
    private static final String SN_PATH = "/xtrip/sn/";
    private static final String GLOBAL_SN_LOCK_NAME = "GLOBAL_SN_LOCK_NAME";
    private static final String SN_LOCK_NAME = "SN_LOCK_%s";
    private static final String MAIN_ZOOKEEPER_URL_PROPERTY = "zookeeper.url";
    private static final String LOCAL_ZOOKEEPER_URL_PROPERTY = "sn.zookeeper.url";
    private static final String ROOT_METRICS = "profiling.sequence-number";
    private final ZooKeeperClient client;
    protected volatile boolean closed = false;

    private static String getURL() {
        ExtendedProperties properties = ServerConfiguration.get().getConfiguration();
        String url = properties.getProperty(LOCAL_ZOOKEEPER_URL_PROPERTY);
        if (url != null) {
            return url;
        }
        return properties.getProperty(MAIN_ZOOKEEPER_URL_PROPERTY);
    }

    public DistributedSequenceNumberGenerator() {
        this(DistributedSequenceNumberGenerator.getURL());
    }

    public DistributedSequenceNumberGenerator(String url) {
        if (TextUtil.isBlank((String)url)) {
            throw new IllegalArgumentException("url not specified");
        }
        log.info("initialize sequence number generator at " + url);
        this.client = ZooKeeperFactory.getInstance(url);
        log.info("sequence number generator connected to " + url);
    }

    public void close() {
        if (log.isDebugEnabled()) {
            log.debug("close sequence number generator");
        }
        this.closed = true;
        ZooKeeperFactory.release(this.client);
        log.info("sequence number generator closed");
    }

    @Override
    public String getFormat(CompositeNumber compositeNumber, String designator) {
        return "0000000";
    }

    @Override
    public void setFormat(String format, CompositeNumber compositeNumber, String designator) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger nextVal(CompositeNumber compositeNumber, String designator) throws Exception {
        String id = DistributedSequenceNumberGenerator.buildId(compositeNumber, designator);
        if (log.isDebugEnabled()) {
            log.debug("get next value for " + id);
        }
        long startTimeInMillis = System.currentTimeMillis();
        try {
            BigInteger bigInteger = (BigInteger)LockUtil.lock((String)String.format(SN_LOCK_NAME, id.toUpperCase()), (long)10L, (TimeUnit)TimeUnit.MINUTES, () -> {
                BigInteger result;
                Metrics.get().timingAndEvent("profiling.sequence-number.single." + this.getKey(id) + ".latency", startTimeInMillis);
                long startTimeInMillis2 = System.currentTimeMillis();
                BigInteger current = this.readValue(id);
                BigInteger bigInteger = result = current != null ? current.add(BigInteger.ONE) : BigInteger.ZERO;
                if (log.isTraceEnabled()) {
                    log.trace("next value for " + id + " is " + String.valueOf(result));
                }
                this.writeValue(id, result);
                Metrics.get().timingAndEvent("profiling.sequence-number.single." + this.getKey(id) + ".inside", startTimeInMillis2);
                return result;
            }, () -> {
                throw new TimeoutException();
            });
            return bigInteger;
        }
        catch (Throwable t) {
            Metrics.get().timingAndEvent("profiling.sequence-number.single." + this.getKey(id) + ".fail." + DistributedSequenceNumberGenerator.getLabel(MiscUtil.getSimpleClassName(t.getClass())) + (!TextUtil.isBlank((String)t.getMessage()) ? " - " + Metrics.key(t.getMessage().toLowerCase()) + "!" : ""), startTimeInMillis);
            throw t;
        }
        finally {
            Metrics.get().timingAndEvent("profiling.sequence-number.single." + this.getKey(id) + ".all", startTimeInMillis);
        }
    }

    private String getKey(String id) {
        return id.replace('.', '-');
    }

    private static String getLabel(String camel) {
        StringBuilder sb = new StringBuilder();
        int l = 0;
        for (int i = 0; i < camel.length(); ++i) {
            char c = camel.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && (l > 0 || 0 == l && i + 1 < camel.length() && Character.isLowerCase(camel.charAt(i + 1)))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                l = 0;
                continue;
            }
            sb.append(c);
            ++l;
        }
        return sb.toString();
    }

    @Override
    public BigInteger nextVal(Map<CompositeNumber, String> compositeNumbers) throws Exception {
        Object id;
        ArrayList<String> idList = new ArrayList<String>(compositeNumbers.size());
        for (Map.Entry<CompositeNumber, String> entry : compositeNumbers.entrySet()) {
            id = DistributedSequenceNumberGenerator.buildId(entry.getKey(), entry.getValue());
            idList.add((String)id);
        }
        if (log.isDebugEnabled()) {
            log.debug("get next value for " + Arrays.toString(idList.toArray()));
        }
        long startTimeInMillis = System.currentTimeMillis();
        try {
            id = (BigInteger)LockUtil.lock((String)GLOBAL_SN_LOCK_NAME, (long)10L, (TimeUnit)TimeUnit.MINUTES, () -> {
                Metrics.get().timingAndEvent("profiling.sequence-number.multi.global-lock", startTimeInMillis);
                LockManager lm = LockUtil.getLockManager();
                HashMap<String, NamedLock> locks = new HashMap<String, NamedLock>(compositeNumbers.size());
                ArrayList<NamedLock> locked = new ArrayList<NamedLock>(compositeNumbers.size());
                try {
                    BigInteger bigInteger;
                    for (String string : idList) {
                        NamedLock lock = lm.getLock((Object)String.format(SN_LOCK_NAME, string.toUpperCase()));
                        locks.put(string, lock);
                    }
                    try {
                        for (Map.Entry entry : locks.entrySet()) {
                            long startTimeInMillis2 = System.currentTimeMillis();
                            NamedLock lock = (NamedLock)entry.getValue();
                            if (!lock.tryLock(10L, TimeUnit.MINUTES)) {
                                throw new TimeoutException();
                            }
                            locked.add(lock);
                            Metrics.get().timingAndEvent("profiling.sequence-number.multi.single-lock." + this.getKey((String)entry.getKey()), startTimeInMillis2);
                        }
                        Metrics.get().timingAndEvent("profiling.sequence-number.multi.latency", startTimeInMillis);
                        long startTimeInMillis2 = System.currentTimeMillis();
                        BigInteger max = BigInteger.ZERO;
                        for (String id : idList) {
                            BigInteger current = this.readValue(id);
                            max = max.max(current == null ? BigInteger.ZERO : current.add(BigInteger.ONE));
                        }
                        for (String id : idList) {
                            this.writeValue(id, max);
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("next value for " + Arrays.toString(idList.toArray()) + " is " + String.valueOf(max));
                        }
                        Metrics.get().timingAndEvent("profiling.sequence-number.multi.inside", startTimeInMillis2);
                        bigInteger = max;
                    }
                    catch (Throwable throwable) {
                        for (NamedLock lock : locked) {
                            try {
                                lock.unlock();
                            }
                            catch (Throwable t) {
                                log.error("error while unlock named lock: " + t.getMessage(), t);
                            }
                        }
                        throw throwable;
                    }
                    for (NamedLock lock : locked) {
                        try {
                            lock.unlock();
                        }
                        catch (Throwable t) {
                            log.error("error while unlock named lock: " + t.getMessage(), t);
                        }
                    }
                    return bigInteger;
                }
                finally {
                    for (NamedLock lock : locks.values()) {
                        try {
                            lock.close();
                        }
                        catch (Throwable t) {
                            log.error("error while close named lock: " + t.getMessage(), t);
                        }
                    }
                }
            }, () -> {
                throw new TimeoutException();
            });
            return id;
        }
        catch (Throwable t) {
            Metrics.get().timingAndEvent("profiling.sequence-number.multi.fail." + DistributedSequenceNumberGenerator.getLabel(MiscUtil.getSimpleClassName(t.getClass())) + (!TextUtil.isBlank((String)t.getMessage()) ? " - " + Metrics.key(t.getMessage().toLowerCase()) + "!" : ""), startTimeInMillis);
            throw t;
        }
        finally {
            Metrics.get().timingAndEvent("profiling.sequence-number.multi.all", startTimeInMillis);
        }
    }

    @Override
    public void assignValue(String id, BigInteger value) throws Exception {
        BigInteger valueToSet;
        BigInteger bigInteger = valueToSet = value != null ? value : BigInteger.ZERO;
        if (log.isDebugEnabled()) {
            log.debug("set value for " + id + " to " + value);
        }
        LockUtil.lock((String)id, (long)10L, (TimeUnit)TimeUnit.MINUTES, () -> this.writeValue(id, valueToSet), () -> {
            throw new TimeoutException();
        });
    }

    @Override
    public void assignValue(String prefix, String designator, String suffix, BigInteger value) throws Exception {
        this.assignValue(DistributedSequenceNumberGenerator.buildId(prefix, designator, suffix), value);
    }

    @Override
    public BigInteger getValue(String id) throws Exception {
        return (BigInteger)LockUtil.lock((String)id, (long)10L, (TimeUnit)TimeUnit.MINUTES, () -> this.readValue(id), () -> {
            throw new TimeoutException();
        });
    }

    @Override
    public BigInteger getValue(String prefix, String designator, String suffix) throws Exception {
        return this.getValue(DistributedSequenceNumberGenerator.buildId(prefix, designator, suffix));
    }

    @Override
    public Map<String, BigInteger> getValues() throws Exception {
        List<String> nodes;
        String nodePath = SN_PATH.substring(0, SN_PATH.length() - 1);
        HashMap<String, BigInteger> result = new HashMap<String, BigInteger>();
        try {
            nodes = this.client.getChildren(nodePath);
        }
        catch (KeeperException.NoNodeException e) {
            return result;
        }
        for (String nodeName : nodes) {
            String name = DistributedSequenceNumberGenerator.extractName(nodeName);
            result.put(name, this.getValue(name));
        }
        return result;
    }

    private static String buildId(CompositeNumber compositeNumber, String designator) {
        return DistributedSequenceNumberGenerator.buildId(TextUtil.nonNullStr((String)compositeNumber.getNumberPrefix()), TextUtil.nonNullStr((String)designator), TextUtil.nonNullStr((String)compositeNumber.getNumberSuffix()));
    }

    private static String buildId(String prefix, String designator, String suffix) {
        return String.format("%s_%s_%s", TextUtil.nonNullStr((String)prefix), TextUtil.nonNullStr((String)designator), TextUtil.nonNullStr((String)suffix));
    }

    private static String prepareName(String name) {
        return String.valueOf(name).replace("$", "$$").replace("\\", "$1").replace("/", "$2").replace(".", "$-");
    }

    private static String extractName(String nodeName) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            if (c != '$' || i + 1 == nodeName.length()) {
                sb.append(c);
                continue;
            }
            c = nodeName.charAt(++i);
            switch (c) {
                case '1': {
                    sb.append("\\");
                    continue block6;
                }
                case '2': {
                    sb.append("/");
                    continue block6;
                }
                case '-': {
                    sb.append(".");
                    continue block6;
                }
                case '$': {
                    sb.append("$");
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Invalid node name: " + nodeName);
                }
            }
        }
        return sb.toString();
    }

    private BigInteger readValue(String name) throws KeeperException, InterruptedException, TimeoutException {
        byte[] nodeData;
        String nodePath = SN_PATH + DistributedSequenceNumberGenerator.prepareName(name);
        this.sync(nodePath);
        try {
            nodeData = this.client.getData(nodePath);
        }
        catch (KeeperException.NoNodeException e) {
            log.trace("no node found");
            return null;
        }
        if (nodeData == null) {
            log.trace("node " + name + " data is null");
            return null;
        }
        BigInteger result = !DistributedSequenceNumberGenerator.isValidData(nodeData) ? new BigInteger(nodeData) : DistributedSequenceNumberGenerator.getDataValue(nodeData);
        log.trace("current node " + name + " data is " + result);
        return result;
    }

    private void writeValue(String name, BigInteger value) throws KeeperException, InterruptedException {
        ZooUtil.ensurePersistentPathExists(this.client, SN_PATH);
        log.trace("node  " + name + " data to store is " + (value != null ? value : BigInteger.ZERO));
        byte[] data = DistributedSequenceNumberGenerator.getData(value != null ? value : BigInteger.ZERO);
        String path = SN_PATH + DistributedSequenceNumberGenerator.prepareName(name);
        if (!ZooUtil.ensurePersistentExists(this.client, path, data)) {
            throw new IllegalStateException("Internal error: node not created");
        }
        this.client.setData(path, data);
        log.trace("node  " + name + " data stored");
    }

    protected void sync(String nodePath) throws InterruptedException, TimeoutException {
        log.trace("sync...");
        if (!this.client.sync(nodePath, 10L, TimeUnit.MINUTES)) {
            throw new TimeoutException();
        }
        log.trace("sync: released");
    }

    public void dispose() {
        this.close();
    }

    protected static byte[] getData(BigInteger value) {
        byte[] body = value.toByteArray();
        byte[] result = new byte[6 + body.length];
        result[0] = 37;
        result[1] = 5;
        result[2] = 2;
        result[3] = 0;
        result[4] = (byte)(result.length - 6);
        result[5] = 0;
        System.arraycopy(body, 0, result, 6, body.length);
        return result;
    }

    private static boolean isValidData(byte[] data) {
        return data != null && data.length >= 6 && data[0] == 37 && data[1] == 5 && data[2] == 2 && data[3] == 0 && data.length == 6 + (data[4] + (data[5] << 8));
    }

    private static BigInteger getDataValue(byte[] data) {
        byte[] result = new byte[data.length - 6];
        System.arraycopy(data, 6, result, 0, result.length);
        return new BigInteger(result);
    }

    public void migrate() throws Exception {
        log.info("starting values migration");
        SearchQuery query = new SearchQuery();
        query.getPreferredProperties().add(SequenceNumbers.Property.prefix.name());
        query.getPreferredProperties().add(SequenceNumbers.Property.designator.name());
        query.getPreferredProperties().add(SequenceNumbers.Property.suffix.name());
        query.getPreferredProperties().add(SequenceNumbers.Property.lastNumber.name());
        List data = AssetsStorage.get().search(SequenceNumbers.class, query).getData();
        log.info("migrating {} values", (Object)data.size());
        for (SequenceNumbers sn : data) {
            String id = DistributedSequenceNumberGenerator.buildId(sn.getPrefix(), sn.getDesignator(), sn.getSuffix());
            this.writeValue(id, new BigInteger(sn.getLastNumber()));
            log.info("migrated value {} = {}", (Object)id, (Object)sn.getLastNumber());
        }
    }
}

