/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.statistics;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.statistics.StatisticsHeader;
import com.gridnine.xtrip.server.statistics.StatisticsRecord;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class Statistics {
    private static final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private static final boolean ENABLED = MiscUtil.isTrue((String)System.getProperty(Statistics.class.getName() + ".enabled"));

    public static void add(StatisticsHeader header, StatisticsRecord record) {
        if (ENABLED) {
            try {
                Logger logger = loggers.computeIfAbsent(header.getEventName(), Statistics::createLogger);
                logger.info((Object)Statistics.serializeRecord(record));
            }
            catch (Throwable t) {
                IncidentsLog.reportException((String)"failed adding record", (Throwable)t);
            }
        }
    }

    public static void initializeLoggers() {
        File dir = new File(Environment.getDataFolder(), "statistics");
        if (dir.exists() && dir.isDirectory()) {
            for (String fileName : dir.list((d, n) -> n.endsWith(".dat"))) {
                loggers.computeIfAbsent(fileName.substring(0, fileName.length() - 4), Statistics::createLogger);
            }
        }
    }

    private static Logger createLogger(String eventName) {
        Logger logger = Logger.getLogger((String)("Statistics-" + eventName));
        logger.setLevel(Level.INFO);
        DailyRollingFileAppender appender = null;
        try {
            appender = new DailyRollingFileAppender((Layout)new PatternLayout("%m%n"), new File(Environment.getDataFolder(), "statistics/" + eventName).getAbsolutePath() + ".dat", ".yyyy-MM-dd");
        }
        catch (IOException e) {
            throw Xeption.forDeveloper((String)"Statistics#createLogger error", (Throwable)e, (Object[])new Object[0]);
        }
        logger.addAppender((Appender)appender);
        return logger;
    }

    private static String serializeRecord(StatisticsRecord record) {
        StringBuilder sb = new StringBuilder();
        for (String item : record.getItems()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(StringEscapeUtils.escapeCsv((String)(item != null ? item : "")));
        }
        return sb.toString();
    }
}

