/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.storage;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.DictionaryDataProvider;
import com.gridnine.xtrip.server.storage.StandardDictionaryDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryStorage {
    private static DictionaryStorage instance = new DictionaryStorage();
    private static final Logger log = LoggerFactory.getLogger(DictionaryStorage.class);
    private static Map<String, DictionaryDataProvider> dataProviders = new ConcurrentHashMap<String, DictionaryDataProvider>();
    private static String STANDARD_DATA_PROVIDER_ID = null;

    public static DictionaryStorage get() {
        return instance;
    }

    public static void registerDataProvider(DictionaryDataProvider provider) {
        if (provider != null) {
            dataProviders.put(provider.getId(), provider);
            log.info(String.format("dictionary data provider registered: id = %s, classs = %s ", provider.getId(), provider.getClass().getName()));
        }
    }

    private DictionaryStorage() {
    }

    public Collection<? extends BaseDictionary> loadAll(Date modifiedSince, Class<? extends BaseDictionary> dictCls) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (dictCls == null) {
            throw new IllegalArgumentException("dict class is null");
        }
        LinkedHashSet<? extends BaseDictionary> result = new LinkedHashSet<BaseDictionary>();
        for (DictionaryDataProvider provider : this.getProviders(null)) {
            result.addAll(provider.loadAll(modifiedSince, dictCls, new HashSet<String>()));
        }
        return result;
    }

    public Collection<? extends BaseDictionary> loadAll(Date modifiedSince, Set<String> ignoredTypes) throws Exception {
        long timing = System.currentTimeMillis();
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        LinkedHashSet<? extends BaseDictionary> result = new LinkedHashSet<BaseDictionary>();
        for (DictionaryDataProvider provider : this.getProviders(null)) {
            result.addAll(provider.loadAll(modifiedSince, null, ignoredTypes));
            MiscUtil.logTiming((long)timing, (String)("completed loadAll on " + provider.getId()));
        }
        return result;
    }

    public <D extends BaseDictionary> D load(Class<D> cls, String code) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        return this.findProvider(cls).load(cls, code);
    }

    public <D extends BaseDictionary> void save(D dict) throws Exception {
        this.save(dict, false);
    }

    public <D extends BaseDictionary> void save(D dict, boolean ignoreInterceptors) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (dict.getCode() != null) {
            dict.setCode(dict.getCode().trim());
        }
        DictionaryDataProvider.DictionaryUpdateResult<D> res = this.findProvider(dict.getClass()).save(dict, ignoreInterceptors);
        this.updateCache(res);
    }

    private <D extends BaseDictionary> void updateCache(DictionaryDataProvider.DictionaryUpdateResult<D> res) {
        if (!Environment.isPublished(DictionaryCache.class)) {
            return;
        }
        for (BaseDictionary item : res.toEvict) {
            DictionaryCache.get().evict(item);
        }
        for (BaseDictionary item : res.toPut) {
            DictionaryCache.get().put(item);
        }
    }

    public <D extends BaseDictionary> void update(Collection<D> dictList, Class<D> cls) throws Exception {
        this.update(dictList, cls, false);
    }

    public <D extends BaseDictionary> void update(Collection<D> dictList, Class<D> cls, boolean ignoreInterceptors) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        DictionaryDataProvider.DictionaryUpdateResult<D> result = this.findProvider(cls).update(dictList, cls, ignoreInterceptors);
        this.updateCache(result);
    }

    public <D extends BaseDictionary> void delete(D dict, boolean ignoreInterceptors) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (dict == null) {
            return;
        }
        DictionaryDataProvider.DictionaryUpdateResult<D> result = this.findProvider(dict.getClass()).delete(dict, ignoreInterceptors);
        this.updateCache(result);
    }

    public <D extends BaseDictionary> void deleteAll(Class<D> cls) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        this.findProvider(cls).deleteAll(cls);
        DictionaryCache.get().evictAll(cls);
    }

    public <D extends BaseDictionary> void delete(D dict) throws Exception {
        this.delete(dict, false);
    }

    public Collection<? extends DictionaryReference<?>> getDeleted(Date modifiedSince, Set<String> ignoredTypes) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        ArrayList result = new ArrayList();
        for (DictionaryDataProvider provider : this.getProviders(null)) {
            result.addAll(provider.getDeleted(modifiedSince, null, ignoredTypes));
        }
        return result;
    }

    public Collection<? extends DictionaryReference<?>> getDeleted(Date modifiedSince, Class<? extends BaseDictionary> dictCls) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        ArrayList result = new ArrayList();
        for (DictionaryDataProvider provider : this.getProviders(null)) {
            result.addAll(provider.getDeleted(modifiedSince, dictCls, new HashSet<String>()));
        }
        return result;
    }

    public Collection<String> getResetTypes(Date modifiedSince, Set<String> ignoredTypes) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        HashSet<String> result = new HashSet<String>();
        for (DictionaryDataProvider provider : this.getProviders(null)) {
            result.addAll(provider.getResetTypes(modifiedSince, null, ignoredTypes));
        }
        result.removeAll(ignoredTypes);
        return result;
    }

    public Collection<String> getResetTypes(Date modifiedSince, Class<? extends BaseDictionary> dictCls) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        HashSet<String> result = new HashSet<String>();
        for (DictionaryDataProvider provider : this.getProviders(null)) {
            result.addAll(provider.getResetTypes(modifiedSince, dictCls, new HashSet<String>()));
        }
        return result;
    }

    private List<DictionaryDataProvider> getProviders(Class<? extends BaseDictionary> dictCls) {
        return dictCls != null ? Collections.singletonList(this.findProvider(dictCls)) : new ArrayList<DictionaryDataProvider>(dataProviders.values());
    }

    private DictionaryDataProvider findProvider(Class<? extends BaseDictionary> dictCls) {
        String providerId;
        if (dictCls == null) {
            return dataProviders.get(STANDARD_DATA_PROVIDER_ID);
        }
        DictionaryType dictionaryType = (DictionaryType)MetaRegistry.get().getDictionaries().get(dictCls.getName());
        String string = providerId = dictionaryType == null ? null : dictionaryType.getProviderId();
        if (providerId == null) {
            return dataProviders.get(STANDARD_DATA_PROVIDER_ID);
        }
        DictionaryDataProvider result = dataProviders.get(providerId);
        if (result == null) {
            log.error("no dictionary data provider is registered with id = " + providerId);
        }
        return result;
    }

    static {
        StandardDictionaryDataProvider provider = new StandardDictionaryDataProvider();
        STANDARD_DATA_PROVIDER_ID = provider.getId();
        DictionaryStorage.registerDataProvider(provider);
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"DictionaryDataProvider")) {
            if (JpfUtil.isExtensionDisabled((Extension)ext)) {
                log.info("disabled dictionary data provider " + ext);
                continue;
            }
            try {
                DictionaryStorage.registerDataProvider((DictionaryDataProvider)JpfUtil.getClass((Extension)ext).newInstance());
            }
            catch (Exception e) {
                log.error("failed creating dictionary data provider " + ext, (Throwable)e);
            }
        }
    }
}

