/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.storage.standard;

import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"principalId", "resourceId"})})
public class AclEntryData
extends BaseAssetData<AclEntry> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="AclEntryData_modified")
    private Date modified;
    @Column(nullable=false)
    @Index(name="AclEntryData_principalId")
    private String principalId;
    @Column(nullable=false)
    @Index(name="AclEntryData_resourceId")
    private String resourceId;
    @Column(unique=true)
    @Index(name="AclEntryData_compoundId")
    private String compoundId;
    @Lob
    @Column(length=0x40000000)
    private byte[] rules;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    public byte[] getRules() {
        return this.rules;
    }

    public void setRules(byte[] rules) {
        this.rules = rules;
    }

    @Override
    public void fromAsset(AclEntry asset) throws Exception {
        this.setUid(asset.getUid());
        this.principalId = asset.getPrincipalId();
        this.resourceId = asset.getResourceId();
        this.modified = asset.getModified();
        this.compoundId = AclHelper.createEntryCompoundId(asset.getPrincipalId(), asset.getResourceId());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RulesWrapper rulesWrapper = new RulesWrapper();
        rulesWrapper.getRules().clear();
        rulesWrapper.getRules().addAll(asset.getRules());
        XUtil.serialize((XSerializable)rulesWrapper, (OutputStream)baos);
        this.rules = baos.toByteArray();
    }

    @Override
    public AclEntry toAsset(Set<String> preferredProperties) throws Exception {
        AclEntry asset = new AclEntry(this.getUid());
        asset.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("principalId")) {
            asset.setPrincipalId(this.principalId);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("resourceId")) {
            asset.setResourceId(this.resourceId);
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("rules")) && this.rules != null) {
            RulesWrapper rulesWrapper = new RulesWrapper();
            rulesWrapper.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.rules))).getDocumentElement());
            asset.getRules().clear();
            asset.getRules().addAll(rulesWrapper.getRules());
        }
        return asset;
    }

    private static class RulesWrapper
    implements XSerializable,
    Serializable {
        private static final long serialVersionUID = 7975097907047428825L;
        private final List<AclRule> rules = new ArrayList<AclRule>();

        private RulesWrapper() {
        }

        public List<AclRule> getRules() {
            return this.rules;
        }

        public void fromXML(Element elm) throws Exception {
            this.getRules().clear();
            for (Element element : XmlUtil.getElements((Element)elm, (String)"rules/item")) {
                AclRule restriction = (AclRule)XHelper.readObject((Element)element, (String)".");
                if (restriction == null) continue;
                this.getRules().add(restriction);
            }
        }

        public void toXML(Element elm) throws Exception {
            for (AclRule rule : this.getRules()) {
                XHelper.writeObject((Element)elm, (String)"rules/item", (Object)rule);
            }
        }
    }

    public static enum Property {
        rules;

    }
}

