/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.storage.standard;

import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class AclGroupData
extends BaseAssetData<AclGroup> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="AclGroupData_modified")
    private Date modified;
    @Column(unique=true)
    @Index(name="AclGroupData_id")
    private String id;
    @Column(nullable=false)
    @Index(name="AclGroupData_name")
    private String name;
    @Lob
    @Column(length=0x40000000)
    private String description;
    @Index(name="AclGroupData_parentId")
    private String parentId;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(AclGroup asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.id = asset.getId();
        this.name = asset.getName();
        this.description = asset.getDescription();
        this.parentId = asset.getParentId();
    }

    @Override
    public AclGroup toAsset(Set<String> preferredProperties) {
        AclGroup asset = new AclGroup(this.getUid());
        asset.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("id")) {
            asset.setId(this.id);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("name")) {
            asset.setName(this.name);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("description")) {
            asset.setDescription(this.description);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("parentId")) {
            asset.setParentId(this.parentId);
        }
        return asset;
    }
}

