/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.storage.standard;

import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class AclUserData
extends BaseAssetData<AclUser> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="AclUserData_modified")
    private Date modified;
    @Column(unique=true)
    @Index(name="AclUserData_id")
    private String id;
    @Column(nullable=false)
    @Index(name="AclUserData_name")
    private String name;
    @Lob
    @Column(length=0x40000000)
    private String description;
    @Lob
    @Column(length=0x40000000)
    @Index(name="AclUserData_groupIds")
    private String groupIds;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(AclUser asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.id = asset.getId();
        this.name = asset.getName();
        this.description = asset.getDescription();
        StringBuilder stringBuilder = new StringBuilder();
        if (!asset.getGroupIds().isEmpty()) {
            for (String group : asset.getGroupIds()) {
                stringBuilder.append('|');
                stringBuilder.append(group);
            }
            stringBuilder.append('|');
        }
        this.groupIds = stringBuilder.toString();
    }

    @Override
    public AclUser toAsset(Set<String> preferredProperties) {
        AclUser asset = new AclUser(this.getUid());
        asset.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("id")) {
            asset.setId(this.id);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("name")) {
            asset.setName(this.name);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("description")) {
            asset.setDescription(this.description);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("groupIds")) {
            asset.getGroupIds().clear();
            if (!TextUtil.isBlank((String)this.groupIds)) {
                for (String group : this.groupIds.split("\\|")) {
                    if (TextUtil.isBlank((String)group)) continue;
                    asset.getGroupIds().add(group);
                }
            }
        }
        return asset;
    }
}

