/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.storage.standard;

import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.model.assets.AsyncCommandInfo;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class AsyncCommandInfoData
extends BaseAssetData<AsyncCommandInfo> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="AsyncCommandInfoData_modified")
    private Date modified;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="AsyncCommandInfoData_created")
    private Date created;
    private String owner;
    @Lob
    @Column(length=0x40000000)
    private byte[] data;
    private String options;
    @Column(nullable=false)
    private boolean launched;
    private String node;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date date) {
        this.created = date;
    }

    @Override
    public void fromAsset(AsyncCommandInfo asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.created = asset.getModified();
        this.owner = asset.getOwner();
        this.data = asset.getData();
        if (asset.getOptions() != null && !asset.getOptions().isEmpty()) {
            StringBuilder optionsBuilder = new StringBuilder();
            for (AsyncCommandOption item : asset.getOptions()) {
                if (null == item) continue;
                optionsBuilder.append('|');
                optionsBuilder.append(item.name());
            }
            if (optionsBuilder.length() > 0) {
                optionsBuilder.append('|');
                this.options = optionsBuilder.toString();
            } else {
                this.options = null;
            }
        } else {
            this.options = null;
        }
        this.launched = asset.isLaunched();
        this.node = asset.getNode();
    }

    @Override
    public AsyncCommandInfo toAsset(Set<String> preferredProperties) throws Exception {
        AsyncCommandInfo result = new AsyncCommandInfo(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        result.setCreated(MiscUtil.cloneDate((Date)this.created));
        if (preferredProperties.isEmpty() || preferredProperties.contains("owner")) {
            result.setOwner(this.owner);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("data")) {
            result.setData(this.data);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("options")) {
            result.setOptions(!TextUtil.isBlank((String)this.options) ? Arrays.stream(this.options.split("\\|")).filter(TextUtil::nonBlank).map(AsyncCommandOption::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(AsyncCommandOption.class))) : null);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("launched")) {
            result.setLaunched(this.launched);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("node")) {
            result.setNode(this.node);
        }
        return result;
    }
}

