/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.storage.standard;

import com.gridnine.xtrip.common.key.bindings.KeyBindings;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;
import org.xml.sax.InputSource;

@Entity
public class KeyBindingsData
extends BaseAssetData<KeyBindings> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="KeyBindingsData_modified")
    private Date modified;
    @Column(unique=true)
    @Index(name="KeyBindingsData_userId")
    private String userId;
    @Lob
    @Column(length=0x40000000)
    private byte[] data = new byte[0];

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(KeyBindings asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.userId = asset.getUserId();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XUtil.serialize((XSerializable)asset, (OutputStream)baos);
        this.data = baos.toByteArray();
    }

    @Override
    public KeyBindings toAsset(Set<String> preferredProperties) throws Exception {
        KeyBindings asset = new KeyBindings(this.getUid());
        asset.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("userId")) {
            asset.setUserId(this.userId);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("data")) {
            asset.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.data))).getDocumentElement());
        }
        return asset;
    }
}

