/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.storage.standard;

import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class UserAccountData
extends BaseAssetData<UserAccount> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="UserAccountData_modified")
    private Date modified;
    @Column(unique=true)
    @Index(name="UserAccountData_loginName")
    private String loginName;
    @Lob
    @Column(length=0x40000000)
    private byte[] passwordDigest;
    private Date passwordLastUpdateDate;
    @Lob
    @Column(length=0x40000000)
    private byte[] ssoSaltDigest;
    private Date ssoSaltDigestLastUpdateDate;
    private Date activeLastUpdateDate;
    private Date temporarilyBlockDate;
    @Column(nullable=false)
    private boolean active;
    @Column(nullable=false)
    private String fullName;
    @Lob
    @Column(length=0x40000000)
    private String notes;
    @Lob
    @Column(length=0x40000000)
    private String passwordDigests;
    @Column
    private String email;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="UserAccountData_createDate")
    private Date createDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="UserAccountData_lastLoginDate")
    private Date lastLoginDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="UserAccountData_expiryDate")
    private Date expiryDate;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(UserAccount asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.loginName = asset.getLoginName();
        this.passwordDigest = asset.getPasswordDigest();
        this.passwordLastUpdateDate = asset.getPasswordLastUpdateDate();
        this.ssoSaltDigest = asset.getSsoSaltDigest();
        this.ssoSaltDigestLastUpdateDate = asset.getSsoSaltDigestLastUpdateDate();
        this.activeLastUpdateDate = asset.getActiveLastUpdateDate();
        this.temporarilyBlockDate = asset.getTemporarilyBlockDate();
        this.active = asset.isActive();
        this.fullName = asset.getFullName();
        this.notes = asset.getNotes();
        this.email = asset.getEmail();
        StringBuilder stringBuilder = new StringBuilder();
        if (!asset.getPasswordDigests().isEmpty()) {
            for (byte[] digest : asset.getPasswordDigests()) {
                stringBuilder.append('|');
                stringBuilder.append(Base64.encode((byte[])digest));
            }
            stringBuilder.append('|');
        }
        this.passwordDigests = stringBuilder.toString();
        this.createDate = asset.getCreateDate();
        this.lastLoginDate = asset.getLastLoginDate();
        this.expiryDate = asset.getExpiryDate();
    }

    @Override
    public UserAccount toAsset(Set<String> preferredProperties) {
        UserAccount result = new UserAccount(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("loginName")) {
            result.setLoginName(this.loginName);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("passwordDigest")) {
            result.setPasswordDigest(this.passwordDigest);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("passwordLastUpdateDate")) {
            result.setPasswordLastUpdateDate(MiscUtil.cloneDate((Date)this.passwordLastUpdateDate));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("ssoSaltDigest")) {
            result.setSsoSaltDigest(this.ssoSaltDigest);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("ssoSaltDigestLastUpdateDate")) {
            result.setSsoSaltDigestLastUpdateDate(MiscUtil.cloneDate((Date)this.ssoSaltDigestLastUpdateDate));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("activeLastUpdateDate")) {
            result.setActiveLastUpdateDate(MiscUtil.cloneDate((Date)this.activeLastUpdateDate));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("temporarilyBlockDate")) {
            result.setTemporarilyBlockDate(MiscUtil.cloneDate((Date)this.temporarilyBlockDate));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("active")) {
            result.setActive(this.active);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("fullName")) {
            result.setFullName(this.fullName);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("notes")) {
            result.setNotes(this.notes);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("passwordDigests")) {
            result.getPasswordDigests().clear();
            if (!TextUtil.isBlank((String)this.passwordDigests)) {
                for (String digest : this.passwordDigests.split("\\|")) {
                    if (TextUtil.isBlank((String)digest)) continue;
                    try {
                        result.getPasswordDigests().add(Base64.decode((String)digest));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("email")) {
            result.setEmail(this.email);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("createDate")) {
            result.setCreateDate(this.createDate);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("lastLoginDate")) {
            result.setLastLoginDate(this.lastLoginDate);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("expiryDate")) {
            result.setExpiryDate(this.expiryDate);
        }
        return result;
    }

    public void setPasswordDigest(byte[] value) {
        this.passwordDigest = value;
    }

    public byte[] getPasswordDigest() {
        return this.passwordDigest;
    }
}

