/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.tracker;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.LoggerFactory;

public class LongRunningOperationsTracker
implements Disposable {
    private final ConcurrentHashMap<String, LongRunningOperationTrackerSessionData> data = new ConcurrentHashMap();
    private boolean enabled;
    private int tresholdInSeconds;
    private int intervalBetweenStacktraces;
    private LongRunningOperationTrackerMonitoringThread monitoringThread;

    public static LongRunningOperationsTracker get() {
        return (LongRunningOperationsTracker)Environment.getPublished(LongRunningOperationsTracker.class);
    }

    public LongRunningOperationsTracker(ExtendedProperties properties) {
        this.enabled = "true".equals(properties.getProperty("long-running-operation-tracker.enabled"));
        this.tresholdInSeconds = Integer.parseInt(properties.getProperty("long-running-operation-tracker.tresholdInSeconds", "60"));
        this.intervalBetweenStacktraces = Integer.parseInt(properties.getProperty("long-running-operation-tracker.intervalBetweenStacktraces", "50"));
        if (this.enabled) {
            this.monitoringThread = new LongRunningOperationTrackerMonitoringThread();
            this.monitoringThread.start();
        }
    }

    public void setIntervalBetweenStacktraces(int intervalBetweenStacktraces) {
        this.intervalBetweenStacktraces = intervalBetweenStacktraces;
    }

    public void setTresholdInSeconds(int tresholdInSeconds) {
        this.tresholdInSeconds = tresholdInSeconds;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled && !enabled) {
            this.monitoringThread.shutdown = true;
        } else if (!this.enabled && enabled) {
            this.monitoringThread = new LongRunningOperationTrackerMonitoringThread();
            this.monitoringThread.start();
        }
        this.enabled = enabled;
    }

    public String startSession(String operationName) {
        if (!this.enabled) {
            return null;
        }
        String uid = UUID.randomUUID().toString();
        this.data.put(uid, new LongRunningOperationTrackerSessionData(operationName));
        return uid;
    }

    public void startOperation(String operationName, String uid) {
        LongRunningOperationTrackerSessionData sessionData;
        if (uid == null) {
            return;
        }
        LongRunningOperationTrackerSessionData longRunningOperationTrackerSessionData = sessionData = uid == null ? null : this.data.get(uid);
        if (sessionData == null) {
            return;
        }
        if (sessionData.currentOperationName != null) {
            this.endOperation(uid);
        }
        sessionData.currentOperationName = operationName;
        sessionData.currentOperationStartDate = new Date();
    }

    public void endOperation(String uid) {
        LongRunningOperationTrackerSessionData sessionData;
        if (uid == null) {
            return;
        }
        LongRunningOperationTrackerSessionData longRunningOperationTrackerSessionData = sessionData = uid == null ? null : this.data.get(uid);
        if (sessionData == null) {
            return;
        }
        sessionData.operations.add(new LongRunningOperationTrackerOperationData(sessionData.currentOperationName, sessionData.currentOperationStartDate));
        sessionData.currentOperationName = null;
        sessionData.currentOperationStartDate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStacktrace(String uid) {
        LongRunningOperationTrackerSessionData sessionData;
        LongRunningOperationTrackerSessionData longRunningOperationTrackerSessionData = sessionData = uid == null ? null : this.data.get(uid);
        if (sessionData == null) {
            return;
        }
        LongRunningOperationsTracker longRunningOperationsTracker = this;
        synchronized (longRunningOperationsTracker) {
            this.addStacktraceInternal(sessionData);
        }
    }

    private void addStacktraceInternal(LongRunningOperationTrackerSessionData sessionData) {
        Date now = new Date();
        StringBuilder sb = new StringBuilder();
        Thread.getAllStackTraces().forEach((thread, traces) -> {
            sb.append(String.format("thread: %s", thread.getName()));
            for (StackTraceElement traceElement : traces) {
                String entry = "\tat " + traceElement + "\n";
                if (entry.contains("java.lang.Thread") || entry.contains(".DebugUtil.")) continue;
                sb.append(entry);
            }
        });
        sessionData.lastStacktraceDate = now;
        sessionData.stacktraces.add(new LongRunningOperationTrackerStackTraceData(now, sb.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSession(String uid) {
        LongRunningOperationTrackerSessionData sessionData;
        LongRunningOperationTrackerSessionData longRunningOperationTrackerSessionData = sessionData = uid == null ? null : this.data.get(uid);
        if (sessionData == null) {
            return;
        }
        if (sessionData.currentOperationName != null) {
            this.endOperation(uid);
        }
        this.data.remove(uid);
        long totalDuration = System.currentTimeMillis() - sessionData.startDate.getTime();
        if (TimeUnit.SECONDS.toMillis(this.tresholdInSeconds) < totalDuration) {
            LongRunningOperationsTracker longRunningOperationsTracker = this;
            synchronized (longRunningOperationsTracker) {
                if (sessionData.lastStacktraceDate == null) {
                    this.addStacktraceInternal(sessionData);
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Total duration %s seconds.\nOperations:", TimeUnit.SECONDS.convert(totalDuration, TimeUnit.MILLISECONDS)));
            for (LongRunningOperationTrackerOperationData op : sessionData.getOperations()) {
                sb.append(String.format("\n\t%s: %s seconds (start at %s)", op.operationName, TimeUnit.SECONDS.convert(op.duration, TimeUnit.MILLISECONDS), sdf.format(op.startDate)));
            }
            sb.append("\nstacktraces\n");
            for (LongRunningOperationTrackerStackTraceData st : sessionData.getStacktraces()) {
                sb.append(String.format("\ndump at %s\n%s", sdf.format(st.date), st.stacktrace));
            }
            try {
                FileUtils.writeStringToFile((File)new File(this.getDir(), String.format("%s-%s", sessionData.mainOperationName, sdf.format(new Date()))), (String)sb.toString());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("unable to write long running operation incident", (Throwable)e);
            }
        }
    }

    private File getDir() {
        File res = new File(Environment.getTempFolder(), "long-operations");
        if (!res.exists()) {
            res.mkdirs();
        }
        return res;
    }

    public void dispose() {
        if (this.monitoringThread != null) {
            this.monitoringThread.setShutdown(true);
        }
    }

    class LongRunningOperationTrackerMonitoringThread
    extends Thread {
        private volatile boolean shutdown;

        LongRunningOperationTrackerMonitoringThread() {
            this.setName("LongRunningOperationTrackerMonitoringThread");
            this.setDaemon(true);
        }

        void setShutdown(boolean shutdown) {
            this.shutdown = shutdown;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                long now = System.currentTimeMillis();
                LongRunningOperationsTracker.this.data.forEach((uid, item) -> {
                    if (TimeUnit.SECONDS.toMillis(LongRunningOperationsTracker.this.intervalBetweenStacktraces) < now - (((LongRunningOperationTrackerSessionData)item).lastStacktraceDate == null ? ((LongRunningOperationTrackerSessionData)item).startDate : ((LongRunningOperationTrackerSessionData)item).lastStacktraceDate).getTime()) {
                        LongRunningOperationsTracker.this.addStacktrace((String)uid);
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static class LongRunningOperationTrackerStackTraceData {
        final Date date;
        final String stacktrace;

        LongRunningOperationTrackerStackTraceData(Date date, String stacktrace) {
            this.date = date;
            this.stacktrace = stacktrace;
        }
    }

    static class LongRunningOperationTrackerOperationData {
        final String operationName;
        final long duration;
        final Date startDate;

        LongRunningOperationTrackerOperationData(String operationName, Date startDate) {
            this.operationName = operationName;
            this.startDate = startDate;
            this.duration = System.currentTimeMillis() - startDate.getTime();
        }
    }

    static class LongRunningOperationTrackerSessionData {
        private String mainOperationName;
        private Date startDate;
        private String currentOperationName;
        private Date currentOperationStartDate;
        private Date lastStacktraceDate;
        private final List<LongRunningOperationTrackerOperationData> operations = new ArrayList<LongRunningOperationTrackerOperationData>();
        private final List<LongRunningOperationTrackerStackTraceData> stacktraces = new ArrayList<LongRunningOperationTrackerStackTraceData>();

        LongRunningOperationTrackerSessionData(String mainOperation) {
            this.mainOperationName = mainOperation;
            this.startDate = new Date();
        }

        String getCurrentOperationName() {
            return this.currentOperationName;
        }

        void setCurrentOperationName(String currentOperationName) {
            this.currentOperationName = currentOperationName;
        }

        Date getLastStacktraceDate() {
            return this.lastStacktraceDate;
        }

        void setLastStacktraceDate(Date lastStacktraceDate) {
            this.lastStacktraceDate = lastStacktraceDate;
        }

        List<LongRunningOperationTrackerOperationData> getOperations() {
            return this.operations;
        }

        List<LongRunningOperationTrackerStackTraceData> getStacktraces() {
            return this.stacktraces;
        }
    }
}

