/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.tracker;

import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.server.tracker.Tracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerImpl
implements Tracker {
    private final String id = "track " + UUIDGenerator.generate((boolean)false).toString();
    private final Logger log;

    public TrackerImpl(String loggerName) {
        this.log = LoggerFactory.getLogger((String)loggerName);
    }

    @Override
    public void mark() {
        this.log.debug(this.id);
    }

    @Override
    public void printStack() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getStackTrace());
        }
    }

    private String getStackTrace() {
        StackTraceElement[] array = new Throwable().getStackTrace();
        StringBuilder sb = new StringBuilder(this.id + "stack:");
        for (int i = 0; i < array.length; ++i) {
            sb.append("\n");
            sb.append(array[i]);
        }
        return sb.toString();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        this.log.debug(this.id + ": " + message);
    }
}

