/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update;

import com.gridnine.xtrip.common.model.net.AuthorizationSettings;
import com.gridnine.xtrip.common.model.standard.helpers.URLConnectionHelper;
import com.gridnine.xtrip.common.update.RemoteUpdateHelper;
import com.gridnine.xtrip.common.update.UpdateFile;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRemoteUpdateHelper {
    private static final Logger log = LoggerFactory.getLogger(ServerRemoteUpdateHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizeRepositories(URL localRepositoryUrl, URL remoteRepository, UpdateIndexFile indexFile, AuthorizationSettings info) throws Exception {
        File localRepository = IoUtil.url2file((URL)localRepositoryUrl);
        if (!localRepository.isDirectory() || !localRepository.exists()) {
            throw new Exception(String.format("Local repository %s does not exist.", localRepository));
        }
        ArrayList<File> filesToRemove = new ArrayList<File>();
        ArrayList<UpdateFile> filesToAdd = new ArrayList<UpdateFile>();
        ArrayList<File> localFileList = new ArrayList<File>();
        for (File file : localRepository.listFiles()) {
            filesToRemove.add(file);
            localFileList.add(file);
        }
        HashSet<UpdateFile> updateFiles = new HashSet<UpdateFile>();
        if (indexFile.getSetupFile() != null) {
            updateFiles.add(indexFile.getSetupFile());
        }
        updateFiles.addAll(indexFile.getCommonPlugins());
        updateFiles.addAll(indexFile.getServerPlugins());
        updateFiles.addAll(indexFile.getClientPlugins());
        updateFiles.addAll(indexFile.getClientJRE());
        for (UpdateFile remoteFile : updateFiles) {
            File localFile;
            if (!"true".equals(System.getProperty("update.force.download")) && (localFile = RemoteUpdateHelper.findFile(localFileList, (UpdateFile)remoteFile)) != null) {
                filesToRemove.remove(localFile);
                continue;
            }
            filesToAdd.add(remoteFile);
        }
        for (File file : filesToRemove) {
            log.info(String.format("deleting file %s from local repository ", file));
            if (file.delete()) continue;
            throw new Exception(String.format("Unable to delete file %s .", file));
        }
        for (UpdateFile file : filesToAdd) {
            URL remoteFile = new URL(remoteRepository, file.getName());
            log.info(String.format("copying file %s to local repository ", file.getName()));
            System.out.println(String.format("Getting file %s...", file.getName()));
            byte[] content = URLConnectionHelper.getContent((URL)remoteFile, (AuthorizationSettings)info);
            if (content == null) {
                throw new Exception(String.format("Remote file %s is absent.", remoteFile));
            }
            if ((long)content.length != file.getSize()) {
                throw new Exception(String.format("Loaded file size %s differs from requested one %s.", Long.toString(content.length), Long.toString(file.getSize())));
            }
            File localFile = new File(localRepository, file.getName());
            try (FileOutputStream os = new FileOutputStream(localFile);){
                IoUtil.copyStream((InputStream)new ByteArrayInputStream(content), (OutputStream)os, (int)512);
                localFile.setLastModified(file.getModified().getTime());
            }
            String checkSum = MiscUtil.getCheckSum((URL)IoUtil.file2url((File)localFile), (boolean)true);
            if (MiscUtil.equals((Object)checkSum, (Object)file.getCheckSum())) continue;
            localFile.delete();
            throw new Exception(String.format("Loaded file check sum %s differs from requested one %s.", checkSum, file.getCheckSum()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateServerFromLocalRepository(File repository, File pluginsDir, File setupDir) throws Exception {
        if (!repository.exists() || !repository.isDirectory()) {
            throw new Exception(String.format("local update repository %s does not exist.", repository));
        }
        if (!pluginsDir.exists() || !pluginsDir.isDirectory()) {
            throw new Exception(String.format("local plugins directory %s does not exist.", pluginsDir));
        }
        log.debug("copying file to plugins directory " + pluginsDir);
        UpdateIndexFile uif = new UpdateIndexFile();
        try (FileInputStream fis = new FileInputStream(new File(repository, "index.xml"));){
            uif.readFromStream((InputStream)fis);
        }
        HashSet<String> filenames = new HashSet<String>();
        for (UpdateFile uf : uif.getCommonPlugins()) {
            filenames.add(uf.getName());
        }
        for (UpdateFile uf : uif.getServerPlugins()) {
            filenames.add(uf.getName());
        }
        IoUtil.synchronizeFolders((File)repository, (File)pluginsDir, pathname -> filenames.contains(pathname.getName()));
        if (!setupDir.exists() && !setupDir.mkdirs()) {
            throw new Exception(String.format("unable to create setup directory %s", setupDir));
        }
        File setupFile = new File(repository, "setup.zip");
        if (!setupFile.exists()) {
            throw new Exception(String.format("unable to find file setup.zip in repository %s", repository));
        }
        log.info(String.format("emptying setup directory %s", setupDir.getName()));
        if (!IoUtil.emptyFolder((File)setupDir)) {
            throw new Exception(String.format("unable to empty setup directory %s", setupDir));
        }
        log.info(String.format("unpacking setup files to directory %s", setupDir));
        MiscUtil.unpack((URL)IoUtil.file2url((File)setupFile), (File)setupDir);
    }
}

