/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.update.db.DbUpdateHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AddFieldHandler
implements DbUpdateHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Element command, Connection conn) throws Exception {
        Statement st;
        String script;
        String fieldName = XHelper.readString((Element)command, (String)"fieldName");
        String fieldType = XHelper.readString((Element)command, (String)"fieldType");
        String fieldDefault = XHelper.readString((Element)command, (String)"fieldDefault");
        String tableName = XHelper.readString((Element)command, (String)"tableName");
        boolean clearTable = XHelper.readBoolean((Element)command, (String)"clearTable", (boolean)true);
        boolean reference = XHelper.readBoolean((Element)command, (String)"reference", (boolean)false);
        boolean index = XHelper.readBoolean((Element)command, (String)"index", (boolean)false);
        Logger log = LoggerFactory.getLogger(AddFieldHandler.class);
        if (clearTable) {
            script = String.format("DELETE FROM %s WHERE uid IS NOT NULL", tableName);
            log.debug("executing sql script: " + script);
            st = conn.createStatement();
            try {
                st.execute(script);
            }
            finally {
                st.close();
            }
        }
        script = String.format("SELECT COUNT(*) FROM information_schema.columns WHERE LOWER(table_catalog) = LOWER('%s') AND table_schema = 'public' AND LOWER(table_name) = LOWER('%s') AND LOWER(column_name) = LOWER('%s')", conn.getCatalog(), tableName, fieldName, fieldType);
        log.debug("executing sql script: " + script);
        st = conn.createStatement();
        try {
            st.execute(script);
            try (ResultSet resultSet = st.getResultSet();){
                if (resultSet.next() && resultSet.getInt(1) != 0) {
                    return;
                }
            }
        }
        finally {
            st.close();
        }
        script = String.format("ALTER TABLE %s ADD COLUMN %s %s", tableName, fieldName, fieldType);
        if (!TextUtil.isBlank((String)fieldDefault)) {
            script = script + String.format(" DEFAULT %s", fieldDefault);
        }
        log.debug("executing sql script: " + script);
        st = conn.createStatement();
        try {
            st.execute(script);
        }
        finally {
            st.close();
        }
        if (reference) {
            script = String.format("ALTER TABLE %s ADD COLUMN %sEntityClassName VARCHAR(255)", tableName, fieldName);
            log.debug("executing sql script: " + script);
            st = conn.createStatement();
            try {
                st.execute(script);
            }
            finally {
                st.close();
            }
            script = String.format("ALTER TABLE %s ADD COLUMN %sReferenceCaption VARCHAR(255)", tableName, fieldName);
            log.debug("executing sql script: " + script);
            st = conn.createStatement();
            try {
                st.execute(script);
            }
            finally {
                st.close();
            }
        }
        if (index) {
            String indexName = tableName;
            if (tableName.toLowerCase().endsWith("data")) {
                indexName = indexName.substring(0, tableName.length() - 4);
            }
            indexName = indexName + "_" + fieldName;
            String script2 = String.format("CREATE INDEX %s ON %s(%s)", indexName, tableName, fieldName);
            log.debug("executing sql script: " + script2);
            try (Statement st2 = conn.createStatement();){
                st2.execute(script2);
            }
        }
    }
}

