/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public final class DbUpdateFile {
    private String fileId;
    private final List<DbUpdate> updates = new ArrayList<DbUpdate>();

    public DbUpdateFile(URL url) throws Exception {
        if (!IoUtil.isResourceExists((URL)url)) {
            throw new Exception(String.format("update file %s does not exist", url));
        }
        try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
            this.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement());
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public List<DbUpdate> getUpdates() {
        return this.updates;
    }

    private void fromXML(Element elm) {
        this.fileId = XHelper.readString((Element)elm, (String)"@fileId");
        for (Element item : XmlUtil.getElements((Element)elm, (String)"update")) {
            DbUpdate update = new DbUpdate();
            update.fromXML(item);
            this.updates.add(update);
        }
    }

    public static final class DbUpdate {
        private String version;
        private Date date;
        private String description;
        private final List<Element> commands = new ArrayList<Element>();

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String value) {
            this.version = value;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date value) {
            this.date = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) {
            this.description = value;
        }

        public List<Element> getCommands() {
            return this.commands;
        }

        void fromXML(Element elm) {
            this.version = XHelper.readString((Element)elm, (String)"@version");
            this.description = XHelper.readString((Element)elm, (String)"description");
            this.date = XHelper.readDate((Element)elm, (String)"@date");
            this.commands.clear();
            for (Element item : XmlUtil.getElements((Element)elm, (String)"command")) {
                this.commands.add(item);
            }
        }
    }
}

