/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SetupUpdateAssetHandler
implements SetupUpdateHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Element elm) throws Exception {
        String actionId = XHelper.readString((Element)elm, (String)"@action");
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        String assetClass = XHelper.readString((Element)elm, (String)"@assetClass");
        if (!("add".equals(actionId) || "update".equals(actionId) || "delete".equals(actionId))) {
            this.log.warn("unsupported actionId: " + actionId + ", asset update will be skipped ");
            return;
        }
        if (!"delete".equals(actionId) && TextUtil.isBlank((String)fileName)) {
            this.log.warn("fileName is null, asset update will be skipped");
            return;
        }
        if (TextUtil.isBlank((String)assetClass)) {
            this.log.warn("class of asset is undefined, asset update will be skipped");
            return;
        }
        Class cls = XHelper.getClass((String)assetClass.trim());
        if (!BaseAsset.class.isAssignableFrom(cls)) {
            this.log.warn(String.format("asset class %s is not instance of %s, skipping update", assetClass, BaseAsset.class.getName()));
            return;
        }
        if ("delete".equals(actionId)) {
            this.delete(cls);
            return;
        }
        URL url = IoUtil.encodeUrl((URL)new URL(String.format("file:///%s/setup/assets/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName)));
        if (!IoUtil.isResourceExists((URL)url)) {
            this.log.warn(String.format("resource with URL \"%s\" does not exist", url));
            return;
        }
        if ("add".equals(actionId) || "update".equals(actionId)) {
            this.update(cls, url);
            return;
        }
    }

    private void delete(Class<BaseAsset> cls) throws Exception {
        LogicalSession session = LogicalStorage.get().beginUnitOfWork();
        try {
            for (BaseAsset asset : AssetsStorage.get().search(cls, new SearchQuery()).getData()) {
                AssetsStorage.get().delete(asset);
                this.log.debug(String.format("asset %s with uid %s successfully deleted", cls.getName(), asset.getUid()));
            }
            LogicalStorage.get().endUnitOfWork(session, false);
        }
        catch (Exception e) {
            LogicalStorage.get().cancelUnitOfWork(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Class<BaseAsset> cls, URL url) throws Exception {
        LogicalSession session = LogicalStorage.get().beginUnitOfWork();
        try {
            Element root;
            try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
                root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
            }
            root.getOwnerDocument().setDocumentURI(url.toExternalForm());
            int count = 0;
            for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
                if (!cls.getName().equals(XmlUtil.getValue((Element)objElm, (String)"@class"))) continue;
                BaseAsset asset = cls.newInstance();
                asset.fromXML(objElm);
                if (TextUtil.isBlank((String)asset.getUid())) {
                    asset.setUid(UUIDGenerator.generate((boolean)true).toString());
                }
                AssetsStorage.get().save(asset);
                this.log.debug("asset with uid " + asset.getUid() + " was saved");
                if (++count % 1000 != 0) continue;
                LogicalStorage.get().endUnitOfWork(session, false);
            }
            LogicalStorage.get().endUnitOfWork(session, true);
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(session);
        }
    }
}

