/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SetupUpdateDictionaryCodeVariantsHandler
extends BaseResourceSetupUpdateHandler {
    final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Element elm) throws Exception {
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        String dictClass = XHelper.readString((Element)elm, (String)"@dictClass");
        if (TextUtil.isBlank((String)dictClass)) {
            this.log.warn("class of dictionary is undefined, dictionary update will be skipped");
            return;
        }
        Class cls = XHelper.getClass((String)dictClass.trim());
        if (!BaseDictionary.class.isAssignableFrom(cls)) {
            this.log.warn(String.format("dictionary class %s is not instance of %s, skipping update", dictClass, BaseDictionary.class.getName()));
            return;
        }
        URL url = null;
        url = this.getBaseResourceUrl() == null ? IoUtil.encodeUrl((URL)new URL(String.format("file:///%s/setup/dict/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName))) : IoUtil.file2url((File)new File(IoUtil.url2file((URL)this.getBaseResourceUrl()), String.format("dict/%s", fileName)));
        if (!IoUtil.isResourceExists((URL)url)) {
            this.log.warn(String.format("resource with URL \"%s\" does not exist", url));
            return;
        }
        this.update(cls, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Class<BaseDictionary> cls, URL url) throws Exception {
        Element root;
        this.log.info(String.format("starting updating dictionary %s with code variants from url \"%s\"", cls.getName(), url));
        try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        root.getOwnerDocument().setDocumentURI(url.toExternalForm());
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            BaseDictionary dict = DictionaryStorage.get().load(cls, XmlUtil.getValue((Element)objElm, (String)"code"));
            BaseDictionary newDict = cls.newInstance();
            newDict.fromXML(objElm);
            boolean changed = false;
            if (dict == null) {
                dict = newDict;
                changed = true;
            } else {
                for (Map.Entry entry : newDict.getCodeVariants().entrySet()) {
                    String key = (String)entry.getKey();
                    if (dict.getCodeVariants().keySet().contains(key)) continue;
                    dict.getCodeVariants().put(key, entry.getValue());
                    changed = true;
                }
            }
            if (!changed) continue;
            if (TextUtil.isBlank((String)dict.getUid())) {
                dict.setUid(UUIDGenerator.generate((boolean)true).toString());
            }
            if (TextUtil.isBlank((String)dict.getCreatedBy())) {
                dict.setCreatedBy(LogicalStorage.get().getUser());
            }
            if (TextUtil.isBlank((String)dict.getModifiedBy())) {
                dict.setModifiedBy(LogicalStorage.get().getUser());
            }
            dict.setDataSource("SetupUpdateDictionaryCodeVariantsHandler");
            DictionaryStorage.get().save(dict);
            this.log.debug("dictionary with code " + dict + " was saved");
        }
    }
}

