/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SetupUpdateDictionaryHandler
extends BaseResourceSetupUpdateHandler {
    final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void execute(Element elm) throws Exception {
        String actionId = XHelper.readString((Element)elm, (String)"@action");
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        String dictClass = XHelper.readString((Element)elm, (String)"@dictClass");
        String dictCodes = XHelper.readString((Element)elm, (String)"@dictCodes");
        if ("updateVersion".equals(actionId)) {
            LogicalStorage.get().getDbPropertiesStorage().putValue("dicts-version", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            this.log.info("dict version was updated to " + LogicalStorage.get().getDbPropertiesStorage().getValue("dicts-version"));
            return;
        }
        if (!("replace".equals(actionId) || "add".equals(actionId) || "update".equals(actionId) || "delete".equals(actionId))) {
            this.log.warn("unsupported actionId: " + actionId + ", dictionary update will be skipped ");
            return;
        }
        if (!"delete".equals(actionId) && TextUtil.isBlank((String)fileName)) {
            this.log.warn("fileName is null, dictionary update will be skipped");
            return;
        }
        if (TextUtil.isBlank((String)dictClass)) {
            this.log.warn("class of dictionary is undefined, dictionary update will be skipped");
            return;
        }
        Class cls = XHelper.getClass((String)dictClass.trim());
        if (!BaseDictionary.class.isAssignableFrom(cls)) {
            this.log.warn(String.format("dictionary class %s is not instance of %s, skipping update", dictClass, BaseDictionary.class.getName()));
            return;
        }
        HashSet<String> codes = new HashSet<String>();
        if (!TextUtil.isBlank((String)dictCodes)) {
            for (String item : dictCodes.split(",")) {
                if (TextUtil.isBlank((String)item)) continue;
                codes.add(item.trim().toUpperCase());
            }
        }
        if ("delete".equals(actionId)) {
            this.delete(cls, codes);
            return;
        }
        URL url = null;
        url = this.getBaseResourceUrl() == null ? IoUtil.encodeUrl((URL)new URL(String.format("file:///%s/setup/dict/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName))) : IoUtil.file2url((File)new File(IoUtil.url2file((URL)this.getBaseResourceUrl()), String.format("dict/%s", fileName)));
        if (!IoUtil.isResourceExists((URL)url)) {
            this.log.warn(String.format("resource with URL \"%s\" does not exist", url));
            return;
        }
        if ("replace".equals(actionId)) {
            this.replaceAll(cls, url);
            return;
        }
        if ("add".equals(actionId) || "update".equals(actionId)) {
            this.update(cls, url, codes);
            return;
        }
    }

    private void delete(Class<BaseDictionary> cls, Set<String> codes) throws Exception {
        for (String code : codes) {
            this.log.debug(String.format("deleting dict %s with code %s", cls.getName(), code));
            BaseDictionary dict = DictionaryStorage.get().load(cls, code);
            if (dict == null) {
                this.log.debug(String.format("dict %s with code %s does not exist", cls.getName(), code));
                continue;
            }
            DictionaryStorage.get().delete(dict);
            this.log.debug(String.format("dict %s with code %s successfully deleted", cls.getName(), code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAll(Class<?> cls, URL url) throws Exception {
        this.log.info(String.format("starting replacing dictionary %s with data from url \"%s\"", cls.getName(), url));
        DictionaryStorage.get().deleteAll(cls);
        LogicalSession session = LogicalStorage.get().beginUnitOfWork();
        try {
            Element root;
            try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
                root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
            }
            root.getOwnerDocument().setDocumentURI(url.toExternalForm());
            int count = 0;
            for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
                if (!cls.getName().equals(XmlUtil.getValue((Element)objElm, (String)"@class"))) continue;
                BaseDictionary dict = (BaseDictionary)cls.newInstance();
                dict.fromXML(objElm);
                if (TextUtil.isBlank((String)dict.getUid())) {
                    dict.setUid(UUIDGenerator.generate((boolean)true).toString());
                }
                if (TextUtil.isBlank((String)dict.getCreatedBy())) {
                    dict.setCreatedBy(LogicalStorage.get().getUser());
                }
                if (TextUtil.isBlank((String)dict.getModifiedBy())) {
                    dict.setModifiedBy(LogicalStorage.get().getUser());
                }
                dict.setDataSource("SetupUpdateDictionaryHandler-replaceAll");
                DictionaryStorage.get().save(dict);
                if (++count % 1000 == 0) {
                    LogicalStorage.get().endUnitOfWork(session, false);
                }
                this.log.debug("dictionary with code " + dict + " was saved");
            }
            LogicalStorage.get().endUnitOfWork(session, false);
            LogicalStorage.get().getDbPropertiesStorage().putValue("dicts-version", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            LogicalStorage.get().endUnitOfWork(session, true);
            this.log.debug("DB properties were updated");
            this.log.info(String.format("dictionary %s was filled with data from url \"%s\"", cls.getName(), url));
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Class<BaseDictionary> cls, URL url, Set<String> codes) throws Exception {
        Element root;
        this.log.info(String.format("starting replacing dictionary %s with data from url \"%s\"", cls.getName(), url));
        try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        boolean allCodes = codes.contains("*");
        root.getOwnerDocument().setDocumentURI(url.toExternalForm());
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            if (!cls.getName().equals(XmlUtil.getValue((Element)objElm, (String)"@class")) || TextUtil.isBlank((String)XmlUtil.getValue((Element)objElm, (String)"code")) || !allCodes && !codes.contains(XmlUtil.getValue((Element)objElm, (String)"code").toUpperCase())) continue;
            BaseDictionary dict = DictionaryStorage.get().load(cls, XmlUtil.getValue((Element)objElm, (String)"code"));
            if (dict == null) {
                dict = cls.newInstance();
            }
            dict.fromXML(objElm);
            if (TextUtil.isBlank((String)dict.getUid())) {
                dict.setUid(UUIDGenerator.generate((boolean)true).toString());
            }
            if (TextUtil.isBlank((String)dict.getCreatedBy())) {
                dict.setCreatedBy(LogicalStorage.get().getUser());
            }
            if (TextUtil.isBlank((String)dict.getModifiedBy())) {
                dict.setModifiedBy(LogicalStorage.get().getUser());
            }
            dict.setDataSource("SetupUpdateDictionaryHandler-update");
            DictionaryStorage.get().save(dict);
            this.log.debug("dictionary with code " + dict + " was saved");
        }
    }
}

