/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.UpdatePolicy;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SetupUpdateEntityHandler
extends BaseResourceSetupUpdateHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Element elm) throws Exception {
        String uid = XHelper.readString((Element)elm, (String)"@uid");
        String actionId = XHelper.readString((Element)elm, (String)"@action");
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        String entityType = XHelper.readString((Element)elm, (String)"@entityType");
        boolean checkPoint = XHelper.readBoolean((Element)elm, (String)"@createCheckPoint", (boolean)false);
        if (TextUtil.isBlank((String)uid)) {
            this.log.warn("uid is null, entity update will be skipped");
            return;
        }
        if (TextUtil.isBlank((String)actionId)) {
            this.log.warn("actionId is null, entity update will be skipped");
            return;
        }
        if (!("add".equals(actionId) || "update".equals(actionId) || "delete".equals(actionId))) {
            this.log.warn("unknown actionId " + actionId);
            return;
        }
        if ("add".equals(actionId) || "update".equals(actionId)) {
            Element root;
            if (TextUtil.isBlank((String)fileName)) {
                this.log.warn("fileName is null, entity update will be skipped");
                return;
            }
            URL url = null;
            url = this.getBaseResourceUrl() == null ? IoUtil.encodeUrl((URL)new URL(String.format("file:///%s/setup/entity/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName))) : IoUtil.file2url((File)new File(IoUtil.url2file((URL)this.getBaseResourceUrl()), String.format("entity/%s", fileName)));
            if (!IoUtil.isResourceExists((URL)url)) {
                this.log.warn(String.format("resource with URL \"%s\" does not exist", url));
                return;
            }
            this.log.debug(String.format("starting update of entity with uid \"%s\" from url \"%s\"", uid, url));
            try (InputStream strm = IoUtil.getResourceInputStream((URL)url);){
                root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
            }
            root.getOwnerDocument().setDocumentURI(url.toExternalForm());
            LogicalStorage sm = LogicalStorage.get();
            boolean found = false;
            for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
                EntityStorage es;
                EntityContainer dbCtr;
                if (!EntityContainer.class.getName().equals(XmlUtil.getValue((Element)objElm, (String)"@class")) || !uid.equals("*") && !uid.equals(XmlUtil.getValue((Element)objElm, (String)"uid"))) continue;
                found = true;
                EntityContainer ctr = new EntityContainer(XHelper.getClass((String)XmlUtil.getValue((Element)objElm, (String)"entityType")));
                ctr.fromXML(objElm);
                if (TextUtil.isBlank((String)ctr.getUid())) {
                    ctr.setUid(UUIDGenerator.generate((boolean)true).toString());
                }
                if (TextUtil.isBlank((String)ctr.getCreatedBy())) {
                    ctr.setCreatedBy(sm.getUser());
                }
                if (TextUtil.isBlank((String)ctr.getModifiedBy())) {
                    ctr.setModifiedBy(sm.getUser());
                }
                if (TextUtil.isBlank((String)ctr.getVersionInfo().getCreatedBy())) {
                    ctr.getVersionInfo().setCreatedBy(sm.getUser());
                }
                if (TextUtil.isBlank((String)ctr.getVersionInfo().getModifiedBy())) {
                    ctr.getVersionInfo().setModifiedBy(sm.getUser());
                }
                if (checkPoint || TextUtil.isBlank((String)ctr.getVersionInfo().getDataSource())) {
                    ctr.getVersionInfo().setDataSource("setup-update");
                }
                if ((dbCtr = (es = EntityStorage.get()).resolve(ctr.toReference())) == null && "update".equalsIgnoreCase(actionId)) {
                    this.log.debug(String.format("update of entity \"%s\" is skipped due to absense of the entity in DB", ctr.toReference()));
                    if (uid.equals("*")) continue;
                    return;
                }
                if (dbCtr != null && "add".equalsIgnoreCase(actionId)) {
                    this.log.debug(String.format("addition of entity \"%s\" is skipped due to presense of the entity in DB", ctr.toReference()));
                    if (uid.equals("*")) continue;
                    return;
                }
                if (dbCtr != null && dbCtr.getUpdatePolicy() == UpdatePolicy.IGNORE) {
                    this.log.debug(String.format("update of entity \"%s\" is skipped due to update policy", ctr.toReference()));
                    if (uid.equals("*")) continue;
                    return;
                }
                if (dbCtr != null && !checkPoint) {
                    ctr.setVersionsCount(dbCtr.getVersionsCount());
                    ctr.getVersionInfo().setVersionNumber(dbCtr.getVersionInfo().getVersionNumber());
                    ctr.getVersionInfo().setUid(dbCtr.getVersionInfo().getUid());
                }
                if (dbCtr != null && checkPoint) {
                    ctr.getVersionInfo().setUid(UUIDGenerator.generate((boolean)true).toString());
                }
                LogicalEntityStorage.clearRevision(ctr);
                es.save(ctr, checkPoint);
                if (dbCtr == null) {
                    this.log.debug(String.format("entity with uid \"%s\" was added to DB", ctr.getUid()));
                    if (uid.equals("*")) continue;
                    return;
                }
                this.log.debug(String.format("entity with uid \"%s\" was updated", ctr.getUid()));
                if (!uid.equals("*")) break;
            }
            if (!uid.equals("*") && !found) {
                this.log.warn(String.format("resource with URL \"%s\" does not contain entity with uid \"%s\"", url, uid));
                return;
            }
        } else if ("delete".equals(actionId)) {
            if (TextUtil.isBlank((String)entityType)) {
                this.log.warn("entityType is null, entity update will be skipped");
                return;
            }
            EntityReference entityReference = new EntityReference(uid, XHelper.getClass((String)entityType), null);
            EntityContainer dbCtr = EntityStorage.get().resolve(entityReference);
            if (dbCtr == null) {
                this.log.debug(String.format("delete of entity \"%s\" is skipped due to absense of the entity in DB", entityReference));
                return;
            }
            EntityStorage.get().delete(dbCtr);
            this.log.debug(String.format("entity with uid \"%s\" was deleted", uid));
        }
    }
}

