/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.update.db.BaseResourceSetupUpdateHandler;
import com.gridnine.xtrip.server.update.db.DbUpdateFile;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import com.gridnine.xtrip.server.update.db.StorageUpdateHelper;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SetupUpdateHelper {
    private static final String SETUP_VERSION_PREFFIX = "setup_version";
    private static final Logger log = LoggerFactory.getLogger(SetupUpdateHelper.class);

    public static void cleanupDbStructure(URL url) throws Exception {
        StorageUpdateHelper.UpdateData updateData = StorageUpdateHelper.getUpdateData(url, SETUP_VERSION_PREFFIX, SetupUpdateHelper.createVersionProvider());
        String key = String.format("%s.%s", SETUP_VERSION_PREFFIX, updateData.id);
        log.debug("updating setup structure from " + url);
        if (updateData.id == null) {
            throw new IllegalStateException(String.format("update file %s has no id", url));
        }
        if (updateData.lastVersion == null) {
            throw new IllegalStateException(String.format("update file %s has no last version", url));
        }
        LogicalStorage.get().getDbPropertiesStorage().putValue(key, updateData.lastVersion);
        log.info(String.format("setup version of %s was set to %s", updateData.id, updateData.lastVersion));
    }

    private static StorageUpdateHelper.VersionProvider createVersionProvider() {
        return new StorageUpdateHelper.VersionProvider(){

            @Override
            public String getVersion(String key) throws Exception {
                return LogicalStorage.get().getDbPropertiesStorage().getValue(key);
            }
        };
    }

    public static void updateDbStructure(URL url, boolean pluginSetupFile) throws Exception {
        StorageUpdateHelper.UpdateData updateData = StorageUpdateHelper.getUpdateData(url, SETUP_VERSION_PREFFIX, SetupUpdateHelper.createVersionProvider());
        log.debug("updating setup structure from " + url);
        if (updateData.id == null) {
            throw new IllegalStateException(String.format("update file %s has no id", url));
        }
        if (updateData.lastVersion == null) {
            throw new IllegalStateException(String.format("update file %s has no last version", url));
        }
        if (updateData.sections.isEmpty()) {
            return;
        }
        String key = String.format("%s.%s", SETUP_VERSION_PREFFIX, updateData.id);
        HashMap<String, SetupUpdateHandler> setupHandlers = new HashMap<String, SetupUpdateHandler>();
        for (DbUpdateFile.DbUpdate section : updateData.sections) {
            for (Element command : section.getCommands()) {
                String handlerId = command.getAttribute("handlerClass");
                SetupUpdateHandler handler = (SetupUpdateHandler)setupHandlers.get(handlerId);
                if (handler == null) {
                    handler = (SetupUpdateHandler)Class.forName(handlerId).newInstance();
                    if (pluginSetupFile && handler instanceof BaseResourceSetupUpdateHandler) {
                        ((BaseResourceSetupUpdateHandler)handler).setBaseResourceUrl(IoUtil.file2url((File)IoUtil.url2file((URL)url).getParentFile()));
                    }
                    setupHandlers.put(handlerId, handler);
                }
                handler.execute(command);
            }
            LogicalStorage.get().getDbPropertiesStorage().putValue(key, section.getVersion());
        }
        System.out.println(String.format("%s setup data was updated to version \"%s\"", updateData.id, updateData.lastVersion));
    }

    private SetupUpdateHelper() {
    }
}

