/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.update.db.DbUpdateFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUpdateHelper {
    private static final Logger log = LoggerFactory.getLogger(StorageUpdateHelper.class);

    public static List<URL> getUpdateURLs() {
        PluginManager pm = PluginManager.lookup(StorageUpdateHelper.class);
        if (pm == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"DbUpdateFile")) {
            result.add(pm.getPluginClassLoader(ext.getDeclaringPluginDescriptor()).getResource(ext.getParameter("url").valueAsString()));
        }
        return result;
    }

    public static UpdateData getUpdateData(URL url, String prefix, VersionProvider clb) throws Exception {
        int maxIndex;
        String lastVersion;
        DbUpdateFile updateFile = new DbUpdateFile(url);
        List<DbUpdateFile.DbUpdate> sections = updateFile.getUpdates();
        if (sections.isEmpty()) {
            log.debug(String.format("update file %s is empty, skipping update", updateFile));
            return new UpdateData(updateFile.getFileId(), null, Collections.emptyList());
        }
        String key = String.format("%s.%s", prefix, updateFile.getFileId());
        String version = clb.getVersion(key);
        if (TextUtil.isSame((String)version, (String)(lastVersion = sections.get(maxIndex = sections.size() - 1).getVersion()))) {
            return new UpdateData(updateFile.getFileId(), lastVersion, Collections.emptyList());
        }
        int index = -1;
        if (TextUtil.isBlank((String)version)) {
            index = 0;
        } else {
            for (int n = 0; n < maxIndex; ++n) {
                if (!TextUtil.isSame((String)version, (String)sections.get(n).getVersion())) continue;
                index = n + 1;
                break;
            }
        }
        if (index == -1) {
            log.error(String.format("unable to find appropriate version in update file: update file id = %s, current version = %s.", key, version));
            return new UpdateData(updateFile.getFileId(), lastVersion, Collections.emptyList());
        }
        return new UpdateData(updateFile.getFileId(), lastVersion, sections.subList(index, maxIndex + 1));
    }

    private StorageUpdateHelper() {
    }

    public static interface VersionProvider {
        public String getVersion(String var1) throws Exception;
    }

    public static final class UpdateData {
        public final String id;
        public final String lastVersion;
        public final List<DbUpdateFile.DbUpdate> sections;

        public UpdateData(String fileId, String lastVersionValue, List<DbUpdateFile.DbUpdate> updateSections) {
            this.id = fileId;
            this.lastVersion = lastVersionValue;
            this.sections = updateSections;
        }
    }
}

