/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.update.db.DbUpdateHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SuAgencyCodesUpdateHandler
implements DbUpdateHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Element elm, Connection conn) throws Exception {
        Logger log = LoggerFactory.getLogger(this.getClass());
        String fileName = XHelper.readString((Element)elm, (String)"@fileName");
        Map<String, String> oldNewCodes = this.getOldNewCodes(fileName, log);
        String sql = "UPDATE organizationmetadataindexdata SET metadatastringvalue = ? WHERE metadatakey = 'KEY_SU_AGENCY_CODE' AND metadatastringvalue = ?";
        log.debug("executing SQL: " + sql);
        try (PreparedStatement st = conn.prepareStatement(sql);){
            conn.setAutoCommit(false);
            for (Map.Entry<String, String> entry : oldNewCodes.entrySet()) {
                String old = entry.getKey();
                String value = entry.getValue();
                st.setString(2, old);
                st.setString(1, old + "/" + value);
                st.executeUpdate();
            }
            conn.commit();
            log.info("update commited");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOldNewCodes(String fileName, Logger log) throws IOException {
        BufferedReader reader;
        HashMap<String, String> oldNewCodes;
        block6: {
            oldNewCodes = new HashMap<String, String>();
            if (TextUtil.isBlank((String)fileName)) {
                log.warn("file name aren't specified.");
                return oldNewCodes;
            }
            URL url = new URL(String.format("file:///%s/setup/entity/codes/%s", Environment.getConfigurationFolder().getCanonicalPath(), fileName));
            if (!IoUtil.isResourceExists((URL)url)) {
                log.debug(String.format("resource with URL \"%s\" does not exist", url));
                return oldNewCodes;
            }
            reader = null;
            reader = new BufferedReader(new InputStreamReader(IoUtil.getResourceInputStream((URL)url)));
            if (reader.readLine() != null) break block6;
            log.warn("data file was empty");
            HashMap<String, String> hashMap = oldNewCodes;
            IOUtils.closeQuietly((Reader)reader);
            return hashMap;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] pair = line.split(";");
                if (pair.length < 2 || pair[0].trim().isEmpty()) continue;
                oldNewCodes.put(pair[0].trim(), pair[1].trim());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return oldNewCodes;
    }
}

