/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.update.db;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class UpdateScheduledTaskHandler
implements SetupUpdateHandler {
    private static final transient Logger log = LoggerFactory.getLogger(UpdateScheduledTaskHandler.class);

    @Override
    public void execute(Element command) throws Exception {
        String jobClass = XHelper.readString((Element)command, (String)"@jobClass");
        if (TextUtil.isBlank((String)jobClass)) {
            log.warn("job class is null, task update will be skipped");
            return;
        }
        String cron = XHelper.readString((Element)command, (String)"@cron");
        Long period = XHelper.readLong((Element)command, (String)"@period");
        Long delay = XHelper.readLong((Element)command, (String)"@delay");
        LogicalEntityStorage entityStorage = LogicalStorage.get().getEntityStorage();
        List<String> uids = entityStorage.getEntityUids(ScheduledTaskSettings.class, null, null, true, false, null, null);
        for (String uid : uids) {
            EntityContainer<ScheduledTaskSettings> etc = entityStorage.load(ScheduledTaskSettings.class, uid, new EntityStorageLoadParameters());
            if (etc == null || !jobClass.equals(((ScheduledTaskSettings)etc.getEntity()).getJobClass())) continue;
            ScheduledTaskSettings scheduledTaskSettings = (ScheduledTaskSettings)etc.getEntity();
            scheduledTaskSettings.setCron(cron);
            scheduledTaskSettings.setPeriod(period);
            scheduledTaskSettings.setDelay(delay);
            entityStorage.save(etc, true);
        }
    }
}

