/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.util;

import com.gridnine.xtrip.common.model.Xeption;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;

public class ErrorsHelper {
    private static final ErrorsHelper INSTANCE = new ErrorsHelper();

    public static ErrorsHelper get() {
        return INSTANCE;
    }

    public void translate(IOException e) {
        if (this.specify(e)) {
            throw Xeption.forEndUser((String)"\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c.", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public boolean specify(IOException e) throws Xeption {
        if (e instanceof SocketException) {
            return this.specify((SocketException)e);
        }
        if (e instanceof InterruptedIOException) {
            return this.specify((InterruptedIOException)e);
        }
        if (e instanceof NoHttpResponseException) {
            throw Xeption.forEndUser((String)"\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u043e\u0442\u0432\u0435\u0442 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430", (Object[])new Object[0]);
        }
        if (e instanceof UnknownHostException) {
            throw Xeption.forEndUser((String)"\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0445\u043e\u0441\u0442", (Throwable)e, (Object[])new Object[0]);
        }
        if ("Attempted read from closed stream.".equals(e.getMessage())) {
            throw Xeption.forEndUser((String)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0431\u044b\u043b\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u043e", (Throwable)e, (Object[])new Object[0]);
        }
        if (SSLException.class.isInstance(e)) {
            this.specify((SSLException)e);
        }
        return false;
    }

    private void specify(SSLException sslException) {
        SSLHandshakeException sslHandshakeException;
        if (SSLHandshakeException.class.isInstance(sslException) && "Remote host closed connection during handshake".equals((sslHandshakeException = (SSLHandshakeException)sslException).getMessage())) {
            throw Xeption.forEndUser((String)"ERRORS_HELPER_REMOTE_HOST_CLOSED_CONNECTION_DURING_HANDSHAKE", (Throwable)sslException, (Object[])new Object[0]);
        }
    }

    protected boolean specify(InterruptedIOException e) {
        if (e instanceof SocketTimeoutException) {
            if (StringUtils.isBlank((String)e.getMessage()) || "Read timed out".equals(e.getMessage())) {
                throw Xeption.forEndUser((String)"\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430", (Throwable)e, (Object[])new Object[0]);
            }
            if ("connect timed out".equals(e.getMessage())) {
                return true;
            }
            if ("Network is unreachable (connect failed)".equals(e.getMessage())) {
                throw Xeption.forEndUser((String)"\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u0432\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c", (Throwable)e, (Object[])new Object[0]);
            }
        } else if (e instanceof ConnectTimeoutException) {
            return true;
        }
        return false;
    }

    protected boolean specify(SocketException e) {
        if (e instanceof NoRouteToHostException) {
            throw Xeption.forEndUser((String)"\u041d\u0435\u0442 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430 \u0434\u043e \u0443\u0437\u043b\u0430", (Throwable)e, (Object[])new Object[0]);
        }
        if ("Connection reset".equals(e.getMessage())) {
            throw Xeption.forEndUser((String)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441\u0431\u0440\u043e\u0448\u0435\u043d\u043e", (Throwable)e, (Object[])new Object[0]);
        }
        if (e instanceof ConnectException) {
            Throwable cause = e.getCause();
            if (Objects.isNull(cause)) {
                return false;
            }
            String causeMessage = cause.getMessage();
            if (Objects.isNull(causeMessage)) {
                return false;
            }
            if ((causeMessage = causeMessage.toLowerCase()).contains("connection refused")) {
                throw Xeption.forEndUser((String)"\u0412 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0438 \u043e\u0442\u043a\u0430\u0437\u0430\u043d\u043e", (Throwable)e, (Object[])new Object[0]);
            }
            if (causeMessage.contains("connection timed out")) {
                throw Xeption.forEndUser((String)"\u0412\u0440\u0435\u043c\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0438\u0441\u0442\u0435\u043a\u043b\u043e", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return false;
    }
}

