import java.util.Map.Entry
import java.util.stream.Collectors

import org.slf4j.Logger
import org.slf4j.LoggerFactory

import com.gridnine.xtrip.common.model.EntityReference
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType
import com.gridnine.xtrip.common.model.finance.TransactionSplitIndex
import com.gridnine.xtrip.common.model.profile.BaseProfile
import com.gridnine.xtrip.common.model.profile.CardIndex
import com.gridnine.xtrip.common.model.profile.Organization
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.search.SortOrder

Logger logger = LoggerFactory.getLogger('groovy-script')

logger.info("CRTDT: transactions delete started")

int count = 0
int limit = 1000

try {

    // Input organization uid here!
    def uid = ''

    EntityReference<Organization> organization = EntityStorage.get().actualize(new EntityReference<Organization>(uid, Organization.class, null))

    logger.info("CRTDT: organization " + organization + " | " + organization.getUid())

    SearchQuery query = new SearchQuery()

    query.getCriteria().getCriterions().add(SearchCriterion.eq(ChartOfAccountsElementIndex.Property.organization.name(), organization))

    List<EntityReference<ChartOfAccountsElement>> chartOfAccountsElements = EntityStorage.get().search(ChartOfAccountsElementIndex.class, query).getData().stream().filter({item -> item.getType() == ChartOfAccountsElementType.CASH_REMAINS_CUSTOMER || item.getType() == ChartOfAccountsElementType.CASH_REMAINS_AGENT || item.getType() == ChartOfAccountsElementType.CASH_REMAINS_CASH || item.getType() == ChartOfAccountsElementType.CASH_REMAINS_STASH || item.getType() == ChartOfAccountsElementType.CASH_REMAINS_CORRECTION}).map({item -> item.getSource()}).collect(Collectors.toList())

    logger.info("CRTDT: found " + chartOfAccountsElements.size())
    
    for(EntityReference<ChartOfAccountsElement> chartOfAccountsElement : chartOfAccountsElements) {

        logger.info("CRTDT: processing " + chartOfAccountsElement + " | " + chartOfAccountsElement.getUid())

        while(true) {

            logger.info("CRTDT: searching " + limit)

            query = new SearchQuery()
            
            query.getCriteria().getCriterions().add(SearchCriterion.eq(TransactionSplitIndex.Property.accountUid.name(), chartOfAccountsElement.getUid()))
            
            query.setLimit(limit)

            List<TransactionSplitIndex> indexes = EntityStorage.get().search(TransactionSplitIndex.class, query).getData()

            logger.info("CRTDT: found " + indexes.size())
            
            if(indexes.size() == 0) {
                break
            }
            
            int subcount = 0
            
            for(TransactionSplitIndex index : indexes) {
                
                logger.info("CRTDT: delete " + subcount + " of " + indexes.size())
                
                EntityStorage.get().delete(index.getSource())
                
                subcount++
                count++
            }
            
            logger.info("CRTDT: deleted")
        }
    }

} catch(Throwable t) {
    logger.error('', t)
}

logger.info("CRTDT: deleted " + count)

logger.info("CRTDT: transactions delete finished")
