/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.model.index;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentIndexData;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;

public class FinanceDocumentIndexHandler
extends com.gridnine.xtrip.server.model.index.FinanceDocumentIndexHandler {
    private static SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    protected void performAdditionalDataUpdate(FinanceDocumentIndexData data, Payment payment, FinanceDocument financeDocument) {
        super.performAdditionalDataUpdate(data, payment, financeDocument);
        data.setPaid(Boolean.valueOf(financeDocument.isPaid()));
        data.setTravellersNames(this.generateNameString(payment, financeDocument));
        data.setRoute(this.generateRouteString(payment, financeDocument));
        data.setRegistrationId(this.generateClientRegistrationId(payment));
        data.setRemarks(financeDocument.getRemarks());
        this.updateClientPaymentType(data, payment, financeDocument);
    }

    private void updateClientPaymentType(FinanceDocumentIndexData data, Payment payment, FinanceDocument financeDocument) {
        for (BillingItem item : financeDocument.getBillingItems()) {
            if (item.getServiceType() == ServiceType.TICKET) {
                data.setClientFopType(payment.getSupplierFop() != null ? payment.getSupplierFop().getType() : null);
                break;
            }
            if (item.getServiceType() == ServiceType.TICKET || item.getServiceType() == ServiceType.PENALTY) continue;
            data.setClientFopType(payment.getFop() != null ? payment.getFop().getType() : null);
            break;
        }
    }

    private String generateRouteString(Payment payment, FinanceDocument financeDocument) {
        LinkedList<String> resultSet = new LinkedList<String>();
        for (BillingItem item : financeDocument.getBillingItems()) {
            for (String uid : item.getProductUids()) {
                BaseProduct bProd = BookingHelper.findProductByUid((String)uid, (BookingFile)payment.getBookingFile());
                if (bProd == null) continue;
                LinkedList<String> productSet = new LinkedList<String>();
                if (bProd instanceof Product) {
                    this.getRouteInfo((Product)bProd, productSet);
                }
                if (bProd instanceof RailwayProduct) {
                    this.getRouteInfo((RailwayProduct)bProd, productSet);
                }
                if (bProd instanceof InsuranceTouristic) {
                    this.getRouteInfo((InsuranceTouristic)bProd, productSet);
                }
                resultSet.add(TextUtil.join((String)", ", productSet));
            }
        }
        return TextUtil.join((String)"; ", resultSet);
    }

    private void getRouteInfo(InsuranceTouristic bProd, List<String> resultSet) {
        String startDate = "?";
        String endDate = "?";
        if (bProd.getStartDate() != null && bProd.getEndDate() != null) {
            SimpleDateFormat dateFormat = FinanceDocumentIndexHandler.createDateFormat();
            startDate = dateFormat.format(bProd.getStartDate());
            endDate = dateFormat.format(bProd.getEndDate());
        }
        resultSet.add(bProd.getCountryName() + " (" + startDate + " \u2013 " + endDate + ")");
    }

    private void getRouteInfo(RailwayProduct bProd, List<String> resultSet) {
        for (RailwaySegment seg : bProd.getSegments()) {
            String depCountryAndCity = "?";
            depCountryAndCity = this.getCountryAndCityRailway((DictionaryReference<RailwayStation>)seg.getDepartureStation());
            String arrCountryAndCity = "?";
            arrCountryAndCity = this.getCountryAndCityRailway((DictionaryReference<RailwayStation>)seg.getArriveStation());
            String date = "?";
            if (seg.getDepartureDate() != null) {
                date = FinanceDocumentIndexHandler.createDateFormat().format(seg.getDepartureDate());
            }
            resultSet.add(depCountryAndCity + " \u2014 " + arrCountryAndCity + " (" + date + ")");
        }
    }

    private void getRouteInfo(Product bProd, List<String> resultSet) {
        for (SegmentTariff segTarriff : bProd.getSegmentTariffs()) {
            for (Segment seg : segTarriff.getSegments()) {
                String depCountryAndCity = "?";
                depCountryAndCity = this.getCountryAndCity((DictionaryReference<GeoLocation>)seg.getDepartureLocation());
                String arrCountryAndCity = "?";
                arrCountryAndCity = this.getCountryAndCity((DictionaryReference<GeoLocation>)seg.getArriveLocation());
                String date = "?";
                if (seg.getStartDate() != null) {
                    date = FinanceDocumentIndexHandler.createDateFormat().format(seg.getStartDate());
                }
                resultSet.add(depCountryAndCity + " \u2014 " + arrCountryAndCity + " (" + date + ")");
            }
        }
    }

    private String getCountryAndCity(DictionaryReference<GeoLocation> locRef) {
        DictionaryCache cache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
        GeoLocation loc = (GeoLocation)cache.resolveReference(locRef);
        if (loc == null) {
            return "";
        }
        Country co = loc.getCountry() != null ? (Country)cache.resolveReference(loc.getCountry()) : null;
        String country = co != null ? co.getCode() : "";
        GeoLocation ci = null;
        String city = loc.getType().equals((Object)LocationType.AIRPORT) ? ((ci = (GeoLocation)cache.resolveReference(loc.getParent())) != null ? ci.toString() : "") : loc.toString();
        if (TextUtil.isBlank((String)country)) {
            if (TextUtil.isBlank((String)city)) {
                return "";
            }
            return city;
        }
        if (TextUtil.isBlank((String)city)) {
            return country;
        }
        return country + ", " + city;
    }

    private String getCountryAndCityRailway(DictionaryReference<RailwayStation> locRef) {
        DictionaryCache cache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
        RailwayStation loc = (RailwayStation)cache.resolveReference(locRef);
        String country = "";
        String city = "?";
        if (loc.getCountry() != null) {
            country = ((Country)cache.resolveReference(loc.getCountry())).toString();
        }
        city = loc.toString();
        return !TextUtil.isBlank((String)country) ? country + ", " + city : city;
    }

    private String generateNameString(Payment payment, FinanceDocument financeDocument) {
        LinkedList<String> resultSet = new LinkedList<String>();
        for (BillingItem item : financeDocument.getBillingItems()) {
            for (String uid : item.getProductUids()) {
                BaseProduct bProd = BookingHelper.findProductByUid((String)uid, (BookingFile)payment.getBookingFile());
                if (bProd == null) continue;
                LinkedList<String> productSet = new LinkedList<String>();
                ProductHandler handler = ((HandlersRegistry)Environment.getPublished(HandlersRegistry.class)).findProductHandler(bProd.getClass());
                for (Traveller t : handler.getTravellers(bProd)) {
                    productSet.add(t.getName());
                }
                resultSet.add(TextUtil.join((String)", ", productSet));
            }
        }
        return TextUtil.join((String)"; ", resultSet);
    }

    private String generateClientRegistrationId(Payment payment) {
        Organization client;
        BookingFile bf = payment.getBookingFile();
        EntityContainer organizationContainer = EntityStorage.get().resolve(bf.getCustomerProfile());
        Organization organization = client = organizationContainer != null ? (Organization)organizationContainer.getEntity() : null;
        return client != null ? (!TextUtil.isBlank((String)client.getRegistrationId()) ? client.getRegistrationId() : "?") : "?";
    }

    protected void performAdditionalDataAggregation(DataAggregator aggregator, Payment payment, FinanceDocument financeDocument) {
        super.performAdditionalDataAggregation(aggregator, payment, financeDocument);
        aggregator.aggregate((Object)financeDocument.isPaid());
        aggregator.aggregate((Object)this.generateNameString(payment, financeDocument));
        aggregator.aggregate((Object)this.generateRouteString(payment, financeDocument));
        aggregator.aggregate((Object)this.generateClientRegistrationId(payment));
        aggregator.aggregate((Object)financeDocument.getRemarks());
    }
}

