/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.model.tasks.handlers;

import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.server.model.tasks.TaskProcessHandler;
import java.util.Arrays;
import java.util.List;

public class BulgariaFinanceDocumentSettingsBillingItemsSettingsUpdateTaskProcessHandler
implements TaskProcessHandler<FinanceDocumentSettings> {
    public String getId() {
        return "finance-document-settings-billing-items-settings-update-task-process-handler";
    }

    public boolean process(FinanceDocumentSettings entity) {
        if (entity.getType() == FinanceDocumentType.BULGARIA_PROTOCOL) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET));
        }
        if (entity.getType() == FinanceDocumentType.BULGARIA_PROTOCOL_CREDIT_NOTE) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.TICKET));
        }
        if (entity.getType() == FinanceDocumentType.BULGARIA_INVOICE) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.FEE));
        }
        if (entity.getType() == FinanceDocumentType.BULGARIA_INVOICE_CREDIT_NOTE) {
            return this.updateBillingItemsSettings(entity, Arrays.asList(ServiceType.FEE));
        }
        return false;
    }

    private boolean updateBillingItemsSettings(FinanceDocumentSettings financeDocumentSettings, List<ServiceType> serviceTypes) {
        if (!financeDocumentSettings.isUseSettings()) {
            return false;
        }
        boolean processed = false;
        for (ServiceType serviceType : ServiceType.values()) {
            boolean includeVat;
            boolean useBillingItem;
            BillingItemSettings billingItemSettings = FinanceDocumentsHelper.getBillingItemSettings((List)financeDocumentSettings.getBillingItemsSettings(), (ServiceType)serviceType);
            if (billingItemSettings == null) {
                billingItemSettings = new BillingItemSettings();
                billingItemSettings.setType(serviceType);
                financeDocumentSettings.getBillingItemsSettings().add(billingItemSettings);
                processed = true;
            }
            if ((useBillingItem = serviceTypes.contains(serviceType)) != billingItemSettings.isUseBillingItem()) {
                billingItemSettings.setUseBillingItem(useBillingItem);
                processed = true;
            }
            if (!useBillingItem || (includeVat = financeDocumentSettings.isIncludeVat()) == billingItemSettings.isIncludeVat()) continue;
            billingItemSettings.setIncludeVat(includeVat);
            processed = true;
        }
        return processed;
    }
}

