/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.reports.prepare.amexreports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bg.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.bg.reports.fields.BulgariaAmexReportFields;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaAmexReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.amexreport.BulgariaAmexReportTicket;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCode;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.bg.reports.prepare.amexreports.BulgariaAmexReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulgariaAmexReportAirPrepareHandler
implements BulgariaAmexReportProductPrepareHandler<Product> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public List<BulgariaAmexReportTicket> createTickets(Product product, Map<String, Object> data) {
        LinkedList<BulgariaAmexReportTicket> result = new LinkedList<BulgariaAmexReportTicket>();
        int sequenceNumber = 1;
        int segTariffsSize = 0;
        if (product.getSegmentTariffs() != null) {
            segTariffsSize = product.getSegmentTariffs().size();
        }
        int numberOfSegTariffStrings = segTariffsSize != 0 ? segTariffsSize : 1;
        for (int tariffNum = 0; tariffNum < numberOfSegTariffStrings; ++tariffNum) {
            SegmentTariff segTariff = null;
            if (segTariffsSize != 0) {
                segTariff = (SegmentTariff)product.getSegmentTariffs().get(tariffNum);
            }
            int segSize = 0;
            if (segTariff != null && segTariff.getSegments() != null) {
                segSize = segTariff.getSegments().size();
            }
            int numberOfSegStrings = segSize != 0 ? segSize : 1;
            for (int segNum = 0; segNum < numberOfSegStrings; ++segNum) {
                Branch branch;
                EntityContainer branchCont;
                CurrencyInfo equivalentCurrencyInfo;
                List payments;
                Organization customer;
                boolean firstLine;
                HashMap<BulgariaAmexReportFields, Object> ticket = new HashMap<BulgariaAmexReportFields, Object>();
                Segment seg = null;
                if (segTariff != null && segSize != 0) {
                    seg = (Segment)segTariff.getSegments().get(segNum);
                }
                boolean bl = firstLine = tariffNum == 0 && segNum == 0;
                if (product.getReservation().getBookingFile().getCustomerProfile() != null && (customer = (Organization)EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile()).getEntity()) != null) {
                    ticket.put(BulgariaAmexReportFields.ACCOUNT_NUMBER_OF_CLIENT, customer.getCode());
                }
                if ((payments = product.getReservation().getBookingFile().getPayments()) != null) {
                    block4: for (Payment payment : payments) {
                        if (payment.getFinanceDocuments() == null) continue;
                        for (FinanceDocument doc : payment.getFinanceDocuments()) {
                            int itemNumber = 0;
                            if (doc.getBillingItems() == null) continue;
                            for (BillingItem item : doc.getBillingItems()) {
                                ++itemNumber;
                                if (item.getProductUids() == null || !item.getProductUids().contains(product.getUid())) continue;
                                ticket.put(BulgariaAmexReportFields.ITEM_NUMBER, String.valueOf(itemNumber));
                                ticket.put(BulgariaAmexReportFields.INVOICE_DATE, doc.getDate());
                                ticket.put(BulgariaAmexReportFields.INVOICE_NUMBER, doc.getNumber());
                                break block4;
                            }
                        }
                    }
                }
                if ((equivalentCurrencyInfo = DictHelper.getCurrencyInfoByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null))) != null && equivalentCurrencyInfo.getCode() != null) {
                    ticket.put(BulgariaAmexReportFields.CURRENCY_CODE, equivalentCurrencyInfo.getCode());
                }
                ProductStatus status = product.getStatus();
                ticket.put(BulgariaAmexReportFields.VENDOR_TYPE, "0");
                if (product.getTraveller() != null) {
                    String[] travellerNameSplit;
                    String travellerName = product.getTraveller().getName();
                    if (!TextUtil.isBlank((String)travellerName) && (travellerNameSplit = travellerName.split(" ")).length == 2) {
                        travellerName = travellerNameSplit[0] + "/" + travellerNameSplit[1];
                    }
                    ticket.put(BulgariaAmexReportFields.PASSENGER_NAME, travellerName);
                }
                if (seg != null) {
                    ticket.put(BulgariaAmexReportFields.DEPARTURE_DATE, seg.getStartDate());
                }
                if (firstLine) {
                    String systemNumber = product.getSystemNumber();
                    LinkedList<String> conjNums = new LinkedList<String>();
                    for (int n = 0; n < product.getConjCount(); ++n) {
                        try {
                            String toAdd = FormattedNumberUtil.add((String)systemNumber, (long)(n + 1));
                            conjNums.add(toAdd.substring(systemNumber.length() - 3, systemNumber.length()));
                            continue;
                        }
                        catch (Exception e) {
                            this.log.error("unable to parse ticket number " + systemNumber, (Throwable)e);
                        }
                    }
                    String conjString = TextUtil.join((String)" ", conjNums);
                    ticket.put(BulgariaAmexReportFields.CONJ_TICKET_NUMBER, conjString);
                    BigDecimal totalEquivFare = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateTotalEquivalentFare((Product)product);
                    BigDecimal totalEquivTax = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateTaxesEquivalentAmount((Product)product);
                    if (ProductStatus.EXCHANGE.equals((Object)status) || ProductStatus.REFUND.equals((Object)status)) {
                        if (totalEquivFare != null) {
                            totalEquivFare = totalEquivFare.multiply(BigDecimal.valueOf(-1L));
                        }
                        if (totalEquivTax != null) {
                            totalEquivTax = totalEquivTax.multiply(BigDecimal.valueOf(-1L));
                        }
                    }
                    ticket.put(BulgariaAmexReportFields.TOTAL_TRANSACTION_AMOUNT, totalEquivFare);
                    ticket.put(BulgariaAmexReportFields.TOTAL_TAX_AMOUNT, totalEquivTax);
                }
                if (firstLine) {
                    if (ProductStatus.EXCHANGE.equals((Object)status)) {
                        ticket.put(BulgariaAmexReportFields.REFUND_EXCHANGE, "E");
                    }
                    if (ProductStatus.REFUND.equals((Object)status)) {
                        ticket.put(BulgariaAmexReportFields.REFUND_EXCHANGE, "R");
                    }
                }
                ticket.put(BulgariaAmexReportFields.E_TICKET, product.isEticket());
                if (product.getBranch() != null && (branchCont = EntityStorage.get().resolve(product.getBranch())) != null && (branch = (Branch)branchCont.getEntity()) != null) {
                    ticket.put(BulgariaAmexReportFields.AGENCY_BRANCH_CODE, branch.getCode());
                }
                ticket.put(BulgariaAmexReportFields.PNR, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
                ticket.put(BulgariaAmexReportFields.PNR_CREATION_DATE, product.getReservation().getResDate());
                ticket.put(BulgariaAmexReportFields.DOMESTIC_INTERNATIONAL, AirProductHelper.getTransportationTypeString((Product)product));
                ticket.put(BulgariaAmexReportFields.VALIDATING_AIRLINE, product.getCarrierNumber());
                if (product.getStatisticalData() != null) {
                    List costCodes;
                    StatisticalData sData = product.getStatisticalData();
                    if (sData.getReasonCodes() != null && sData.getReasonCodes().size() != 0) {
                        ticket.put(BulgariaAmexReportFields.REASON_CODE, ((ReasonCode)sData.getReasonCodes().get(0)).getName());
                    }
                    if (sData.getHbf2Tkt() != null) {
                        ticket.put(BulgariaAmexReportFields.BM_NORMAL_FARE, String.valueOf(sData.getHbf2Tkt()));
                    }
                    if (sData.getLaf1Tkt() != null) {
                        ticket.put(BulgariaAmexReportFields.BM_LOWEST_FARE, String.valueOf(sData.getLaf1Tkt()));
                    }
                    if ((costCodes = StatisticsHelper.getAllCostCodes((StatisticalData)sData)) != null) {
                        int costCodesSize = costCodes.size() <= 9 ? costCodes.size() : 9;
                        for (int i = 0; i < costCodesSize; ++i) {
                            CostCode code = (CostCode)costCodes.get(i);
                            if (code == null || code.getCostCodeProperties() == null) continue;
                            ticket.put(BulgariaAmexReportFields.getRemarkFieldByNumber((int)(code.getCostCodeProperties().getType().ordinal() + 1)), code.getValue());
                        }
                    }
                }
                if (seg != null) {
                    GeoLocation arrive;
                    GeoLocation depart;
                    ticket.put(BulgariaAmexReportFields.FLIGHT_NUMBER, seg.getFlightNo());
                    ticket.put(BulgariaAmexReportFields.FLIGHT_FARE_BASIS_CODE, seg.getFareBasis());
                    ticket.put(BulgariaAmexReportFields.CLASS_OF_SERVICE, seg.getClassOfService());
                    if (seg.getAirline() != null) {
                        ticket.put(BulgariaAmexReportFields.AIR_CARRIER_CODE, seg.getAirline().getCode());
                    }
                    if (segNum == segSize - 1) {
                        ticket.put(BulgariaAmexReportFields.STOPOVER_CONNECTION, "O");
                    } else {
                        ticket.put(BulgariaAmexReportFields.STOPOVER_CONNECTION, "X");
                    }
                    ticket.put(BulgariaAmexReportFields.FLIGHT_SEQUENCE_NUMBER, sequenceNumber++);
                    DictionaryCache dCache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
                    if (seg.getDepartureLocation() != null && (depart = (GeoLocation)dCache.resolveReference(seg.getDepartureLocation())) != null) {
                        ticket.put(BulgariaAmexReportFields.DEPARTURE_AIRPORT_CODE, depart.getCodeVariants().get(CodeSystem.IATA.name()));
                    }
                    if (seg.getArriveLocation() != null && (arrive = (GeoLocation)dCache.resolveReference(seg.getArriveLocation())) != null) {
                        ticket.put(BulgariaAmexReportFields.ARRIVAL_AIRPORT_CODE, arrive.getCodeVariants().get(CodeSystem.IATA.name()));
                    }
                    ticket.put(BulgariaAmexReportFields.DEPARTURE_DATE_SEG, seg.getStartDate());
                    ticket.put(BulgariaAmexReportFields.ARRIVAL_DATE_SEG, seg.getEndDate());
                    ticket.put(BulgariaAmexReportFields.DEPARTURE_TIME, seg.getStartDate());
                    ticket.put(BulgariaAmexReportFields.ARRIVAL_TIME, seg.getEndDate());
                }
                ticket.put(BulgariaAmexReportFields.TICKET_NUMBER, product.getSystemNumber());
                result.add(new BulgariaAmexReportTicket(ticket));
            }
        }
        return result;
    }

    @Override
    public BulgariaAmexReportProductPrepareHandler.ProductsListProxy<Product> getProducts(BulgariaAmexReportParameters params, List<Message> messages) throws Exception {
        BulgariaAmexReportProductPrepareHandler.ProductsListProxy<Product> result = new BulgariaAmexReportProductPrepareHandler.ProductsListProxy<Product>();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        EntityReference agencyReference = params.getAgency();
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (!params.getClients().isEmpty()) {
            HashSet<SearchCriterion> clientsCriterions = new HashSet<SearchCriterion>();
            for (Object ref : params.getClients()) {
                clientsCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.client.name(), (Object)ref));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])clientsCriterions.toArray(new SearchCriterion[clientsCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (ProductIndex index : EntityStorage.get().search(ProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference> salesPoints = new HashSet<EntityReference>();
        HashSet<EntityReference> vendors = new HashSet<EntityReference>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block4: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product) || !this.isIssuedInReportPeriod(params, (Product)prod) && !this.isPayedInReportPeriod(params, (Product)prod, true) && !this.isRefusedInReportPeriod(params, (Product)prod, true)) continue;
                        Product product = (Product)prod;
                        result.getProducts().add(product);
                        if (product.getBlankOwnerRef() != null) {
                            vendors.add(product.getBlankOwnerRef());
                        }
                        if (!this.isIssuedInReportPeriod(params, (Product)prod) || product.getSalesPoint() == null) continue block4;
                        salesPoints.add(product.getSalesPoint());
                        continue block4;
                    }
                }
            }
        }
        result.getActualVendors().addAll(vendors);
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    public boolean isRefusedInReportPeriod(BulgariaAmexReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : com.gridnine.xtrip.common.model.helpers.AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate())) continue;
            return true;
        }
        return false;
    }

    private boolean isPayedInReportPeriod(BulgariaAmexReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : com.gridnine.xtrip.common.model.helpers.AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (params.getPeriodBegin() != null && (fop.getOperationDate() == null || fop.getOperationDate().before(params.getPeriodBegin())) || params.getPeriodEnd() != null && (fop.getOperationDate() == null || fop.getOperationDate().after(params.getPeriodEnd()))) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuedInReportPeriod(BulgariaAmexReportParameters params, Product prod) {
        if (params.getPeriodBegin() != null && (prod.getIssueDate() == null || prod.getIssueDate().before(params.getPeriodBegin()))) {
            return false;
        }
        return params.getPeriodEnd() == null || prod.getIssueDate() != null && !prod.getIssueDate().after(params.getPeriodEnd());
    }

    @Override
    public void validateProducts(Collection<Product> products, List<Message> messages) throws Exception {
        for (Product prod : products) {
            BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)prod, messages);
        }
    }
}

