/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.reports.prepare.amexreports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bg.reports.fields.BulgariaAmexReportFields;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaAmexReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.amexreport.BulgariaAmexReportTicket;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductFop;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.bg.reports.prepare.amexreports.BulgariaAmexReportProductPrepareHandler;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulgariaAmexReportHotelPrepareHandler
implements BulgariaAmexReportProductPrepareHandler<HotelProduct> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<BulgariaAmexReportTicket> createTickets(HotelProduct product, Map<String, Object> data) {
        LinkedList<BulgariaAmexReportTicket> result = new LinkedList<BulgariaAmexReportTicket>();
        int line = 0;
        for (Room room : product.getRooms()) {
            HashMap<BulgariaAmexReportFields, Object> ticket = new HashMap<BulgariaAmexReportFields, Object>();
            if (line == 0) {
                BulgariaAmexReportHotelPrepareHandler.fillFirstLineOnlyFields(product, ticket);
            }
            this.fillAnyLineFields(product, room, ticket);
            result.add(new BulgariaAmexReportTicket(ticket));
            ++line;
        }
        return result;
    }

    private void fillAnyLineFields(HotelProduct product, Room room, Map<BulgariaAmexReportFields, Object> ticket) {
        Money baseRate;
        GeoLocation hotelLocation;
        ticket.put(BulgariaAmexReportFields.HOTEL_NAME, product.getHotelName());
        ticket.put(BulgariaAmexReportFields.HOTEL_PHONE_NUMBER, product.getHotelPhone());
        if (product.getHotelLocation() != null && (hotelLocation = (GeoLocation)((DictionaryCache)Environment.getPublished(DictionaryCache.class)).resolveReference(product.getHotelLocation())) != null) {
            ticket.put(BulgariaAmexReportFields.HOTEL_CITY_CODE, hotelLocation.getCode());
            ticket.put(BulgariaAmexReportFields.HOTEL_CITY_NAME, hotelLocation.getTranslations().get(LocaleHelper.getCurrentLocale()));
        }
        if ((baseRate = room.getBaseRate()) != null) {
            String curr = baseRate.getCurrency();
            if (curr != null) {
                ticket.put(BulgariaAmexReportFields.HOTEL_CURRENCY_CODE, curr);
            }
            ticket.put(BulgariaAmexReportFields.HOTEL_NIGHTLY_RATE, baseRate.getValue());
        }
        ticket.put(BulgariaAmexReportFields.DATE_IN, room.getCheckInDate());
        ticket.put(BulgariaAmexReportFields.DATE_OUT_NUMBER_OF_NIGHTS, room.getCheckOutDate());
        ticket.put(BulgariaAmexReportFields.HOTEL_CHAIN_CODE, product.getHotelChainCode());
        ticket.put(BulgariaAmexReportFields.GDS_PROPERTY_CODE, product.getHotelPropertyId());
        ticket.put(BulgariaAmexReportFields.HOTEL_ADDRESS, product.getHotelAddress());
        ticket.put(BulgariaAmexReportFields.HOTEL_POST_CODE_ZIP, null);
        ticket.put(BulgariaAmexReportFields.HOTEL_ROOM_TYPE, room.getRoomSize());
        ticket.put(BulgariaAmexReportFields.CONFIRMATION_NUMBER, product.getCF());
    }

    protected static void fillFirstLineOnlyFields(HotelProduct product, Map<BulgariaAmexReportFields, Object> ticket) {
        Organization customer;
        if (product.getReservation().getBookingFile().getCustomerProfile() != null && (customer = (Organization)EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile()).getEntity()) != null) {
            ticket.put(BulgariaAmexReportFields.ACCOUNT_NUMBER_OF_CLIENT, customer.getCode());
        }
        if (product.getTravellers() != null && product.getTravellers().size() != 0) {
            String[] travellerNameSplit;
            String travellerName = ((Traveller)product.getTravellers().get(0)).getName();
            if (!TextUtil.isBlank((String)travellerName) && (travellerNameSplit = travellerName.split(" ")).length == 2) {
                travellerName = travellerNameSplit[0] + "/" + travellerNameSplit[1];
            }
            ticket.put(BulgariaAmexReportFields.PASSENGER_NAME, travellerName);
        }
        ticket.put(BulgariaAmexReportFields.PNR, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        ticket.put(BulgariaAmexReportFields.PNR_CREATION_DATE, product.getReservation().getResDate());
        List payments = product.getReservation().getBookingFile().getPayments();
        if (payments != null) {
            block0: for (Payment payment : payments) {
                if (payment.getFinanceDocuments() == null) continue;
                for (FinanceDocument doc : payment.getFinanceDocuments()) {
                    int itemNumber = 0;
                    if (doc.getBillingItems() == null) continue;
                    for (BillingItem item : doc.getBillingItems()) {
                        ++itemNumber;
                        if (item.getProductUids() == null || !item.getProductUids().contains(product.getUid())) continue;
                        ticket.put(BulgariaAmexReportFields.ITEM_NUMBER, String.valueOf(itemNumber));
                        ticket.put(BulgariaAmexReportFields.INVOICE_DATE, doc.getDate());
                        ticket.put(BulgariaAmexReportFields.INVOICE_NUMBER, doc.getNumber());
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public BulgariaAmexReportProductPrepareHandler.ProductsListProxy<HotelProduct> getProducts(BulgariaAmexReportParameters params, List<Message> messages) throws Exception {
        BulgariaAmexReportProductPrepareHandler.ProductsListProxy<HotelProduct> result = new BulgariaAmexReportProductPrepareHandler.ProductsListProxy<HotelProduct>();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)MainHotelProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)MainHotelProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)MainHotelProductIndex.Property.ticketType.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)MainHotelProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)MainHotelProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)MainHotelProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)MainHotelProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)MainHotelProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)MainHotelProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)MainHotelProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)MainHotelProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        EntityReference agencyReference = params.getAgency();
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MainHotelProductIndex.Property.subagency.name(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (!params.getClients().isEmpty()) {
            HashSet<SearchCriterion> clientsCriterions = new HashSet<SearchCriterion>();
            for (Object ref : params.getClients()) {
                clientsCriterions.add(SearchCriterion.eq((String)MainHotelProductIndex.Property.client.name(), (Object)ref));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])clientsCriterions.toArray(new SearchCriterion[clientsCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (MainHotelProductIndex index : EntityStorage.get().search(MainHotelProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference> salesPoints = new HashSet<EntityReference>();
        HashSet vendors = new HashSet();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block4: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof HotelProduct) || !this.isIssuedInReportPeriod(params, (HotelProduct)prod) && !this.isPayedInReportPeriod(params, (HotelProduct)prod, true) && !this.isRefusedInReportPeriod(params, (HotelProduct)prod, true)) continue;
                        HotelProduct product = (HotelProduct)prod;
                        result.getProducts().add(product);
                        if (!this.isIssuedInReportPeriod(params, (HotelProduct)prod) || product.getSalesPoint() == null) continue block4;
                        salesPoints.add(product.getSalesPoint());
                        continue block4;
                    }
                }
            }
        }
        result.getActualVendors().addAll(vendors);
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    public boolean isRefusedInReportPeriod(BulgariaAmexReportParameters params, HotelProduct prod, boolean checkAgent) {
        for (HotelProductFop fop : HotelProductHelper.getClientFops((HotelProduct)prod)) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate())) continue;
            return true;
        }
        return false;
    }

    private boolean isPayedInReportPeriod(BulgariaAmexReportParameters params, HotelProduct prod, boolean checkAgent) {
        for (HotelProductFop fop : HotelProductHelper.getClientFops((HotelProduct)prod)) {
            if (params.getPeriodBegin() != null && (fop.getOperationDate() == null || fop.getOperationDate().before(params.getPeriodBegin())) || params.getPeriodEnd() != null && (fop.getOperationDate() == null || fop.getOperationDate().after(params.getPeriodEnd()))) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuedInReportPeriod(BulgariaAmexReportParameters params, HotelProduct prod) {
        if (params.getPeriodBegin() != null && (prod.getIssueDate() == null || prod.getIssueDate().before(params.getPeriodBegin()))) {
            return false;
        }
        return params.getPeriodEnd() == null || prod.getIssueDate() != null && !prod.getIssueDate().after(params.getPeriodEnd());
    }

    @Override
    public void validateProducts(Collection<HotelProduct> products, List<Message> messages) throws Exception {
    }

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }
}

