/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.reports.prepare.amexreports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaAmexReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.amexreport.BulgariaAmexReportRenderHandler;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.reports.render.RenderHandlersRegistry;
import com.gridnine.xtrip.common.reports.render.ReportRenderHandler;
import com.gridnine.xtrip.server.bg.reports.prepare.amexreports.BulgariaAmexReportAirPrepareHandler;
import com.gridnine.xtrip.server.bg.reports.prepare.amexreports.BulgariaAmexReportPrepareHandler;
import com.gridnine.xtrip.server.bg.reports.prepare.amexreports.BulgariaAmexReportProductPrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.PrepareHandlersRegistry;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import com.gridnine.xtrip.server.reports.salesreports.render.agentreport.BaseAgentReportTest;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BulgariaAmexReportTest
extends BaseAgentReportTest {
    private static final String TICKET_ETICKET = "010";
    private final double fare1 = 100.0;

    @Before
    public void setUpBulgaria() throws Exception {
        this.issueDate = new SimpleDateFormat("yyyy-MM-dd").parse("2013-01-28");
        this.createProfiles();
    }

    public void setUp() throws Exception {
        Object registry;
        super.setUp();
        if (!Environment.isPublished(PrepareHandlersRegistry.class)) {
            PrepareHandlersRegistry prepareRegistry = new PrepareHandlersRegistry();
            prepareRegistry.register((ReportPrepareHandler)new BulgariaAmexReportPrepareHandler());
            Environment.publish((Object)prepareRegistry);
        }
        if (!Environment.isPublished(RenderHandlersRegistry.class)) {
            registry = new RenderHandlersRegistry();
            registry.register((ReportRenderHandler)new BulgariaAmexReportRenderHandler());
            Environment.publish((Object)registry);
        }
        if (!Environment.isPublished(BulgariaAmexReportProductPrepareHandlersRegistry.class)) {
            registry = new BulgariaAmexReportProductPrepareHandlersRegistry();
            ((BulgariaAmexReportProductPrepareHandlersRegistry)registry).register(new BulgariaAmexReportAirPrepareHandler());
            Environment.publish((Object)registry);
        }
    }

    @Test
    public void testGlobalData() throws Exception {
        String pr2 = this.createProduct(TICKET_ETICKET, 0, this.airlineCode1, this.suReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, this.airlineNumber1, null);
        BulgariaAmexReportPrepareHandler prepareHandler = new BulgariaAmexReportPrepareHandler();
        HashMap<String, Object> data = new HashMap<String, Object>();
        BulgariaAmexReportParameters params = this.createGlobalReportParams();
        data.put("key-report-params", params);
        prepareHandler.prepareData(data);
        this.checkForErrorMessages(data);
    }

    @Test
    public void testPutTickets() throws Exception {
        String pr2 = this.createProduct(TICKET_ETICKET, 0, this.airlineCode1, this.suReference, 100.0, ProductStatus.SELL, null, PaymentType.CASH, ProductCategory.AIR, null, true, this.airlineNumber1, null);
        BulgariaAmexReportPrepareHandler prepareHandler = new BulgariaAmexReportPrepareHandler();
        HashMap<String, Object> data = new HashMap<String, Object>();
        BulgariaAmexReportParameters params = this.createGlobalReportParams();
        data.put("key-report-params", params);
        prepareHandler.prepareData(data);
        BulgariaAmexReportRenderHandler renderHandler = new BulgariaAmexReportRenderHandler();
        EntityContainer docContainer = renderHandler.renderReport(data);
        this.checkForErrorMessages(data);
    }

    private void checkForErrorMessages(Map<String, Object> data) {
        for (Object obj : (List)data.get("key-messages")) {
            Message message = (Message)obj;
            if (message.getType() != MessageType.ERROR) continue;
            Assert.assertFalse((String)message.getMessage().getKey(), (boolean)true);
        }
    }

    private BulgariaAmexReportParameters createGlobalReportParams() {
        BulgariaAmexReportParameters params = new BulgariaAmexReportParameters();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.issueDate);
        cl.add(5, -1);
        params.setPeriodBegin(cl.getTime());
        cl.add(5, 2);
        params.setPeriodEnd(cl.getTime());
        params.setAgency(new EntityReference(this.agencyContainer));
        params.setTemplate(new EntityReference("bulgariaAmexReportTemplateContainer", TemplateDocument.class, null));
        return params;
    }

    protected URL getDictionariesSetupFile() {
        return ((Object)((Object)this)).getClass().getResource("agentReportTestDictionaries.xml");
    }
}

