/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.reports.prepare.prismreports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bg.reports.fields.BulgariaPrismReportFields;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaPrismReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.prismreport.BulgariaPrismReportTicket;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.bg.reports.prepare.prismreports.BulgariaPrismReportProductPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulgariaPrismReportAirPrepareHandler
implements BulgariaPrismReportProductPrepareHandler<Product> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public List<BulgariaPrismReportTicket> createTickets(Product product, Map<String, Object> data) {
        String[] travellerNameSplit;
        Product previousExchangeProduct;
        CurrencyInfo equivalentCurrencyInfo;
        Organization customer;
        Branch branchBuff;
        EntityContainer branchCont;
        LinkedList<BulgariaPrismReportTicket> result = new LinkedList<BulgariaPrismReportTicket>();
        int sequenceNumber = 1;
        int segTariffsSize = 0;
        if (product.getSegmentTariffs() != null) {
            segTariffsSize = product.getSegmentTariffs().size();
        }
        HashMap<BulgariaPrismReportFields, Object> ticket = new HashMap<BulgariaPrismReportFields, Object>();
        String iataNo = null;
        String branch = null;
        String invoice = null;
        String ticketNo = null;
        iataNo = product.getValidatorCode();
        List payments = product.getReservation().getBookingFile().getPayments();
        if (payments != null) {
            block2: for (Payment payment : payments) {
                if (payment.getFinanceDocuments() == null) continue;
                for (FinanceDocument doc : payment.getFinanceDocuments()) {
                    if (doc.getBillingItems() == null) continue;
                    for (BillingItem item : doc.getBillingItems()) {
                        if (item.getProductUids() == null || !item.getProductUids().contains(product.getUid())) continue;
                        invoice = doc.getNumber();
                        break block2;
                    }
                }
            }
        }
        if (product.getBranch() != null && (branchCont = EntityStorage.get().resolve(product.getBranch())) != null && (branchBuff = (Branch)branchCont.getEntity()) != null) {
            branch = branchBuff.getCode();
        }
        ticketNo = product.getSystemNumber();
        ticket.put(BulgariaPrismReportFields.IATA_NO, iataNo);
        ticket.put(BulgariaPrismReportFields.INVOICE, invoice);
        ticket.put(BulgariaPrismReportFields.BRANCH, branch);
        ticket.put(BulgariaPrismReportFields.TICKET_NO, ticketNo);
        ticket.put(BulgariaPrismReportFields.ISSUE_DATE, product.getIssueDate());
        if (product.getReservation().getBookingFile().getCustomerProfile() != null && (customer = (Organization)EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile()).getEntity()) != null) {
            ticket.put(BulgariaPrismReportFields.CUSTOMER, customer.getCode());
        }
        if ((equivalentCurrencyInfo = DictHelper.getCurrencyInfoByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null))) != null && equivalentCurrencyInfo.getCode() != null) {
            ticket.put(BulgariaPrismReportFields.CURRENCY_CODE, equivalentCurrencyInfo.getCode());
        }
        ProductStatus status = product.getStatus();
        Product originalSellProduct = null;
        if (!ProductStatus.EXCHANGE.equals((Object)status) && (previousExchangeProduct = product.getPreviousProduct()) != null) {
            originalSellProduct = previousExchangeProduct.getPreviousProduct();
        }
        if (product.getTraveller() != null && !TextUtil.isBlank((String)product.getTraveller().getName()) && (travellerNameSplit = product.getTraveller().getName().split(" ")).length == 2) {
            ticket.put(BulgariaPrismReportFields.FIRSTNAME, travellerNameSplit[0]);
            ticket.put(BulgariaPrismReportFields.LASTNAME, travellerNameSplit[1]);
        }
        String systemNumber = product.getSystemNumber();
        LinkedList<String> conjNums = new LinkedList<String>();
        for (int i = 0; i < product.getConjCount(); ++i) {
            try {
                String toAdd = FormattedNumberUtil.add((String)systemNumber, (long)(i + 1));
                conjNums.add(toAdd.substring(systemNumber.length() - 3, systemNumber.length()));
                continue;
            }
            catch (Exception e) {
                this.log.error("unable to parse ticket number " + systemNumber, (Throwable)e);
            }
        }
        String conjString = TextUtil.join((String)" ", conjNums);
        ticket.put(BulgariaPrismReportFields.CONJ_TICKET_NO, conjString);
        BigDecimal totalEquivFare = AirProductHelper.calculateTotalEquivalentFare((Product)product);
        if (originalSellProduct != null) {
            totalEquivFare = totalEquivFare.subtract(AirProductHelper.calculateTotalEquivalentFare((Product)originalSellProduct));
        }
        ticket.put(BulgariaPrismReportFields.TICKET_AMT, totalEquivFare);
        Money baseFareMoney = AirProductHelper.getBaseFare((Product)product);
        BigDecimal baseFare = null;
        if (baseFareMoney != null) {
            baseFare = baseFareMoney.getValue();
        }
        if (originalSellProduct != null) {
            Money origFareMoney = AirProductHelper.getBaseFare((Product)originalSellProduct);
            BigDecimal origFare = null;
            if (origFareMoney != null) {
                origFare = origFareMoney.getValue();
            }
            if (baseFare != null && origFare != null) {
                baseFare = baseFare.subtract(origFare);
            }
        }
        ticket.put(BulgariaPrismReportFields.BASE_FARE_AMT, baseFare);
        BigDecimal bspCommission = BigDecimal.ZERO;
        if (product.getBspCommissionValue() != null) {
            bspCommission = product.getBspCommissionValue().getValue();
        }
        ticket.put(BulgariaPrismReportFields.IATA_COMMISION_AMT, bspCommission);
        BigDecimal totalEquivTax = AirProductHelper.calculateTaxesEquivalentAmount((Product)product);
        ticket.put(BulgariaPrismReportFields.TAX_AMT, totalEquivTax);
        if (originalSellProduct != null && ProductStatus.EXCHANGE.equals((Object)product.getPreviousProduct().getStatus())) {
            ticket.put(BulgariaPrismReportFields.ORIG_TICKET_NO, originalSellProduct.getSystemNumber());
            ticket.put(BulgariaPrismReportFields.REFUND_EXCHANGE, "E");
        }
        if (ProductStatus.REFUND.equals((Object)status)) {
            ticket.put(BulgariaPrismReportFields.REFUND_EXCHANGE, "R");
        }
        if (ProductStatus.VOID.equals((Object)status)) {
            ticket.put(BulgariaPrismReportFields.REFUND_EXCHANGE, "V");
        }
        ticket.put(BulgariaPrismReportFields.TICKET_TYPE, product.isEticket() ? "E" : "M");
        ticket.put(BulgariaPrismReportFields.PNR_LOCATOR, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)product.getReservation()));
        if (product.getCarrier() != null) {
            ticket.put(BulgariaPrismReportFields.VAL_CARRIER, product.getCarrier().getCode());
        }
        ticket.put(BulgariaPrismReportFields.TOUR_CODE, product.getTourCode());
        result.add(new BulgariaPrismReportTicket(ticket));
        int numberOfSegTariffStrings = segTariffsSize != 0 ? segTariffsSize : 1;
        for (int tariffNum = 0; tariffNum < numberOfSegTariffStrings; ++tariffNum) {
            SegmentTariff segTariff = null;
            if (segTariffsSize != 0) {
                segTariff = (SegmentTariff)product.getSegmentTariffs().get(tariffNum);
            }
            if (segTariff == null) continue;
            int segSize = 0;
            if (((SegmentTariff)product.getSegmentTariffs().get(tariffNum)).getSegments() != null) {
                segSize = ((SegmentTariff)product.getSegmentTariffs().get(tariffNum)).getSegments().size();
            }
            int numberOfSegStrings = segSize != 0 ? segSize : 1;
            for (int segNum = 0; segNum < numberOfSegStrings; ++segNum) {
                ticket = new HashMap();
                Segment seg = null;
                if (segTariff != null && segSize != 0) {
                    seg = (Segment)segTariff.getSegments().get(segNum);
                }
                ticket.put(BulgariaPrismReportFields.IATA_NO, iataNo);
                ticket.put(BulgariaPrismReportFields.INVOICE, invoice);
                ticket.put(BulgariaPrismReportFields.BRANCH, branch);
                ticket.put(BulgariaPrismReportFields.TICKET_NO, ticketNo);
                ticket.put(BulgariaPrismReportFields.AIR_TRAIN, "A");
                if (seg != null) {
                    GeoLocation arrive;
                    GeoLocation depart;
                    ticket.put(BulgariaPrismReportFields.FLIGHT_NUMBER, seg.getFlightNo());
                    ticket.put(BulgariaPrismReportFields.FARE_BASIS, seg.getFareBasis());
                    ticket.put(BulgariaPrismReportFields.SERV_CLASS, seg.getClassOfService());
                    if (seg.getAirline() != null) {
                        ticket.put(BulgariaPrismReportFields.CARRIER_CODE, seg.getAirline().getCode());
                    }
                    ticket.put(BulgariaPrismReportFields.SEG_NUMBER, sequenceNumber++);
                    DictionaryCache dCache = (DictionaryCache)Environment.getPublished(DictionaryCache.class);
                    if (seg.getDepartureLocation() != null && (depart = (GeoLocation)dCache.resolveReference(seg.getDepartureLocation())) != null) {
                        ticket.put(BulgariaPrismReportFields.FROM_CITY, depart.getCodeVariants().get(CodeSystem.IATA.name()));
                    }
                    if (seg.getArriveLocation() != null && (arrive = (GeoLocation)dCache.resolveReference(seg.getArriveLocation())) != null) {
                        ticket.put(BulgariaPrismReportFields.TO_CITY, arrive.getCodeVariants().get(CodeSystem.IATA.name()));
                    }
                    ticket.put(BulgariaPrismReportFields.DEPART_DATE, seg.getStartDate());
                    ticket.put(BulgariaPrismReportFields.ARRIVE_DATE, seg.getEndDate());
                    ticket.put(BulgariaPrismReportFields.DEPART_TIME, seg.getStartDate());
                    ticket.put(BulgariaPrismReportFields.ARRIVE_TIME, seg.getEndDate());
                }
                result.add(new BulgariaPrismReportTicket(ticket));
            }
        }
        return result;
    }

    @Override
    public BulgariaPrismReportProductPrepareHandler.ProductsListProxy<Product> getProducts(BulgariaPrismReportParameters params, List<Message> messages) throws Exception {
        BulgariaPrismReportProductPrepareHandler.ProductsListProxy<Product> result = new BulgariaPrismReportProductPrepareHandler.ProductsListProxy<Product>();
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        EntityReference agencyReference = params.getAgency();
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (!params.getClients().isEmpty()) {
            HashSet<SearchCriterion> clientsCriterions = new HashSet<SearchCriterion>();
            for (Object ref : params.getClients()) {
                clientsCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.client.name(), (Object)ref));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])clientsCriterions.toArray(new SearchCriterion[clientsCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (ProductIndex index : EntityStorage.get().search(ProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference> salesPoints = new HashSet<EntityReference>();
        HashSet<EntityReference> vendors = new HashSet<EntityReference>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block4: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product) || !this.isIssuedInReportPeriod(params, (Product)prod) && !this.isPayedInReportPeriod(params, (Product)prod, true) && !this.isRefusedInReportPeriod(params, (Product)prod, true)) continue;
                        Product product = (Product)prod;
                        result.getProducts().add(product);
                        if (product.getBlankOwnerRef() != null) {
                            vendors.add(product.getBlankOwnerRef());
                        }
                        if (!this.isIssuedInReportPeriod(params, (Product)prod) || product.getSalesPoint() == null) continue block4;
                        salesPoints.add(product.getSalesPoint());
                        continue block4;
                    }
                }
            }
        }
        result.getActualVendors().addAll(vendors);
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    public boolean isRefusedInReportPeriod(BulgariaPrismReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate())) continue;
            return true;
        }
        return false;
    }

    private boolean isPayedInReportPeriod(BulgariaPrismReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (params.getPeriodBegin() != null && (fop.getOperationDate() == null || fop.getOperationDate().before(params.getPeriodBegin())) || params.getPeriodEnd() != null && (fop.getOperationDate() == null || fop.getOperationDate().after(params.getPeriodEnd()))) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuedInReportPeriod(BulgariaPrismReportParameters params, Product prod) {
        if (params.getPeriodBegin() != null && (prod.getIssueDate() == null || prod.getIssueDate().before(params.getPeriodBegin()))) {
            return false;
        }
        return params.getPeriodEnd() == null || prod.getIssueDate() != null && !prod.getIssueDate().after(params.getPeriodEnd());
    }

    @Override
    public void validateProducts(Collection<Product> products, List<Message> messages) throws Exception {
        for (Product prod : products) {
            BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)prod, messages);
        }
    }
}

