/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.reports.prepare.prismreports;

import com.gridnine.xtrip.common.bg.reports.fields.BulgariaPrismReportSummaryFields;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaPrismReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.prismreport.BulgariaPrismReportSummary;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.bg.reports.prepare.prismreports.BulgariaPrismReportSummaryPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulgariaPrismReportAirSummaryPrepareHandler
implements BulgariaPrismReportSummaryPrepareHandler<Product> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<BulgariaPrismReportSummary> createSums(List<Product> products, Map<String, Object> data) {
        LinkedList<BulgariaPrismReportSummary> result = new LinkedList<BulgariaPrismReportSummary>();
        HashMap<Organization, LinkedList<Product>> customerProducts = new HashMap<Organization, LinkedList<Product>>();
        for (Product product : products) {
            EntityReference keyRef = product.getReservation().getBookingFile().getCustomerProfile();
            if (keyRef == null) continue;
            Organization key = (Organization)EntityStorage.get().resolve(keyRef).getEntity();
            LinkedList<Product> customerList = (LinkedList<Product>)customerProducts.get(key);
            if (customerList == null) {
                customerList = new LinkedList<Product>();
                customerProducts.put(key, customerList);
            }
            customerList.add(product);
        }
        for (Map.Entry entry : customerProducts.entrySet()) {
            HashMap<BulgariaPrismReportSummaryFields, Object> sum = new HashMap<BulgariaPrismReportSummaryFields, Object>();
            sum.put(BulgariaPrismReportSummaryFields.COMPANY_NAME, ((Organization)entry.getKey()).getFullName());
            sum.put(BulgariaPrismReportSummaryFields.CUSTOMER, ((Organization)entry.getKey()).getCode());
            sum.put(BulgariaPrismReportSummaryFields.BEG_DATE, ((BulgariaPrismReportParameters)data.get("key-report-params")).getPeriodBegin());
            sum.put(BulgariaPrismReportSummaryFields.END_DATE, ((BulgariaPrismReportParameters)data.get("key-report-params")).getPeriodEnd());
            sum.put(BulgariaPrismReportSummaryFields.TOTAL_AIR_AMT, this.getTotalAirAmount((List)entry.getValue()));
            sum.put(BulgariaPrismReportSummaryFields.TOTAL_AIR_REF_AMT, this.getTotalAirRefAmount((List)entry.getValue()));
            sum.put(BulgariaPrismReportSummaryFields.NET_TOTAL_AMOUNT, this.getNetTotalAmount((List)entry.getValue()));
            CurrencyInfo equivalentCurrencyInfo = DictHelper.getCurrencyInfoByAnyCode((String)DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, null));
            sum.put(BulgariaPrismReportSummaryFields.CURRENCY_CODE, equivalentCurrencyInfo.getCode());
            result.add(new BulgariaPrismReportSummary(sum));
        }
        return result;
    }

    private BigDecimal getTotalAirAmount(List<Product> value) {
        BigDecimal res = BigDecimal.ZERO;
        for (Product prod : value) {
            if (prod.getStatus() == ProductStatus.REFUND) continue;
            res = res.add(AirProductHelper.getTotalEquivalentFare((Product)prod));
        }
        return res;
    }

    private BigDecimal getTotalAirRefAmount(List<Product> value) {
        BigDecimal res = BigDecimal.ZERO;
        for (Product prod : value) {
            if (prod.getStatus() != ProductStatus.REFUND) continue;
            res = res.add(AirProductHelper.getTotalEquivalentFare((Product)prod));
        }
        return res;
    }

    private BigDecimal getNetTotalAmount(List<Product> value) {
        BigDecimal res = BigDecimal.ZERO;
        for (Product prod : value) {
            if (prod.getStatus() == ProductStatus.REFUND) continue;
            res = res.add(AirProductHelper.getEquivalentFare((Product)prod));
        }
        return res;
    }

    @Override
    public Class<Product> getProductClass() {
        return Product.class;
    }

    @Override
    public BulgariaPrismReportSummaryPrepareHandler.ProductsListProxy<Product> getProducts(BulgariaPrismReportParameters params, List<Message> messages) throws Exception {
        BulgariaPrismReportSummaryPrepareHandler.ProductsListProxy<Product> result = new BulgariaPrismReportSummaryPrepareHandler.ProductsListProxy<Product>();
        Object agentReference = null;
        EntityStorage es = EntityStorage.get();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), (Object)TicketType.NOT_OWN), SearchCriterion.eq((String)ProductIndex.Property.ticketType.name(), null)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.issueDate.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.dateOfClientPayment.name(), (Object)params.getPeriodEnd())}), SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ne((String)ProductIndex.Property.cancellationDate.name(), null), SearchCriterion.ge((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodBegin()), SearchCriterion.le((String)ProductIndex.Property.cancellationDate.name(), (Object)params.getPeriodEnd())})}));
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.BOOKING));
        query.getCriteria().getCriterions().add(SearchQueryHelper.buildAndNeEnumCriterion((String)ProductIndex.Property.status.name(), (Collection)ProductStatusHandler.getAllNonIssuedVoidStatuses()));
        EntityReference agencyReference = params.getAgency();
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ProductIndex.Property.subagency.name(), (Object)agencyReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)ProductIndex.Property.status.name(), (Object)ProductStatus.EXCHANGE));
        query.getCriteria().getCriterions().addAll(params.getAdditionalCriterions());
        if (!params.getClients().isEmpty()) {
            HashSet<SearchCriterion> clientsCriterions = new HashSet<SearchCriterion>();
            for (Object ref : params.getClients()) {
                clientsCriterions.add(SearchCriterion.eq((String)ProductIndex.Property.client.name(), (Object)ref));
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])clientsCriterions.toArray(new SearchCriterion[clientsCriterions.size()])));
        }
        HashSet<String> productIndexList = new HashSet<String>();
        HashSet<EntityReference> bfrefs = new HashSet<EntityReference>();
        for (ProductIndex index : EntityStorage.get().search(ProductIndex.class, query).getData()) {
            productIndexList.add(index.getNavigationKey());
            bfrefs.add(index.getSource());
        }
        HashSet<EntityReference> salesPoints = new HashSet<EntityReference>();
        HashSet<EntityReference> vendors = new HashSet<EntityReference>();
        for (EntityReference bfref : bfrefs) {
            EntityContainer container = es.resolve(bfref);
            if (container == null) {
                SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_FailedLoadingEntity", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{bfref});
                this.log.debug("Unable to load booking file container " + bfref.getUid() + ". All products of the booking will be excluded from report.");
                return result;
            }
            BookingFile bookingFile = (BookingFile)container.getEntity();
            for (Reservation res : bookingFile.getReservations()) {
                block4: for (BaseProduct prod : res.getProducts()) {
                    String uid = prod.getUid();
                    for (String productUid : productIndexList) {
                        if (!productUid.equals(uid) || !(prod instanceof Product) || !this.isIssuedInReportPeriod(params, (Product)prod) && !this.isPayedInReportPeriod(params, (Product)prod, true) && !this.isRefusedInReportPeriod(params, (Product)prod, true)) continue;
                        Product product = (Product)prod;
                        result.getProducts().add(product);
                        if (product.getBlankOwnerRef() != null) {
                            vendors.add(product.getBlankOwnerRef());
                        }
                        if (!this.isIssuedInReportPeriod(params, (Product)prod) || product.getSalesPoint() == null) continue block4;
                        salesPoints.add(product.getSalesPoint());
                        continue block4;
                    }
                }
            }
        }
        result.getActualVendors().addAll(vendors);
        result.getActualSalesPoints().addAll(salesPoints);
        return result;
    }

    public boolean isRefusedInReportPeriod(BulgariaPrismReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (!fop.isRefused() || fop.getOperationDate() == null || !MiscUtil.isBetween((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), (Date)fop.getOperationDate())) continue;
            return true;
        }
        return false;
    }

    private boolean isPayedInReportPeriod(BulgariaPrismReportParameters params, Product prod, boolean checkAgent) {
        for (ProductFop fop : AirProductHelper.getClientContractRelation((Product)prod).getFops()) {
            if (params.getPeriodBegin() != null && (fop.getOperationDate() == null || fop.getOperationDate().before(params.getPeriodBegin())) || params.getPeriodEnd() != null && (fop.getOperationDate() == null || fop.getOperationDate().after(params.getPeriodEnd()))) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuedInReportPeriod(BulgariaPrismReportParameters params, Product prod) {
        if (params.getPeriodBegin() != null && (prod.getIssueDate() == null || prod.getIssueDate().before(params.getPeriodBegin()))) {
            return false;
        }
        return params.getPeriodEnd() == null || prod.getIssueDate() != null && !prod.getIssueDate().after(params.getPeriodEnd());
    }

    @Override
    public void validateProducts(Collection<Product> products, List<Message> messages) throws Exception {
        for (Product prod : products) {
            BaseReportPrepareHandler.baseValidateProductToReport((BaseProduct)prod, messages);
        }
    }
}

