/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.reports.prepare.prismreports;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bg.reports.model.BulgariaPrismReportParameters;
import com.gridnine.xtrip.common.bg.reports.render.prismreport.BulgariaPrismReportSummary;
import com.gridnine.xtrip.common.bg.reports.render.prismreport.BulgariaPrismReportTicket;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.AgentReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.bg.reports.prepare.prismreports.BulgariaPrismReportProductPrepareHandler;
import com.gridnine.xtrip.server.bg.reports.prepare.prismreports.BulgariaPrismReportProductPrepareHandlersRegistry;
import com.gridnine.xtrip.server.bg.reports.prepare.prismreports.BulgariaPrismReportSummaryPrepareHandlersRegistry;
import com.gridnine.xtrip.server.model.helpers.ProfileDao;
import com.gridnine.xtrip.server.reports.prepare.BaseReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.ReportPrepareHandler;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulgariaPrismReportPrepareHandler
implements ReportPrepareHandler {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public String getId() {
        return "bulgaria-prism-report";
    }

    public void prepareData(Map<String, Object> data) throws Exception {
        Object handler;
        LinkedList<Message> messages = new LinkedList<Message>();
        data.put("key-messages", messages);
        BulgariaPrismReportParameters params = (BulgariaPrismReportParameters)data.get("key-report-params");
        if (params == null) {
            SystemHelper.addMessage(messages, (String)"BaseSalesReportPrepareHandler_Messages_NoReportParameters", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            this.log.error("Sales report parameters are absent");
            return;
        }
        this.putGlobalData(data, messages);
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        LinkedHashMap<Class<BaseProduct>, List<BaseProduct>> productMap = new LinkedHashMap<Class<BaseProduct>, List<BaseProduct>>();
        HashSet<EntityReference<Organization>> actualBlankOwners = new HashSet<EntityReference<Organization>>();
        HashSet<EntityReference<SalesPoint>> actualSalesPoints = new HashSet<EntityReference<SalesPoint>>();
        for (BulgariaPrismReportProductPrepareHandler<BaseProduct> bulgariaPrismReportProductPrepareHandler : ((BulgariaPrismReportProductPrepareHandlersRegistry)Environment.getPublished(BulgariaPrismReportProductPrepareHandlersRegistry.class)).getAllHandlers()) {
            BulgariaPrismReportProductPrepareHandler.ProductsListProxy<BaseProduct> result = bulgariaPrismReportProductPrepareHandler.getProducts(params, messages);
            actualBlankOwners.addAll(result.getActualVendors());
            actualSalesPoints.addAll(result.getActualSalesPoints());
            if (result.getProducts().isEmpty()) continue;
            productMap.put(bulgariaPrismReportProductPrepareHandler.getProductClass(), result.getProducts());
        }
        if (productMap.isEmpty()) {
            SystemHelper.addMessage(messages, (String)"\u0432 \u043e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u043e\u043f\u0430\u043b\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0431\u0438\u043b\u0435\u0442\u0430", null, (MessageType)MessageType.ERROR, (Object[])new Object[0]);
            return;
        }
        data.put("ACTUAL_VENDORS", actualBlankOwners);
        data.put("KEY_ACTUAL_SALES_POINTS", this.generateNames(actualSalesPoints));
        for (Map.Entry entry : productMap.entrySet()) {
            ((BulgariaPrismReportProductPrepareHandlersRegistry)Environment.getPublished(BulgariaPrismReportProductPrepareHandlersRegistry.class)).findHandler((Class)entry.getKey()).validateProducts((Collection)entry.getValue(), messages);
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
        for (Map.Entry entry : productMap.entrySet()) {
            handler = ((BulgariaPrismReportProductPrepareHandlersRegistry)Environment.getPublished(BulgariaPrismReportProductPrepareHandlersRegistry.class)).findHandler((Class)entry.getKey());
            for (BaseProduct bp : (List)entry.getValue()) {
                List<BulgariaPrismReportTicket> tickets = handler.createTickets(bp, data);
                for (BulgariaPrismReportTicket ticket : tickets) {
                    String batchId = "ALL";
                    this.addTicket(data, ticket, batchId);
                }
            }
        }
        for (Map.Entry entry : productMap.entrySet()) {
            handler = ((BulgariaPrismReportSummaryPrepareHandlersRegistry)Environment.getPublished(BulgariaPrismReportSummaryPrepareHandlersRegistry.class)).findHandler((Class)entry.getKey());
            List<BulgariaPrismReportSummary> sums = handler.createSums((List)entry.getValue(), data);
            for (BulgariaPrismReportSummary sum : sums) {
                this.addSummary(data, sum);
            }
        }
        if (ReportHelper.isHasErrors(messages)) {
            return;
        }
    }

    private String generateNames(Set<EntityReference<SalesPoint>> actualSalesPoints) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (EntityReference<SalesPoint> spRef : actualSalesPoints) {
            EntityContainer spCtr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(spRef);
            if (spCtr == null) {
                this.log.error("unable to load container " + spRef);
                continue;
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(ProfileHelper.getFullName((SalesPoint)((SalesPoint)spCtr.getEntity())));
        }
        return sb.toString();
    }

    private FinanceDocument getFinanceDocument(Product prod) {
        for (Payment payment : prod.getReservation().getBookingFile().getPayments()) {
            for (FinanceDocument doc : payment.getFinanceDocuments()) {
                for (BillingItem item : doc.getBillingItems()) {
                    if (!item.getProductUids().contains(prod.getUid())) continue;
                    return doc;
                }
            }
        }
        return null;
    }

    private void addTicket(Map<String, Object> data, BulgariaPrismReportTicket ticket, String batchId) {
        LinkedList<ReportBatchData> batchDataList = (LinkedList<ReportBatchData>)data.get("key-batch-data-list");
        if (batchDataList == null) {
            batchDataList = new LinkedList<ReportBatchData>();
            ReportBatchData allList = new ReportBatchData();
            allList.setBatchId("ALL");
            batchDataList.add(allList);
            data.put("key-batch-data-list", batchDataList);
        }
        for (ReportBatchData batchData : batchDataList) {
            if (!batchData.getBatchId().equals(batchId)) continue;
            batchData.getTickets().add(ticket);
            return;
        }
    }

    private void addSummary(Map<String, Object> data, BulgariaPrismReportSummary summ) {
        LinkedList<BulgariaPrismReportSummary> summList = (LinkedList<BulgariaPrismReportSummary>)data.get("KEY_SUMMARY_DATA");
        if (summList == null) {
            summList = new LinkedList<BulgariaPrismReportSummary>();
            data.put("KEY_SUMMARY_DATA", summList);
        }
        summList.add(summ);
    }

    private void putGlobalData(Map<String, Object> data, List<Message> messages) throws Exception {
        BulgariaPrismReportParameters params = (BulgariaPrismReportParameters)data.get("key-report-params");
        BaseReportPrepareHandler.putStandardReportParameters((Date)params.getPeriodBegin(), (Date)params.getPeriodEnd(), data, messages);
        EntityStorage es = EntityStorage.get();
        EntityContainer ctr = ((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(params.getAgency());
        if (ctr == null) {
            SystemHelper.addMessage(messages, (String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430 \"{0}\"", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{params.getAgency()});
            return;
        }
        data.put("AGENCY_NAME", ProfileHelper.getFullName((Organization)((Organization)ctr.getEntity()), (Locale)LocaleHelper.getCurrentLocale(), (boolean)false));
        SearchQuery query = new SearchQuery();
        query.setResultMode(ResultMode.COUNT_ONLY);
        data.put("REPORT_NUMBER", new DecimalFormat("0000000").format(es.search(AgentReportDocumentIndex.class, query).getTotalCount() + 1));
        String code = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.RETAIL_PROFILE_CODE, null);
        if (code != null) {
            List refs = ProfileDao.getProfileReferenceByCode((String)code, OrganizationIndex.class);
            if (!refs.isEmpty()) {
                EntityReference client = (EntityReference)refs.get(0);
                if (refs.size() > 1) {
                    SystemHelper.addMessage(messages, (String)"\u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0444\u0438\u043b\u0435\u0439 \u0441 \u043a\u043e\u0434\u043e\u043c %s, \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d %s", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{code, client});
                }
                data.put("RETAIL_TRAVELLER_UID", client.getUid());
            } else {
                SystemHelper.addMessage(messages, (String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043d\u0430\u0439\u0442\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043a\u043e\u0434 \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0440\u043e\u0437\u043d\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c %s", null, (MessageType)MessageType.WARNING, (Object[])new Object[]{code});
            }
        } else {
            SystemHelper.addMessage(messages, (String)"\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043d\u0430\u0439\u0442\u0438 \u043a\u043e\u0434 \u043f\u0440\u043e\u0444\u0438\u043b\u044f \u0440\u043e\u0437\u043d\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0430", null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
        }
    }
}

