/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bg.reports.prepare.template.finance;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentIndex;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.BaseGeneralFinanceDocumentsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BulgariaFinanceDocumentsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.BulgariaFinanceDocumentsTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.BulgariaFinanceDocumentsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BulgariaFinanceDocumentsTemplateReportTicket;
import com.gridnine.xtrip.common.reports.model.FinanceDocumentsTemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.GeneralFinanceDocumentsTemplateReportFilteringParameters;
import com.gridnine.xtrip.common.reports.model.GeneralFinanceDocumentsTemplateReportPageDescription;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.reports.prepare.template.common.BaseFinanceDocumentsTemplateReportPrepareHandler;
import com.gridnine.xtrip.server.reports.prepare.template.common.TemplateReportHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulgariaFinanceDocumentsTemplateReportPrepareHandler
extends BaseFinanceDocumentsTemplateReportPrepareHandler<BulgariaFinanceDocumentsTemplateReportTicket, BulgariaFinanceDocumentsTemplateReportParameters, BulgariaFinanceDocumentsTemplateReportDescription, GeneralFinanceDocumentsTemplateReportPageDescription, BulgariaFinanceDocumentsTemplateReportDocument> {
    private static final Logger log = LoggerFactory.getLogger(BulgariaFinanceDocumentsTemplateReportPrepareHandler.class);

    public String getId() {
        return "bulgaria-finance-documents-report";
    }

    protected void setData(BulgariaFinanceDocumentsTemplateReportDocument document, BulgariaFinanceDocumentsTemplateReportParameters parameters, Map<String, Object> data) {
        document.setParameters(parameters);
    }

    protected BulgariaFinanceDocumentsTemplateReportDocument createDocument() {
        return new BulgariaFinanceDocumentsTemplateReportDocument();
    }

    protected Class<BulgariaFinanceDocumentsTemplateReportTicket> getItemClass(BulgariaFinanceDocumentsTemplateReportDescription description) {
        return BulgariaFinanceDocumentsTemplateReportTicket.class;
    }

    protected List<GeneralFinanceDocumentsTemplateReportPageDescription> getPages(BulgariaFinanceDocumentsTemplateReportDescription entity) {
        return entity.getPages();
    }

    protected Map<String, Object> getGlobalParameters(Map<String, Object> data, BulgariaFinanceDocumentsTemplateReportParameters params, List<Message> messages) {
        Map globalParamaters = TemplateReportHelper.getGlobalParameters((BaseTemplateReportParameters)params, messages);
        globalParamaters.put(GeneralFinanceDocumentsTemplateReportFilteringParameters.AGENCY.name(), MiscUtil.toString((Object)params.getAgency()));
        globalParamaters.put(GeneralFinanceDocumentsTemplateReportFilteringParameters.CLIENT.name(), MiscUtil.toString((Object)params.getClient()));
        return globalParamaters;
    }

    protected List<BulgariaFinanceDocumentsTemplateReportTicket> createRecords(FinanceDocument document, Map<String, Object> data, List<Message> messages) throws Exception {
        Payment payment;
        String number = TextUtil.buildFullNumber((CompositeNumber)document);
        if (TextUtil.isBlank((String)number)) {
            number = document.getUid();
        }
        if ((payment = document.getPayment()) == null) {
            SystemHelper.addMessage(messages, (String)"BulgariaFinanceDocumentsTemplateReportPrepareHandler_paymentNotFound", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{number});
            log.error(String.format("finance document %s: payment not found", number));
            return Collections.emptyList();
        }
        BookingFile bookingFile = payment.getBookingFile();
        EntityContainer clientContainer = EntityStorage.get().resolve(bookingFile.getCustomerProfile());
        if (clientContainer == null) {
            SystemHelper.addMessage(messages, (String)"BulgariaFinanceDocumentsTemplateReportPrepareHandler_clientNotFound", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{number});
            log.error(String.format("finance document %s: client not found", number));
            return Collections.emptyList();
        }
        EntityContainer agencyContainer = FinanceDocumentsHelper.getAgency((BookingFile)bookingFile, (Payment)payment);
        if (agencyContainer == null) {
            SystemHelper.addMessage(messages, (String)"BulgariaFinanceDocumentsTemplateReportPrepareHandler_agencyOrSubagencyNotFound", null, (MessageType)MessageType.ERROR, (Object[])new Object[]{number});
            log.error(String.format("finance document %s: agency/subagency not found", number));
            return Collections.emptyList();
        }
        EntityContainer agentContainer = EntityStorage.get().resolve(payment.getAgent());
        Organization client = (Organization)clientContainer.getEntity();
        Person agent = agentContainer != null ? (Person)agentContainer.getEntity() : null;
        BulgariaFinanceDocumentsTemplateReportTicket item = new BulgariaFinanceDocumentsTemplateReportTicket();
        item.setNumber(TextUtil.buildFullNumber((CompositeNumber)document));
        item.setIssueDate(document.getDate());
        item.setPaymentDate(document.getDate());
        item.setType(document.getType());
        item.setCanceled(payment.isCanceled());
        L10nStringHelper.copy((L10nString)client.getShortName(), (L10nString)item.getClientShortName());
        L10nStringHelper.copy((L10nString)client.getFullName(), (L10nString)item.getClientFullName());
        item.setFop(payment.getFop());
        item.setPaid(document.isPaid());
        item.setRemarks(document.getRemarks());
        item.setBankAccount(payment.getBankAccount());
        if (agent != null) {
            item.setIssueAgentCode(agent.getCode());
            L10nStringHelper.copy((L10nString)agent.getFirstName(), (L10nString)item.getIssueAgentFirstName());
            L10nStringHelper.copy((L10nString)agent.getLastName(), (L10nString)item.getIssueAgentLastName());
            L10nStringHelper.copy((L10nString)agent.getMiddleName(), (L10nString)item.getIssueAgentMiddleName());
            item.setIssueCity(this.getIssueCity((EntityReference<Person>)agentContainer.toReference(), document.getDate()));
        }
        item.setNetAmount(this.calculateNetAmount(document));
        item.setDiscountAmount(this.calculateDiscountAmount(document));
        item.setVatAmount(this.calculateVatAmount(document));
        item.setAmount(this.calculateAmount(document));
        return Collections.singletonList(item);
    }

    private DictionaryReference<GeoLocation> getIssueCity(EntityReference<Person> agent, Date date) throws Exception {
        for (EntityReference salesPointReference : ProfileHelper.getPersonSalesPoints(Collections.singletonList(agent), (Date)date)) {
            Address address;
            EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
            if (salesPointContainer == null || (address = this.getAddress(((SalesPoint)salesPointContainer.getEntity()).getAddresses(), AddressType.FACTUAL)) == null || address.getCity() == null) continue;
            return address.getCity();
        }
        return null;
    }

    private Address getAddress(List<Address> addresses, AddressType addressType) {
        for (Address address : addresses) {
            if (address.getAddressType() != addressType) continue;
            return address;
        }
        return null;
    }

    private BigDecimal calculateNetAmount(FinanceDocument document) {
        BigDecimal totalNetAmount = null;
        for (BillingItem billingItem : document.getBillingItems()) {
            if (billingItem.getAmount() != null && billingItem.getAmount().getValue() != null) {
                BigDecimal bigDecimal = totalNetAmount = totalNetAmount != null ? totalNetAmount.add(billingItem.getAmount().getValue()) : billingItem.getAmount().getValue();
            }
            if (billingItem.getDiscount() == null) continue;
            totalNetAmount = totalNetAmount != null ? totalNetAmount.subtract(billingItem.getDiscount()) : billingItem.getDiscount().negate();
        }
        return totalNetAmount;
    }

    private BigDecimal calculateDiscountAmount(FinanceDocument document) {
        BigDecimal totalDiscountAmount = null;
        for (BillingItem billingItem : document.getBillingItems()) {
            if (billingItem.getDiscount() == null) continue;
            totalDiscountAmount = totalDiscountAmount != null ? totalDiscountAmount.add(billingItem.getDiscount()) : billingItem.getDiscount();
        }
        return totalDiscountAmount;
    }

    private BigDecimal calculateVatAmount(FinanceDocument document) {
        BigDecimal totalVatAmount = null;
        for (BillingItem billingItem : document.getBillingItems()) {
            if (billingItem.getAmount() == null || billingItem.getAmount().getVatAmount() == null) continue;
            totalVatAmount = totalVatAmount != null ? totalVatAmount.add(billingItem.getAmount().getVatAmount()) : billingItem.getAmount().getVatAmount();
        }
        return totalVatAmount;
    }

    private BigDecimal calculateAmount(FinanceDocument document) {
        BigDecimal totalAmount = null;
        for (BillingItem billingItem : document.getBillingItems()) {
            if (billingItem.getAmount() != null && billingItem.getAmount().getTotal() != null) {
                BigDecimal bigDecimal = totalAmount = totalAmount != null ? totalAmount.add(billingItem.getAmount().getTotal()) : billingItem.getAmount().getTotal();
            }
            if (billingItem.getDiscount() == null) continue;
            totalAmount = totalAmount != null ? totalAmount.subtract(billingItem.getDiscount()) : billingItem.getDiscount().negate();
        }
        return totalAmount;
    }

    protected FinanceDocument getItem(EntityContainer<BookingFile> ctr, String key) {
        return ((BookingFile)ctr.getEntity()).getPayments().stream().map(Payment::getFinanceDocuments).flatMap(Collection::stream).filter(doc -> key.equals(doc.getUid())).findAny().orElseThrow(() -> Xeption.forDeveloper((String)"can't find finance document with uid {0} in booking file {1}", (Object[])new Object[]{key, ctr.getUid()}));
    }

    protected Map<EntityReference<BookingFile>, Set<String>> getGroupedIndexes(BulgariaFinanceDocumentsTemplateReportParameters parameters, Map<String, Object> data, List<Message> messages, EntityContainer<BulgariaFinanceDocumentsTemplateReportDescription> descriptionCtr) {
        EntityStorage entityStorage = EntityStorage.get();
        Date periodBegin = parameters.getPeriodBegin();
        Date periodEnd = parameters.getPeriodEnd();
        EntityReference agencyReference = parameters.getAgency();
        EntityReference clientReference = parameters.getClient();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.ne((String)FinanceDocumentIndex.Property.financeDocumentDate.name(), null));
        if (periodBegin != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.ge((String)FinanceDocumentIndex.Property.financeDocumentDate.name(), (Object)periodBegin));
        }
        if (periodEnd != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.le((String)FinanceDocumentIndex.Property.financeDocumentDate.name(), (Object)periodEnd));
        }
        if (agencyReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentIndex.Property.agency.name(), (Object)agencyReference));
        }
        if (clientReference != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentIndex.Property.client.name(), (Object)clientReference));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)FinanceDocumentIndex.Property.financeDocumentType.name(), (Object)FinanceDocumentType.BULGARIA_PROTOCOL), SearchCriterion.eq((String)FinanceDocumentIndex.Property.financeDocumentType.name(), (Object)FinanceDocumentType.BULGARIA_PROTOCOL_CREDIT_NOTE), SearchCriterion.eq((String)FinanceDocumentIndex.Property.financeDocumentType.name(), (Object)FinanceDocumentType.BULGARIA_INVOICE), SearchCriterion.eq((String)FinanceDocumentIndex.Property.financeDocumentType.name(), (Object)FinanceDocumentType.BULGARIA_INVOICE_CREDIT_NOTE)}));
        query.getPreferredProperties().add("uid");
        return EntityStorage.get().search(FinanceDocumentIndex.class, query).getData().stream().collect(Collectors.groupingBy(FinanceDocumentIndex::getSource, Collectors.mapping(FinanceDocumentIndex::getNavigationKey, Collectors.toSet())));
    }

    protected EntityReference<BulgariaFinanceDocumentsTemplateReportDescription> getDescription(BulgariaFinanceDocumentsTemplateReportParameters params) {
        return params.getDescription();
    }

    public MiscUtil.Pair<EntityIndex<BaseTemplateReportDocument>, String> searchForDuplicate(BulgariaFinanceDocumentsTemplateReportParameters parametersNewReport, EntityReference<BulgariaFinanceDocumentsTemplateReportDescription> reportDescription, boolean periodIntersectionDisallowed) {
        MiscUtil.Pair res = new MiscUtil.Pair(null, null);
        SearchQuery query = new SearchQuery();
        BulgariaFinanceDocumentsTemplateReportPrepareHandler.addPeriodCriterions((SearchQuery)query, (String)FinanceDocumentsTemplateReportDocumentIndex.Property.periodBegin.name(), (String)FinanceDocumentsTemplateReportDocumentIndex.Property.periodEnd.name(), (Date)parametersNewReport.getPeriodBegin(), (Date)parametersNewReport.getPeriodEnd(), (boolean)periodIntersectionDisallowed);
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentsTemplateReportDocumentIndex.Property.description.name(), reportDescription));
        if (parametersNewReport.getAgency() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentsTemplateReportDocumentIndex.Property.agency.name(), (Object)parametersNewReport.getAgency()));
        }
        if (parametersNewReport.getClient() != null) {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FinanceDocumentsTemplateReportDocumentIndex.Property.client.name(), (Object)parametersNewReport.getClient()));
        }
        List docsInd = EntityStorage.get().search(FinanceDocumentsTemplateReportDocumentIndex.class, query).getData();
        for (FinanceDocumentsTemplateReportDocumentIndex ind : docsInd) {
            EntityContainer repCont = EntityStorage.get().resolve(ind.getSource());
            if (repCont == null || repCont.getEntity() == null) continue;
            BaseTemplateReportDocument repDoc = (BaseTemplateReportDocument)repCont.getEntity();
            BaseTemplateReportParameters parametersFoundReport = null;
            Method getParametersMethod = null;
            try {
                getParametersMethod = repDoc.getClass().getMethod("getParameters", new Class[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (getParametersMethod != null) {
                try {
                    parametersFoundReport = (BaseTemplateReportParameters)getParametersMethod.invoke((Object)repDoc, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            boolean hasEqualParams = false;
            if (parametersFoundReport == null || !(parametersFoundReport instanceof BaseGeneralFinanceDocumentsTemplateReportParameters) || !(hasEqualParams = BulgariaFinanceDocumentsTemplateReportPrepareHandler.compareFinanceDocumentsParams((BaseGeneralFinanceDocumentsTemplateReportParameters)parametersFoundReport, (BaseGeneralFinanceDocumentsTemplateReportParameters)parametersNewReport))) continue;
            res.setFirst((Object)ind);
            res.setSecond((Object)ind.getTitle());
            return res;
        }
        return res;
    }

    private static boolean compareFinanceDocumentsParams(BaseGeneralFinanceDocumentsTemplateReportParameters p1, BaseGeneralFinanceDocumentsTemplateReportParameters p2) {
        boolean equalAgency = p1.getAgency() == null && p2.getAgency() == null || p1.getAgency() != null && p1.getAgency().equals((Object)p2.getAgency());
        boolean equalClient = p1.getClient() == null && p2.getClient() == null || p1.getClient() != null && p1.getClient().equals((Object)p2.getClient());
        boolean equalAdditionalCriterions = BulgariaFinanceDocumentsTemplateReportPrepareHandler.compareAdditionalCriterions((Set)p1.getAdditionalCriterions(), (Set)p2.getAdditionalCriterions());
        boolean equalRequestedParam = BulgariaFinanceDocumentsTemplateReportPrepareHandler.compareRequestedParams((List)p1.getRequestedParameters(), (List)p2.getRequestedParameters());
        return equalAgency && equalClient && equalAdditionalCriterions && equalRequestedParam;
    }
}

