/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.export;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.FopComponent;
import com.gridnine.xtrip.common.model.booking.FopDetalization;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.IBusBookingContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.booking.bus.BusTax;
import com.gridnine.xtrip.common.model.booking.export.v2.BookingXmlExportSettings;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BookingFileExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BusProductExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BusProductSegmentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.BusTaxExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopComponentExport;
import com.gridnine.xtrip.common.model.export.booking.v2.FopExport;
import com.gridnine.xtrip.common.model.export.booking.v2.ReferenceItemExport;
import com.gridnine.xtrip.common.model.export.booking.v2.TravellerExport;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.export.MetadataBasedExportHelper;
import com.gridnine.xtrip.server.model.export.standard.booking.BookingXmlExportHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingExportBusProductFillHeaderProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        BusProduct product = (BusProduct)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.PRODUCT);
        BookingFileExport root = (BookingFileExport)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORTED_OBJECT);
        BookingXmlExportSettings settings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.EXPORT_SETTINGS);
        BookingXmlExportSettings previousSettings = (BookingXmlExportSettings)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.PREVIOUS_EXPORT_SETTINGS);
        Map productMap = (Map)ctx.getMandatoryObject((Enum)IBusBookingContextKeys.VALID_PRODUCTS);
        BusProductExport productExport = new BusProductExport();
        root.getProducts().add(productExport);
        this.updateProductExport(productExport, product);
        BusProductExport previousProductExport = null;
        BaseProduct previousProduct = (BaseProduct)productMap.get(product);
        if (previousProduct instanceof BusProduct) {
            previousProductExport = new BusProductExport();
            this.updateProductExport(previousProductExport, (BusProduct)previousProduct);
        }
        productExport.setModified(Boolean.valueOf(BookingXmlExportHelper.isBaseEntityExportModified((BaseEntityExport)productExport, (BaseEntityExport)previousProductExport, (BookingXmlExportSettings)settings, (BookingXmlExportSettings)previousSettings)));
    }

    private void updateProductExport(BusProductExport productExport, BusProduct product) {
        boolean negate;
        ProductStatus status = product.getStatus();
        boolean bl = negate = ProductStatus.EXCHANGE.equals((Object)status) || ProductStatus.REFUND.equals((Object)status);
        if (product.getPreviousProduct() != null && ProductStatus.SELL == product.getPreviousProduct().getStatus()) {
            productExport.setPreviousSellProductUid(product.getPreviousProduct().getUid());
        }
        String currency = product.getGdsCurrency() != null ? product.getGdsCurrency() : DictHelper.getEquivCurrency();
        productExport.setUid(product.getUid());
        productExport.setStatus(MetadataBasedExportHelper.convertEnum((Enum)product.getStatus()));
        productExport.setBlankOwner(MetadataBasedExportHelper.convertOrganization((EntityReference)product.getBlankOwner()));
        productExport.setSystemNumber(product.getSystemNumber());
        productExport.setTicketType(MetadataBasedExportHelper.convertEnum((Enum)product.getTicketType()));
        productExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference)product.getAgent()));
        productExport.setSalesPoint(MetadataBasedExportHelper.convertSalesPoint((EntityReference)product.getSalesPoint()));
        productExport.setSubagency(MetadataBasedExportHelper.convertOrganization((EntityReference)BusProductHelper.getSubagency((BusProduct)product)));
        productExport.setAgency(MetadataBasedExportHelper.convertOrganization((EntityReference)BusProductHelper.getAgency((BusProduct)product)));
        productExport.setIssueDate(product.getIssueDate());
        productExport.setSupplier(MetadataBasedExportHelper.convertSupplier((EntityReference)BusProductHelper.getSupplier((BusProduct)product)));
        productExport.setContractRulesApplied(Boolean.valueOf(product.isContractRulesApplied()));
        productExport.setCompleted(Boolean.valueOf(product.isCompleted()));
        productExport.setChecked(Boolean.valueOf(product.isChecked()));
        productExport.setStatisticalData(MetadataBasedExportHelper.convertStatisticalData((BaseProduct)product));
        productExport.setComments(product.getComments());
        for (Object traveller : product.getTravellers()) {
            TravellerExport travellerExport = new TravellerExport();
            travellerExport.setName(traveller.getName());
            travellerExport.setNameInGds(traveller.getNameInGds());
            travellerExport.setNameInCyrillic(traveller.getCyrillicName());
            if (traveller.getPassenger() != null) {
                travellerExport.setPassengerUid(traveller.getPassenger().getUid());
                EntityContainer personCtr = EntityStorage.get().resolve(traveller.getPassenger());
                if (personCtr != null) {
                    travellerExport.setCode(((Person)personCtr.getEntity()).getCode());
                }
            }
            productExport.getTravellers().add(travellerExport);
        }
        productExport.setFare(MetadataBasedExportHelper.convertMoney((Money)product.getFare(), (boolean)negate));
        BigDecimal equivalentFare = product.getEquivalentFare();
        if (equivalentFare != null) {
            productExport.setEquivalentFare(negate ? equivalentFare.negate() : equivalentFare);
        }
        productExport.setPenalty(product.getPenalty());
        if (product.getPenaltyVatValue() != null) {
            productExport.setPenaltyVatValue(product.getPenaltyVatValue().getAmount());
        }
        if (product.getEquivalentFareVatValue() != null) {
            productExport.setEquivalentFareVatValue(product.getEquivalentFareVatValue().getAmount());
        }
        for (BusTax tax : product.getTaxes()) {
            VatValue equivalentVatValue;
            BusTaxExport taxExport = new BusTaxExport();
            BigDecimal equivalentAmount = tax.getEquivalentAmount();
            if (equivalentAmount != null) {
                taxExport.setEquivalentAmount(negate ? equivalentAmount.negate() : equivalentAmount);
            }
            if ((equivalentVatValue = tax.getEquivalentVatValue()) != null) {
                BigDecimal equivalentVatAmount = equivalentVatValue.getAmount();
                if (equivalentVatAmount != null) {
                    taxExport.setEquivalentVatAmount(negate ? equivalentVatAmount.negate() : equivalentVatAmount);
                }
                if (equivalentVatValue.getRate() != null) {
                    taxExport.setEquivalentVatRate(BigDecimal.valueOf(equivalentVatValue.getRate()));
                }
            }
            taxExport.setEquivalentCurrency(currency);
            productExport.getTaxes().add(taxExport);
        }
        productExport.setPaymentCode(GeneralProductHelper.getPaymentCode((BaseProduct)product));
        for (BusSegment segment : product.getSegments()) {
            BusStation departureStation;
            BusProductSegmentExport segmentExport = new BusProductSegmentExport();
            segmentExport.setNumber(segment.getNumber());
            segmentExport.setBrand(segment.getBrand());
            segmentExport.setArrivalLocation(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getArrival()));
            segmentExport.setDepartureLocation(MetadataBasedExportHelper.convertDictionary((DictionaryReference)segment.getDeparture()));
            BusStation arrivalStation = (BusStation)DictionaryCache.get().resolveReference(segment.getArrival());
            if (arrivalStation != null) {
                segmentExport.setArrivalCity(MetadataBasedExportHelper.convertDictionary((DictionaryReference)arrivalStation.getCity()));
                segmentExport.setArrivalCountry(MetadataBasedExportHelper.convertDictionary((DictionaryReference)arrivalStation.getCountry()));
            }
            if ((departureStation = (BusStation)DictionaryCache.get().resolveReference(segment.getDeparture())) != null) {
                segmentExport.setDepartureCity(MetadataBasedExportHelper.convertDictionary((DictionaryReference)departureStation.getCity()));
                segmentExport.setDepartureCountry(MetadataBasedExportHelper.convertDictionary((DictionaryReference)departureStation.getCountry()));
            }
            segmentExport.setArrivalDate(segment.getArrivalDate());
            segmentExport.setDepartureDate(segment.getDepartureDate());
            String places = segment.getPlaces().stream().filter(TextUtil::nonBlank).collect(Collectors.joining(", "));
            if (TextUtil.nonBlank((String)places)) {
                segmentExport.setPlaces(places);
            }
            segmentExport.setWayTimeMinutes(segment.getWayTimeMinutes());
            segmentExport.getServices().addAll(segment.getServices().stream().map(item -> {
                ReferenceItemExport itemExport = new ReferenceItemExport();
                itemExport.setValue(MetadataBasedExportHelper.convertEnum((Enum)item));
                return itemExport;
            }).collect(Collectors.toList()));
            productExport.getSegments().add(segmentExport);
        }
        List contractRelations = BusProductHelper.getContractRelations((BusProduct)product);
        for (GeneralProductContractRelationData contractRelation : contractRelations) {
            BookingXmlExportHelper.setContract((BaseContractRelationData)contractRelation, arg_0 -> ((BusProductExport)productExport).setClientContract(arg_0), arg_0 -> ((BusProductExport)productExport).setSubagencyContract(arg_0), arg_0 -> ((BusProductExport)productExport).setVendorContract(arg_0), arg_0 -> ((BusProductExport)productExport).setTechnicalProviderContract(arg_0));
            List fops = MetadataBasedExportHelper.getSortedFops((List)contractRelation.getFops());
            for (GeneralProductFop fop : fops) {
                ReferenceItemExport commissionExport;
                Object card;
                FopExport fopExport = new FopExport();
                productExport.getFops().add(fopExport);
                FopDetalization fopDetalization = Optional.ofNullable(product.getFopDetalizations().get(fop.getUid())).orElse(new FopDetalization());
                fopExport.setContractType(MetadataBasedExportHelper.convertEnum((Enum)GeneralProductHelper.getContractType((EntityReference)contractRelation.getDescription())));
                fopExport.setAgreementType(MetadataBasedExportHelper.convertEnum((Enum)GeneralProductHelper.getAgreementType((BaseContractRelationData)contractRelation)));
                fopExport.setCategory(BookingExportBusProductFillHeaderProcessor.getFopCategory(fop));
                fopExport.setPaymentType(MetadataBasedExportHelper.convertEnum((Enum)fop.getType()));
                fopExport.setAmount(MetadataBasedExportHelper.convertMoney((Money)MoneyHelper.buildMoney((BigDecimal)fop.getEquivalentAmount(), (String)currency), (boolean)negate));
                PaymentType paymentType = fop.getType();
                if (paymentType != null && paymentType.name().startsWith("CREDIT_CARD")) {
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setDetails(MetadataBasedExportHelper.convertEnum((Enum)card.getVendor()));
                        fopExport.setCardNumber(card.getNumber());
                        fopExport.setCardExpirationDate(card.getExpiration());
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                } else {
                    fopExport.setDetails((ObjectReferenceExport)(paymentType == PaymentType.CREDIT || paymentType == PaymentType.INTERLINE || paymentType == PaymentType.MTD ? MetadataBasedExportHelper.convertEnum((Enum)fop.getPassengerStatus()) : null));
                    fopExport.setNumber(fop.getRelatedTicketNumber());
                    card = fop.getCard();
                    if (card != null) {
                        fopExport.setCardSecurityCode(card.getSecurityCode());
                    }
                }
                fopExport.setOperationDate(fop.getOperationDate());
                fopExport.setAgent(MetadataBasedExportHelper.convertPerson((EntityReference)fop.getAgent()));
                fopExport.setRefused(Boolean.valueOf(fop.isRefused()));
                fopExport.setPayer(MetadataBasedExportHelper.convertOrganization((EntityReference)fop.getPayer()));
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, null)) {
                    commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                    fopExport.getServiceFees().add(commissionExport);
                }
                for (GeneralProductCommission commission : GeneralProductHelper.filterCommissions((Collection)fop.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, null, null)) {
                    commissionExport = new ReferenceItemExport();
                    commissionExport.setValue(MetadataBasedExportHelper.convertCommission((BaseCommission)commission));
                }
                List components = MetadataBasedExportHelper.getSortedFopComponents((List)fopDetalization.getComponents());
                for (FopComponent component : components) {
                    FopComponentExport componentExport = MetadataBasedExportHelper.convertFopComponent((FopComponent)component, (boolean)negate);
                    fopExport.getFopComponents().add(componentExport);
                }
            }
        }
    }

    private static ObjectReferenceExport getFopCategory(GeneralProductFop fop) {
        ObjectReferenceExport result = new ObjectReferenceExport();
        if (!GeneralProductHelper.isServiceFop((GeneralProductFop)fop)) {
            boolean payment = false;
            boolean discount = false;
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    payment = true;
                    break;
                }
                if (commission.getCommissionProperties() == null || !GeneralProductHelper.discountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                discount = true;
                break;
            }
            if (payment) {
                result.setCode("PAYMENT_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440 \u0437\u0430 \u043e\u043f\u043b\u0430\u0442\u0443");
            } else if (discount) {
                result.setCode("DISCOUNT");
                result.setCaption("\u0421\u043a\u0438\u0434\u043a\u0430");
            } else {
                result.setCode("SERVICE_FEE");
                result.setCaption("\u0421\u0431\u043e\u0440");
            }
        } else {
            result.setCode("PRODUCT");
            result.setCaption("\u041f\u0440\u043e\u0434\u0443\u043a\u0442");
        }
        return result;
    }
}

