/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.handlers;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.model.handlers.finance.BillingTransactionHandlersHelper;
import com.gridnine.xtrip.server.model.handlers.finance.ProductBillingTransactionsHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BusBillingTransactionHandler
implements ProductBillingTransactionsHandler<BusProduct> {
    public ProductType getProductType(BusProduct product) {
        return HandlersRegistry.get().findProductHandler(BusProduct.class).getProductType((BaseProduct)product);
    }

    public Class<BusProduct> getProductClass() {
        return BusProduct.class;
    }

    public TicketType getTicketType(BusProduct product) {
        return product.getTicketType();
    }

    public ProductStatus getStatus(BusProduct product) {
        return product.getStatus();
    }

    public BillingTransactionStatus getBillingTransactionStatus(BusProduct product) {
        return BillingTransactionStatus.ACTIVE;
    }

    public List<ProductBillingTransactionsHandler.FopData> getClientFops(BusProduct product) {
        GeneralProductContractRelationData contractRelation = BusProductHelper.getClientContractRelation((BusProduct)product);
        List fops = contractRelation != null ? BillingTransactionHandlersHelper.getFops((List)contractRelation.getFops(), (DictionaryReference)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
        return fops;
    }

    public List<ProductBillingTransactionsHandler.FopData> getSubagentFops(BusProduct product) {
        GeneralProductContractRelationData contractRelation = BusProductHelper.getSubagentContractRelation((BusProduct)product, (boolean)false);
        return contractRelation != null ? BillingTransactionHandlersHelper.getFops((List)contractRelation.getFops(), (DictionaryReference)contractRelation.getGeneralData().getCurrency()) : Collections.emptyList();
    }

    public List<ProductBillingTransactionsHandler.FopData> getVendorFops(BusProduct product) {
        return Collections.emptyList();
    }

    public String getShortName(BusProduct product) {
        return HandlersRegistry.get().findProductHandler(BusProduct.class).generateShortProductName((BaseProduct)product);
    }

    public EntityReference<Organization> getSupplier(BusProduct product) {
        return GeneralProductHelper.getSupplier((BaseProduct)product);
    }

    public EntityReference<Organization> getAgency(BusProduct product) {
        return GeneralProductHelper.getAgency((BaseProduct)product);
    }

    public EntityReference<Organization> getSubagency(BusProduct product) {
        return GeneralProductHelper.getSubagency((BaseProduct)product);
    }

    public EntityReference<SalesPoint> getSalesPoint(BusProduct product) {
        return product.getSalesPoint();
    }

    public boolean isCreateForRetail() {
        return false;
    }

    public Collection<PaymentType> getAllowedPaymentTypes() {
        return Collections.emptyList();
    }
}

