/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.handlers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusProductIndex;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.server.model.handlers.validation.GeneralProductValidationHelper;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationContext;
import com.gridnine.xtrip.server.model.handlers.validation.ProductValidationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BusProductValidationHandler
implements ProductValidationHandler<BusProduct> {
    public Class<BusProduct> getProductClass() {
        return BusProduct.class;
    }

    public void validate(BusProduct product, ProductValidationContext ctx) throws Exception {
        List messages = product.getValidationMessages();
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.OTHER);
        MessageHelper.removeMessages((Collection)messages, (ValidationMessageCategory)ValidationMessageCategory.STATISTICS);
        if (product.getTicketType() == TicketType.FAKE) {
            return;
        }
        GeneralProductValidationHelper.getAllValidationMessages((BaseProduct)product, (GeneralProductValidationHelper.ProductIndexProvider)new GeneralProductValidationHelper.ProductIndexProvider<BookingFile, BusProductIndex>(){

            public Class<BusProductIndex> getIndexClass() {
                return BusProductIndex.class;
            }

            public String getSystemNumberIndexPropertyName() {
                return BusProductIndex.Property.systemNumber.name();
            }

            public String getStatusIndexPropertyName() {
                return BusProductIndex.Property.status.name();
            }

            public String getProductTypeIndexPropertyName() {
                return BusProductIndex.Property.ticketType.name();
            }

            public Collection<SearchCriterion> getAdditionalSystemNumberCriterions() {
                return Collections.emptyList();
            }

            public boolean hasEquivalentFare() {
                return true;
            }

            public boolean hasTicketType() {
                return true;
            }

            public boolean hasBlankOwner() {
                return true;
            }

            public boolean hasSubagency() {
                return true;
            }
        }, (List)messages, (ProductValidationContext)ctx);
        if (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING) {
            return;
        }
    }
}

