/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.helpers.clone;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.server.model.helpers.clone.ProductCloneHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BusProductCloneHelper {
    public static void clone(BusProduct source, BusProduct target) throws Exception {
        ProductCloneHelper.clone((BaseProduct)source, (BaseProduct)target, (ProductCloneHelper.ProductCloneSourceHandler)new BusProductCloneSourceHandler(), (ProductCloneHelper.ProductCloneTargetHandler)new BusProductCloneTargetHandler());
    }

    public static void clone(BusProduct source, BusProduct target, Map<String, String> uidsMapping) throws Exception {
        ProductCloneHelper.clone((BaseProduct)source, (BaseProduct)target, uidsMapping, (ProductCloneHelper.ProductCloneSourceHandler)new BusProductCloneSourceHandler());
    }

    public static class BusProductCloneTargetHandler
    implements ProductCloneHelper.ProductCloneTargetHandler<BusProduct> {
        public void update(BusProduct product) {
            product.setPenalty(null);
            product.setContractRulesApplied(false);
            product.setCompleted(false);
            product.setShipmentsDate(null);
            product.getPrepaymentDocuments().clear();
            product.getFopDetalizations().clear();
        }
    }

    public static class BusProductCloneSourceHandler
    implements ProductCloneHelper.ProductCloneSourceHandler<BusProduct> {
        private Reservation reservation;
        private BusProduct previousProduct;
        private BusProduct nextProduct;
        private final List<Traveller> travellers = new ArrayList<Traveller>();

        public void before(BusProduct product, boolean cloneTraveller) {
            this.reservation = product.getReservation();
            this.previousProduct = product.getPreviousProduct();
            this.nextProduct = product.getNextProduct();
            this.travellers.clear();
            this.travellers.addAll(product.getTravellers());
            product.setReservation(null);
            product.setPreviousProduct(null);
            product.setNextProduct(null);
            if (!cloneTraveller) {
                product.getTravellers().clear();
            }
        }

        public void after(BusProduct product) {
            product.setReservation(this.reservation);
            product.setPreviousProduct(this.previousProduct);
            product.setNextProduct(this.nextProduct);
            product.getTravellers().clear();
            product.getTravellers().addAll(this.travellers);
        }
    }
}

