/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.bus.model.Bus;
import com.gridnine.xtrip.common.bus.model.BusReservationCreationParameters;
import com.gridnine.xtrip.common.bus.model.BusSearchParameters;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.MultiException;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.bus.ibus.IBusBusContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class BusStackTraceEnricherAdvice
extends BaseAdvice {
    private final String nullString = "[null]";
    private static FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy");

    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        Boolean stackTraceEnriched = (Boolean)ctx.getObject((Enum)IBusBusContextKeys.BUS_STACK_TRACE_ENRICHED);
        if (BooleanUtils.isTrue((Boolean)stackTraceEnriched)) {
            return false;
        }
        try {
            BusSearchParameters searchBusesParams = (BusSearchParameters)ctx.getObject((Enum)IBusBusContextKeys.BUS_SEARCH_PARAMETERS);
            EntityContainer gdsAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            Bus bus = (Bus)ctx.getObject((Enum)IBusBusContextKeys.BUS);
            BusReservationCreationParameters bookingParams = (BusReservationCreationParameters)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
            ArrayList<StackTraceElement> addElements = new ArrayList<StackTraceElement>();
            addElements.add(IncidentsHelper.getContextStackTraceElement((String)"GdsAccount", (String)this.gdsAccountToString((EntityContainer<BaseGdsAccount>)gdsAccountCtr)));
            if (searchBusesParams != null) {
                addElements.add(IncidentsHelper.getContextStackTraceElement((String)"searchBusesParams", (String)this.searchBusesParamsToString(searchBusesParams)));
            }
            if (bus == null && bookingParams != null) {
                bus = bookingParams.getBus();
            }
            if (bus != null) {
                addElements.add(IncidentsHelper.getContextStackTraceElement((String)"Bus", (String)this.busToString(bus)));
            }
            IncidentsHelper.addStackTraceElement((Throwable)e, (StackTraceElement[])addElements.toArray(new StackTraceElement[0]));
            ctx.putObject((Enum)IBusBusContextKeys.BUS_STACK_TRACE_ENRICHED, (Object)Boolean.TRUE);
        }
        catch (Throwable newEx) {
            throw new MultiException(new Throwable[]{newEx, e});
        }
        return false;
    }

    private String gdsAccountToString(EntityContainer<BaseGdsAccount> gdsAccountCtr) {
        if (gdsAccountCtr == null) {
            return "[null]";
        }
        return ((BaseGdsAccount)gdsAccountCtr.getEntity()).getName();
    }

    private String searchBusesParamsToString(BusSearchParameters params) {
        if (params == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DictHelper.getCode((DictionaryReference)params.getDeparture())).append("-").append(DictHelper.getCode((DictionaryReference)params.getArrival()));
        sb.append(" ").append(params.getDate() == null ? null : DF.format(params.getDate()));
        if (params.getBackDate() != null) {
            sb.append("/").append(DF.format(params.getBackDate()));
        }
        return sb.toString();
    }

    private String busToString(Bus bus) {
        BusSegment firstSegment = (BusSegment)bus.getSegments().get(0);
        BusSegment lastSegment = (BusSegment)CollectionUtil.getLastElement((List)bus.getSegments());
        if (bus == null) {
            return "[null]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(firstSegment.getDeparture().getCode()).append("[").append((CharSequence)this.getStationCaption((DictionaryReference<BusStation>)firstSegment.getDeparture())).append("]").append("-").append(lastSegment.getArrival().getCode()).append("[").append((CharSequence)this.getStationCaption((DictionaryReference<BusStation>)lastSegment.getArrival())).append("]");
        sb.append(" ").append(DF.format(firstSegment.getDepartureDate()));
        sb.append("#").append(firstSegment.getNumber());
        return sb.toString();
    }

    private StringBuilder getStationCaption(DictionaryReference<BusStation> station) {
        StringBuilder result = new StringBuilder();
        result.append(station.getCaption());
        if (TextUtil.isBlank((String)result.toString())) {
            result.append(((BusStation)DictionaryCache.get().resolveReference(station)).getTranslations().entrySet().stream().filter(Objects::nonNull).findFirst().map(entry -> (String)entry.getValue()));
        }
        return result;
    }
}

