/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus;

import com.gridnine.xtrip.common.bus.model.Bus;
import com.gridnine.xtrip.common.bus.model.BusValidationMessages;
import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.DictValidationHelper;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BusValidationHelper {
    public static int SALES_DEPTH_DAYS = 30;
    public static int PASSENGERS_MAX_COUNT = 9;
    public static int MAX_CHILD_AGE = 12;
    public static List<PassportType> GENERAL_ADULT_PASSPORT_TYPES = Arrays.asList(PassportType.INTERNAL, PassportType.FOREIGN, PassportType.PASSPORT, PassportType.SEAMANSID, PassportType.BIRTHDAY_NOTIFICATION);
    public static List<PassportType> GENERAL_CHILD_PASSPORT_TYPES = Arrays.asList(PassportType.BIRTHDAY_NOTIFICATION, PassportType.FOREIGN, PassportType.PASSPORT);

    public static void validateDepartuteAndArrival(DictionaryReference<BusStation> departure, DictionaryReference<BusStation> arrival, Collection<ValidationMessage> departureMessages, Collection<ValidationMessage> arrivalMessages) {
        DictValidationHelper.validateDictRef(departure, departureMessages);
        DictValidationHelper.validateDictRef(arrival, arrivalMessages);
        if (departure != null && departure.equals(arrival)) {
            arrivalMessages.add(BusValidationMessages.getArrivalEqualsDeparture());
        }
    }

    public static void validateDate(Date departureDate, Collection<ValidationMessage> messages) {
        if (departureDate == null) {
            messages.add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            DateInterval di = new DateInterval(MiscUtil.clearTime((Date)new Date()), MiscUtil.clearTime((Date)departureDate));
            if (di.getDuration(5) < 0) {
                messages.add(BusValidationMessages.getPastDate());
            }
            if (di.getDuration(5) >= SALES_DEPTH_DAYS) {
                messages.add(BusValidationMessages.getDateExceedDaysFromNow((int)SALES_DEPTH_DAYS));
            }
        }
    }

    public static void validateSeats(List<SeatPreferences> seats, Collection<ValidationMessage> seatsValidationMessages) {
        if (seats.isEmpty()) {
            seatsValidationMessages.add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            if (GDSHelper.getTotalSeats(seats, (boolean)false) > PASSENGERS_MAX_COUNT) {
                seatsValidationMessages.add(BusValidationMessages.getMaxPassengersCountExceeded((int)PASSENGERS_MAX_COUNT));
            }
            if (GDSHelper.findAdultPassengerType(seats) == null) {
                seatsValidationMessages.add(GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
            }
        }
    }

    public static void validateChildrenAges(List<SeatPreferences> seats, List<Integer> childrenAges, Collection<ValidationMessage> seatsValidationMessages, Map<Integer, Collection<ValidationMessage>> childrenAgesListValidationMessages) {
        Map passengerTypesMap = GDSHelper.getPassengerTypesMap(seats);
        int childrenCount = MiscUtil.guarded((Integer)((Integer)passengerTypesMap.get(DictHelper.getChildPassengerType())));
        if (childrenCount != childrenAges.size()) {
            seatsValidationMessages.add(BusValidationMessages.getInvalidChildrenAgesSize());
        }
        for (int ind = 0; ind < childrenAges.size(); ++ind) {
            Collection messages;
            Integer childAge = childrenAges.get(ind);
            if (childAge == null) {
                messages = CollectionUtil.getOrAddList(childrenAgesListValidationMessages, (Object)ind);
                messages.add(StandardValidationMessages.getMissingRequiredValue());
                continue;
            }
            if (childAge < MAX_CHILD_AGE) continue;
            messages = CollectionUtil.getOrAddList(childrenAgesListValidationMessages, (Object)ind);
            messages.add(BusValidationMessages.getWrongAgeMoreThan((int)MAX_CHILD_AGE));
        }
    }

    public static void validateBus(Bus bus) {
        BusSegment firstSegment = (BusSegment)bus.getSegments().get(0);
        Bus.BusValidationContext busVC = bus.getValidationContext();
        BusSegment.BusSegmentValidationContext segmentVC = firstSegment.getValidationContext();
        BusValidationHelper.validateDate(firstSegment.getDepartureDate(), segmentVC.getDepartureDateValidationMessages());
        if (TextUtil.isBlank((String)firstSegment.getNumber())) {
            segmentVC.getNumberValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (TextUtil.isBlank((String)bus.getGdsId())) {
            busVC.getGdsIdValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        BusValidationHelper.validateSeats(bus.getSeats(), busVC.getSeatsValidationMessages());
        BusValidationHelper.validateChildrenAges(bus.getSeats(), bus.getChildrenAges(), bus.getValidationContext().getChildrenAgesValidationMessages(), bus.getValidationContext().getChildrenAgesListValidationMessages());
    }
}

