/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.bus.helpers.CommonBusHelper;
import com.gridnine.xtrip.common.bus.model.Bus;
import com.gridnine.xtrip.common.bus.model.BusReservationCreationParameters;
import com.gridnine.xtrip.common.bus.model.BusTraveller;
import com.gridnine.xtrip.common.bus.model.BusValidationMessages;
import com.gridnine.xtrip.common.gds.helper.AgeRestriction;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.system.StandardValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.bus.ibus.BusValidationHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class BusReservationCreationParametersValidator
extends BaseProcessor {
    private static final List<PassportType> PASSPORT_TYPES_FOR_RUS = Arrays.asList(PassportType.INTERNAL, PassportType.FOREIGN, PassportType.BIRTHDAY_NOTIFICATION, PassportType.MILITARYID);
    private static final List<PassportType> PASSPORT_TYPES_FOR_NOT_RUS = Arrays.asList(PassportType.PASSPORT);
    private static final List<PassportType> PASSPORT_TYPES_FOR_INTERNATIONAL = Arrays.asList(PassportType.FOREIGN, PassportType.PASSPORT);
    private static final List<String> INTERNAL_PASSPORT_COUNTRIES = Arrays.asList("RU", "BY", "KZ", "KG", "TJ", "\u0410\u0426");
    private static final int birthdayInternalMinYears = 14;
    private static final int birthdayNotificationMaxYears = 14;
    private static final int birthdayNotificationMaxMonths = 3;

    public void process(MessageContext ctx) {
        BusReservationCreationParameters params = (BusReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        this.validateParamsAndTravellers(travellers, params);
    }

    private void validateParamsAndTravellers(List<Traveller> travellers, BusReservationCreationParameters params) {
        BusValidationHelper.validateBus(params.getBus());
        List requestSeats = params.getPlacing().getSeats();
        List vacantSeats = ((BusSegment)params.getBus().getSegments().get(0)).getVacantSeats();
        if (!vacantSeats.containsAll(requestSeats)) {
            params.getPlacing().getValidationContext().getSeatsValidationMessages().add(StandardValidationMessages.getWrongValue());
        }
        if (params.getBusTravellers().isEmpty()) {
            params.getValidationContext().getBusTravellersValidationMessages().add(StandardValidationMessages.getEmptyCollection());
        } else {
            this.validateBusTravellers(travellers, params);
        }
    }

    protected void validateBusTravellers(List<Traveller> travellers, BusReservationCreationParameters params) {
        Bus bus = params.getBus();
        ArrayList searchChildrenAges = new ArrayList(bus.getChildrenAges());
        int childs = 0;
        for (BusTraveller busTraveller : params.getBusTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)busTraveller.getTravellerUid());
            if (traveller == null) {
                throw Xeption.forDeveloper((String)"traveller with uid '{0}' referenced in parameters for gds account '{1}' not found in context", (Object[])new Object[]{busTraveller.getTravellerUid(), params.getGdsAccount()});
            }
            this.validateTraveller(traveller, busTraveller, params);
            if (DictHelper.isAdultPassengerType((DictionaryReference)busTraveller.getPassengerType())) continue;
            ++childs;
            Integer age = this.calcAge(traveller, bus);
            if (!Objects.nonNull(age)) continue;
            int ind = searchChildrenAges.indexOf(age);
            if (ind == -1) {
                traveller.getPassport().getValidationContext().getBirthdayValidationMessages().add(BusValidationMessages.getMissingChildAgeInSearch((int)age));
                continue;
            }
            searchChildrenAges.remove(ind);
        }
        Map passengerTypesMap = GDSHelper.getPassengerTypesMap((List)bus.getSeats());
        int searchChilds = MiscUtil.guarded((Integer)((Integer)passengerTypesMap.get(DictHelper.getChildPassengerType())));
        if (childs != searchChilds) {
            throw Xeption.forDeveloper((String)"\u041f\u0440\u0438 \u043f\u043e\u0438\u0441\u043a\u0435 \u0431\u044b\u043b\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0434\u0440\u0443\u0433\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0434\u0435\u0442\u0435\u0439 ({0}), \u0447\u0435\u043c \u043f\u0440\u0438 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 ({1}).", (Object[])new Object[]{searchChilds, childs});
        }
    }

    private Integer calcAge(Traveller traveller, Bus bus) {
        Passport passport = traveller.getPassport();
        if (Objects.isNull(passport) || Objects.isNull(passport.getBirthday())) {
            return null;
        }
        int years = (int)ChronoUnit.YEARS.between(DateUtils.toLocalDate((Date)passport.getBirthday()), DateUtils.toLocalDate((Date)((BusSegment)bus.getSegments().get(0)).getDepartureDate()));
        return years;
    }

    private void validateTraveller(Traveller traveller, BusTraveller busTraveller, BusReservationCreationParameters params) {
        Passport psp = traveller.getPassport();
        DictionaryReference passengerType = busTraveller.getPassengerType();
        if (psp == null) {
            traveller.getValidationContext().getPassportValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else if (passengerType == null) {
            busTraveller.getValidationContext().getPassengerTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            this.validatePassport(psp, (DictionaryReference<PassengerType>)passengerType, params);
        }
        this.validateEmail(traveller);
    }

    private void validateEmail(Traveller traveller) {
        Communication emailCommunication = ProfileHelper.getEmailCommunication((List)traveller.getCommunications());
        String emailString = ProfileHelper.getCommunicationEmail((Communication)emailCommunication);
        if (!TextUtil.isBlank((String)emailString) && !TextUtil.isValidEmailAddress((String)emailString)) {
            ArrayList<ValidationMessage> validationList = new ArrayList<ValidationMessage>();
            validationList.add(StandardValidationMessages.getWrongValue());
            traveller.getValidationContext().getCommunicationsListValidationMessages().put(traveller.getCommunications().indexOf(emailCommunication), validationList);
        }
    }

    private void validatePassport(Passport psp, DictionaryReference<PassengerType> passengerType, BusReservationCreationParameters params) {
        this.basicNameValidation(psp.getLastName(), psp.getType(), (DictionaryReference<Country>)psp.getCitizenship(), true, 30, psp.getValidationContext().getLastNameValidationMessages());
        this.basicNameValidation(psp.getFirstName(), psp.getType(), (DictionaryReference<Country>)psp.getCitizenship(), true, 20, psp.getValidationContext().getFirstNameValidationMessages());
        this.basicNameValidation(psp.getMiddleName(), psp.getType(), (DictionaryReference<Country>)psp.getCitizenship(), false, 20, psp.getValidationContext().getMiddleNameValidationMessages());
        this.validatePassportNumber(psp);
        this.validatePassportType(psp, passengerType, params.getBus());
        if (psp.getBirthday() == null) {
            psp.getValidationContext().getBirthdayValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            this.validateBirthDay(psp.getBirthday(), ((BusSegment)params.getBus().getSegments().get(0)).getDepartureDate(), passengerType, psp.getValidationContext().getBirthdayValidationMessages());
        }
        if (psp.getCitizenship() == null) {
            psp.getValidationContext().getCitizenshipValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (psp.getGender() == null) {
            psp.getValidationContext().getGenderValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
    }

    private void basicNameValidation(String name, PassportType passportType, DictionaryReference<Country> citizenship, boolean notEmpty, int maxLength, Collection<ValidationMessage> validationMessages) {
        String newName;
        String string = newName = TextUtil.isBlank((String)name) ? null : name.replaceAll(" ", "");
        if (TextUtil.isBlank((String)newName)) {
            if (notEmpty) {
                validationMessages.add(StandardValidationMessages.getMissingRequiredValue());
            }
            return;
        }
        if (!newName.equals("-") || notEmpty) {
            if (maxLength > 0 && name.length() > maxLength) {
                validationMessages.add(BusValidationMessages.getIvalidTextLength((int)maxLength));
                return;
            }
            if (newName.startsWith("-")) {
                validationMessages.add(BusValidationMessages.getNotAllowedHyphenAsFirstSymbol());
                return;
            }
            if (passportType != null) {
                switch (passportType) {
                    case INTERNAL: 
                    case BIRTHDAY_NOTIFICATION: {
                        if (newName.matches("[\u0430-\u044f\u0410-\u042f\u0451\u0401\\-]*")) break;
                        validationMessages.add(BusValidationMessages.getOnlyCyrillicAllowedForDocumentTypeFio());
                        break;
                    }
                    case PASSPORT: {
                        if (newName.matches("[a-zA-Z\\-]*") || citizenship != null && "BY".equals(citizenship.getCode())) break;
                        validationMessages.add(BusValidationMessages.getOnlyLatinAllowedForDocumentTypeFio());
                        break;
                    }
                    default: {
                        if (newName.matches("[a-zA-Z\\-]*")) break;
                        validationMessages.add(BusValidationMessages.getOnlyLatinAllowedForDocumentTypeFio());
                    }
                }
            }
        }
    }

    private void validatePassportNumber(Passport psp) {
        if (TextUtil.isBlank((String)psp.getNumber())) {
            psp.getValidationContext().getNumberValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        }
        if (psp.getType() == null || TextUtil.isBlank((String)psp.getNumber())) {
            return;
        }
        switch (psp.getType()) {
            case INTERNAL: {
                if (psp.getNumber().matches("^\\d{10}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(BusValidationMessages.getIvalidValueOnlyFixedNumbers((int)10));
                break;
            }
            case FOREIGN: {
                if (psp.getNumber().matches("^\\d{9}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(BusValidationMessages.getIvalidValueOnlyFixedNumbers((int)9));
                break;
            }
            case BIRTHDAY_NOTIFICATION: {
                if (BooleanUtils.isNotTrue((Boolean)this.getRusCitizenship(psp)) || psp.getNumber().matches("M{0,4}(CM|CD|D?C{0,3})(XC|XL|L?X{0,3})(IX|IV|V?I{0,3})[\u0430-\u044f\u0410-\u042f\u0451\u0401]{2}\\d{6}")) break;
                psp.getValidationContext().getNumberValidationMessages().add(BusValidationMessages.getIvalidValueBirthdayNotificationNumber());
                break;
            }
            case SEAMANSID: {
                if (psp.getNumber().matches("^[\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z0-9]{2}\\d{7}$")) break;
                psp.getValidationContext().getNumberValidationMessages().add(BusValidationMessages.getIvalidValueFixedLettersAndNumbers((int)2, (int)7));
                break;
            }
            case PASSPORT: {
                String oneD = ".*[0-9].*";
                String onlyLatin = "[a-zA-Z]+";
                String validSmb = "[\u0430-\u044f\u0410-\u042f\u0451\u0401a-zA-Z0-9]{1,16}";
                if (psp.getNumber().matches("((" + oneD + ")|(" + onlyLatin + "))") && psp.getNumber().matches(validSmb)) break;
                psp.getValidationContext().getNumberValidationMessages().add(BusValidationMessages.getIvalidValuePassportNumber());
                break;
            }
        }
    }

    private void validatePassportType(Passport passport, DictionaryReference<PassengerType> passengerType, Bus bus) {
        if (bus == null) {
            return;
        }
        if (passport.getType() == null) {
            passport.getValidationContext().getTypeValidationMessages().add(StandardValidationMessages.getMissingRequiredValue());
        } else {
            String citizenshipCode = this.getCitizenshipCode(passport);
            if (citizenshipCode != null) {
                boolean isRusCitizenship = this.isRusCitizenship(citizenshipCode);
                if (PASSPORT_TYPES_FOR_NOT_RUS.contains(passport.getType()) && isRusCitizenship) {
                    passport.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectDocumentTypeForCitizenship());
                } else if (PASSPORT_TYPES_FOR_RUS.contains(passport.getType()) && !isRusCitizenship) {
                    passport.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectDocumentTypeForCitizenship());
                }
            }
            if (passport.getType() == PassportType.INTERNAL || passport.getType() == PassportType.BIRTHDAY_NOTIFICATION) {
                if (!this.isInternalPassportAvailable(bus)) {
                    passport.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectDocumentTypeForBus());
                }
            } else {
                boolean internationalBus = this.isInternationalBus(bus);
                if (internationalBus && !PASSPORT_TYPES_FOR_INTERNATIONAL.contains(passport.getType())) {
                    passport.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectDocumentTypeForBus());
                }
            }
            if (DictHelper.isAdultPassengerType(passengerType)) {
                if (!BusValidationHelper.GENERAL_ADULT_PASSPORT_TYPES.contains(passport.getType())) {
                    passport.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectDocumentType());
                }
            } else if (!BusValidationHelper.GENERAL_CHILD_PASSPORT_TYPES.contains(passport.getType())) {
                passport.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectDocumentType());
            }
            this.validatePassportTypeByBirthday(passport, bus);
        }
    }

    private void validateBirthDay(Date birthday, Date departureDate, DictionaryReference<PassengerType> passengerType, Collection<ValidationMessage> messages) {
        if (new Date().before(birthday)) {
            messages.add(StandardValidationMessages.getWrongValue());
        }
        AgeRestriction ageRestriction = this.getAgeRestriction(passengerType);
        ageRestriction.validate(birthday, departureDate, messages);
    }

    private AgeRestriction getAgeRestriction(DictionaryReference<PassengerType> passengerType) {
        if (DictHelper.isAdultPassengerTypeCategory(passengerType)) {
            return new AgeRestriction(Integer.valueOf(BusValidationHelper.MAX_CHILD_AGE), null, Integer.valueOf(100), Boolean.FALSE);
        }
        return new AgeRestriction(null, null, Integer.valueOf(BusValidationHelper.MAX_CHILD_AGE), Boolean.FALSE);
    }

    private Boolean getRusCitizenship(Passport passport) {
        String citizenshipCode = this.getCitizenshipCode(passport);
        if (citizenshipCode == null) {
            return null;
        }
        return this.isRusCitizenship(citizenshipCode);
    }

    private String getCitizenshipCode(Passport passport) {
        if (passport == null || passport.getCitizenship() == null) {
            return null;
        }
        return passport.getCitizenship().getCode();
    }

    private boolean isRusCitizenship(String citizenshipCode) {
        return "RU".equalsIgnoreCase(citizenshipCode);
    }

    protected boolean isInternationalBus(Bus bus) {
        return bus.getSegments().stream().anyMatch(seg -> BooleanUtils.isFalse((Boolean)CommonBusHelper.isRussiaStation((DictionaryReference)seg.getDeparture())) || BooleanUtils.isFalse((Boolean)CommonBusHelper.isRussiaStation((DictionaryReference)seg.getArrival())));
    }

    private boolean isInternalPassportAvailable(Bus bus) {
        DictionaryReference countryFrom = CommonBusHelper.getStationCountry(this.getBusStationFrom(bus));
        DictionaryReference countryTo = CommonBusHelper.getStationCountry(this.getBusStationTo(bus));
        if (countryFrom == null || countryTo == null) {
            return false;
        }
        return INTERNAL_PASSPORT_COUNTRIES.contains(countryTo.getCode()) && INTERNAL_PASSPORT_COUNTRIES.contains(countryFrom.getCode());
    }

    protected DictionaryReference<BusStation> getBusStationFrom(Bus bus) {
        BusSegment firstSeg = (BusSegment)bus.getSegments().get(0);
        return firstSeg.getDeparture();
    }

    protected DictionaryReference<BusStation> getBusStationTo(Bus bus) {
        BusSegment lastSeg = (BusSegment)bus.getSegments().get(bus.getSegments().size() - 1);
        return lastSeg.getArrival();
    }

    private void validatePassportTypeByBirthday(Passport psp, Bus bus) {
        Period age;
        Date departureDate = ((BusSegment)bus.getSegments().get(0)).getDepartureDate();
        if (departureDate == null || psp.getBirthday() == null) {
            return;
        }
        if (psp.getType() == PassportType.INTERNAL && (age = Period.between(DateUtils.toLocalDate((Date)psp.getBirthday()), DateUtils.toLocalDate((Date)departureDate))).getYears() < 14) {
            psp.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectAgeForInternalDocument((int)14));
        }
        if (psp.getType() == PassportType.BIRTHDAY_NOTIFICATION && (age = Period.between(DateUtils.toLocalDate((Date)psp.getBirthday()), DateUtils.toLocalDate((Date)departureDate).minusDays(1L))).toTotalMonths() >= 171L) {
            psp.getValidationContext().getTypeValidationMessages().add(BusValidationMessages.getIncorrectAgeForBirthdayNotificationDocument((int)14, (int)3));
        }
    }
}

