/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.bus.ibus.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.bus.helpers.CommonBusHelper;
import com.gridnine.xtrip.common.bus.model.BaseBusAccount;
import com.gridnine.xtrip.common.bus.model.Bus;
import com.gridnine.xtrip.common.bus.model.BusFare;
import com.gridnine.xtrip.common.bus.model.BusReservationCreationParameters;
import com.gridnine.xtrip.common.bus.model.BusTraveller;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.bus.ibus.BusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class BusReservationFromParamsBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        BusReservationCreationParameters params = (BusReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        List travellers = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (accountCtr == null) {
            accountCtr = EntityStorage.get().resolve(params.getBus().getGdsAccount());
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)this.buildReservation(params, travellers, salesContext, (EntityContainer<? extends BaseBusAccount>)accountCtr));
    }

    private Reservation buildReservation(BusReservationCreationParameters params, List<Traveller> travellers, SalesContext salesContext, EntityContainer<? extends BaseBusAccount> gdsAccountCtr) {
        Bus bus = params.getBus();
        Reservation reservation = new Reservation();
        reservation.setUid(bus.getUid());
        reservation.setResDate(new Date());
        reservation.setSubagency(salesContext.getSubagency());
        reservation.setSalesPoint(salesContext.getSalesPoint());
        reservation.setBookingAgent(salesContext.getAgent());
        reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountCtr.toReference());
        ReservationGdsNameInfoHelper.setRulesGdsNameFromAccount((Reservation)reservation, gdsAccountCtr);
        BusTraveller firstTraveller = (BusTraveller)params.getBusTravellers().get(0);
        for (BusTraveller busTraveller : params.getBusTravellers()) {
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)busTraveller.getTravellerUid());
            BusFare busFare = Objects.requireNonNull(CommonBusHelper.findBusFare((List)bus.getFares(), (DictionaryReference)busTraveller.getPassengerType()));
            boolean createWithZeroPrice = busFare.isForAllPassengers() && !busTraveller.equals((Object)firstTraveller);
            BusProduct product = this.createProduct(bus, busFare, (BaseBusAccount)gdsAccountCtr.getEntity(), salesContext, createWithZeroPrice);
            product.setUid(BusHelper.buildTravellerBusFareKey(busFare, busTraveller));
            product.setPassengerType(busTraveller.getPassengerType());
            product.setTicketType(TicketType.FAKE);
            product.getTravellers().add(traveller);
            product.setReservation(reservation);
            reservation.getProducts().add(product);
        }
        return reservation;
    }

    private BusProduct createProduct(Bus bus, BusFare busFare, BaseBusAccount gdsAccount, SalesContext salesContext, boolean createWithZeroPrice) {
        Date curDate = new Date();
        BusProduct product = new BusProduct();
        product.setGdsId(bus.getGdsId());
        product.setTicketType(TicketType.OWN);
        product.setIssueDate(curDate);
        product.setStatus(ProductStatus.BOOKING);
        if (createWithZeroPrice) {
            product.setEquivalentFare(BigDecimal.ZERO);
            product.setGdsCurrency(bus.getGdsCurrency());
        } else {
            product.setEquivalentFare(busFare.getBaseFare().getValue());
            product.setGdsCurrency(busFare.getBaseFare().getCurrency());
        }
        product.setFareInfo(busFare.getFareInfo());
        BusProductHelper.setAgency((BusProduct)product, (EntityReference)salesContext.getAgency());
        BusProductHelper.setSubagency((BusProduct)product, (EntityReference)salesContext.getSubagency());
        BusProductHelper.setSupplier((BusProduct)product, (EntityReference)gdsAccount.getSupplier());
        product.setSalesPoint(salesContext.getSalesPoint());
        product.setAgent(salesContext.getAgent());
        product.setBlankOwner(gdsAccount.getBlankOwner());
        try {
            for (BusSegment segment : bus.getSegments()) {
                BusSegment cloneSegment = (BusSegment)XCloneHelper.clone((XCloneable)segment, (boolean)true);
                cloneSegment.getServices().addAll(segment.getServices());
                cloneSegment.setAddInfo(segment.getAddInfo());
                product.getSegments().add(cloneSegment);
            }
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"error in clone segment", (Throwable)ex, (Object[])new Object[0]);
        }
        GeneralProductHelper.updateFops((BaseProduct)product);
        return product;
    }
}

